/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Blocks;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.Dungeon;
import xiroc.dungeoncrawl.dungeon.DungeonBuilder;
import xiroc.dungeoncrawl.dungeon.DungeonFeatures;
import xiroc.dungeoncrawl.dungeon.DungeonLayerMap;
import xiroc.dungeoncrawl.dungeon.DungeonPieces;
import xiroc.dungeoncrawl.dungeon.DungeonStatTracker;
import xiroc.dungeoncrawl.dungeon.RandomFeature;
import xiroc.dungeoncrawl.dungeon.treasure.Treasure;
import xiroc.dungeoncrawl.util.Position2D;
import xiroc.dungeoncrawl.util.RotationHelper;

public class DungeonLayer {
    public DungeonPieces.DungeonPiece[][] segments;
    public Position2D start;
    public Position2D end;
    public int width;
    public int length;
    public DungeonStatTracker.LayerStatTracker statTracker;
    public DungeonLayerMap map;
    public int extraRooms;

    public DungeonLayer() {
        this(16, 16);
    }

    public DungeonLayer(int width, int length) {
        this.width = width;
        this.length = length;
        this.statTracker = new DungeonStatTracker.LayerStatTracker();
        this.segments = new DungeonPieces.DungeonPiece[this.width][this.length];
    }

    public void buildMap(DungeonBuilder builder, List<DungeonPieces.DungeonPiece> pieces, Random rand, Position2D start, int layer, boolean lastLayer) {
        if (!this.map.markPositionAsOccupied(start)) {
            DungeonCrawl.LOGGER.error("Failed to mark start [" + start.x + ", " + start.z + "] as occupied.");
        }
        this.start = start;
        this.end = lastLayer ? this.findLargeRoomPosWithMaxDistance(builder, start, layer) : this.map.getRandomFreePosition(rand);
        this.segments[start.x][start.z] = new DungeonPieces.StairsBot(null, DungeonPieces.DEFAULT_NBT);
        if (lastLayer) {
            if (this.end != null) {
                this.createLootRoom();
            } else {
                this.end = this.findLargeRoomPosAtArea(builder, this.map.getRandomFreePosition(rand), layer);
                if (this.end != null) {
                    this.createLootRoom();
                } else {
                    DungeonCrawl.LOGGER.debug("Failed to find a position for the loot room.");
                    this.end = this.forceLargeRoomPosWithMaxDistance(start);
                    this.createLootRoom();
                }
            }
        } else {
            this.segments[this.end.x][this.end.z] = new DungeonPieces.StairsTop(null, DungeonPieces.DEFAULT_NBT);
        }
        this.buildConnection(start, this.end);
    }

    public void extend(DungeonBuilder builder, DungeonLayerMap map, Random rand, int layer) {
        Tuple<Position2D, Rotation> sideRoomData;
        DungeonPieces.DungeonPiece room;
        int i;
        int additionalFeatures = (Integer)Config.LAYER_ADDITIONS_MIN.get() + rand.nextInt((Integer)Config.LAYER_ADDITIONS_EXTRA.get()) + this.extraRooms;
        Position2D[] additions = new Position2D[additionalFeatures];
        for (i = 0; i < additionalFeatures; ++i) {
            Position2D largeRoomPos;
            additions[i] = map.getRandomFreePosition(rand);
            if (additions[i] == null) {
                return;
            }
            if ((double)rand.nextFloat() < 0.5 && (largeRoomPos = DungeonLayer.getLargeRoomPos(this, new Position2D(additions[i].x, additions[i].z))) != null && DungeonFeatures.canPlacePieceWithHeight(builder, layer, additions[i].x, additions[i].z, 2, 2, 1, true)) {
                int roomID = RandomFeature.LARGE_ROOMS.roll(rand);
                DungeonPieces.Part part1 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                DungeonPieces.Part part2 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                DungeonPieces.Part part3 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                DungeonPieces.Part part4 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
                part1.treasureType = 0;
                part2.treasureType = 0;
                part3.treasureType = 0;
                part4.treasureType = 0;
                part1.field_186169_c = Rotation.NONE;
                part2.field_186169_c = Rotation.NONE;
                part3.field_186169_c = Rotation.NONE;
                part4.field_186169_c = Rotation.NONE;
                part4.walls = true;
                part3.walls = true;
                part2.walls = true;
                part1.walls = true;
                part1.set(roomID, 0, 0, 0, 8, 16, 8);
                part2.set(roomID, 8, 0, 0, 8, 16, 8);
                part3.set(roomID, 8, 0, 8, 8, 16, 8);
                part4.set(roomID, 0, 0, 8, 8, 16, 8);
                part1.setPosition(largeRoomPos.x, largeRoomPos.z);
                part2.setPosition(largeRoomPos.x + 1, largeRoomPos.z);
                part3.setPosition(largeRoomPos.x + 1, largeRoomPos.z + 1);
                part4.setPosition(largeRoomPos.x, largeRoomPos.z + 1);
                part1.sides[0] = false;
                part1.sides[1] = true;
                part1.sides[2] = true;
                part1.sides[3] = false;
                part2.sides[0] = false;
                part2.sides[1] = false;
                part2.sides[2] = true;
                part2.sides[3] = true;
                part3.sides[0] = true;
                part3.sides[1] = false;
                part3.sides[2] = false;
                part3.sides[3] = true;
                part4.sides[0] = true;
                part4.sides[1] = true;
                part4.sides[2] = false;
                part4.sides[3] = false;
                part1.openAdditionalSides(this.segments[largeRoomPos.x][largeRoomPos.z]);
                part2.openAdditionalSides(this.segments[largeRoomPos.x + 1][largeRoomPos.z]);
                part3.openAdditionalSides(this.segments[largeRoomPos.x + 1][largeRoomPos.z + 1]);
                part4.openAdditionalSides(this.segments[largeRoomPos.x][largeRoomPos.z + 1]);
                this.segments[largeRoomPos.x][largeRoomPos.z] = part1;
                this.segments[largeRoomPos.x + 1][largeRoomPos.z] = part2;
                this.segments[largeRoomPos.x + 1][largeRoomPos.z + 1] = part3;
                this.segments[largeRoomPos.x][largeRoomPos.z + 1] = part4;
                DungeonFeatures.mark(builder, layer, largeRoomPos.x, largeRoomPos.z, 2, 2, 1);
                continue;
            }
            room = new DungeonPieces.Room(null, DungeonPieces.DEFAULT_NBT);
            room.setPosition(additions[i].x, additions[i].z);
            if (this.segments[additions[i].x][additions[i].z] != null) {
                room.sides = this.segments[additions[i].x][additions[i].z].sides;
                room.connectedSides = this.segments[additions[i].x][additions[i].z].connectedSides;
            }
            this.segments[additions[i].x][additions[i].z] = room;
        }
        block5: for (i = 0; i < additionalFeatures; ++i) {
            Position2D one = additions[i];
            switch (rand.nextInt(2)) {
                case 0: {
                    this.buildConnection(rand.nextBoolean() ? this.start : this.end, one);
                    continue block5;
                }
                case 1: {
                    this.processAddition(additions, this.start, this.end, one, rand);
                }
            }
        }
        if (layer == 0 && (sideRoomData = this.findStarterRoomData(this.start)) != null) {
            room = new DungeonPieces.SideRoom(null, DungeonPieces.DEFAULT_NBT);
            ((DungeonPieces.SideRoom)room).modelID = 34;
            Direction dir = RotationHelper.translateDirection(Direction.WEST, (Rotation)sideRoomData.func_76340_b());
            room.openSide(dir);
            room.setPosition(((Position2D)sideRoomData.func_76341_a()).x, ((Position2D)sideRoomData.func_76341_a()).z);
            room.setRotation((Rotation)sideRoomData.func_76340_b());
            ((DungeonPieces.SideRoom)room).treasureType = Treasure.Type.SUPPLY;
            map.markPositionAsOccupied((Position2D)sideRoomData.func_76341_a());
            this.segments[((Position2D)sideRoomData.func_76341_a()).x][((Position2D)sideRoomData.func_76341_a()).z] = room;
            Position2D connectedSegment = ((Position2D)sideRoomData.func_76341_a()).shift(dir, 1);
            if (this.segments[connectedSegment.x][connectedSegment.z] != null) {
                this.segments[connectedSegment.x][connectedSegment.z].openSide(dir.func_176734_d());
                this.rotatePiece(this.segments[connectedSegment.x][connectedSegment.z]);
            }
        }
    }

    public void buildConnection(Position2D start, Position2D end) {
        block26: {
            int endZ;
            int endX;
            int startZ;
            int startX;
            block28: {
                block27: {
                    int z;
                    DungeonPieces.Corridor corridor;
                    block25: {
                        int z2;
                        DungeonPieces.Corridor corridor2;
                        startX = start.x;
                        startZ = start.z;
                        endX = end.x;
                        endZ = end.z;
                        if (startX == endX && startZ == endZ) {
                            return;
                        }
                        if (startX <= endX) break block25;
                        this.segments[startX][startZ].openSide(Direction.WEST);
                        for (int x = startX; x > (startZ == endZ ? endX + 1 : endX); --x) {
                            if (this.segments[x - 1][startZ] != null) {
                                this.segments[x - 1][startZ].openSide(x - 1 == endX ? (startZ < endZ ? Direction.SOUTH : Direction.NORTH) : Direction.WEST);
                                this.segments[x - 1][startZ].openSide(Direction.EAST);
                                this.rotatePiece(this.segments[x - 1][startZ]);
                                continue;
                            }
                            corridor2 = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                            corridor2.setPosition(x - 1, startZ);
                            corridor2.setRotation(x - 1 == endX ? RotationHelper.getRotationFromCW90DoubleFacing(startZ > endZ ? Direction.NORTH : Direction.SOUTH, Direction.EAST) : RotationHelper.getRotationFromFacing(Direction.WEST));
                            corridor2.openSide(x - 1 == endX ? (startZ < endZ ? Direction.SOUTH : Direction.NORTH) : Direction.WEST);
                            corridor2.openSide(Direction.EAST);
                            this.segments[x - 1][startZ] = corridor2;
                        }
                        if (startZ > endZ) {
                            this.segments[endX][endZ].openSide(Direction.SOUTH);
                            for (z2 = startZ; z2 > endZ + 1; --z2) {
                                if (this.segments[endX][z2 - 1] != null) {
                                    this.segments[endX][z2 - 1].openSide(Direction.SOUTH);
                                    this.segments[endX][z2 - 1].openSide(z2 - 1 == endZ ? Direction.WEST : Direction.NORTH);
                                    this.rotatePiece(this.segments[endX][z2 - 1]);
                                    continue;
                                }
                                corridor2 = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                                corridor2.setPosition(endX, z2 - 1);
                                corridor2.setRotation(z2 - 1 == endZ ? RotationHelper.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : RotationHelper.getRotationFromFacing(Direction.NORTH));
                                corridor2.openSide(Direction.SOUTH);
                                corridor2.openSide(z2 - 1 == endZ ? Direction.WEST : Direction.NORTH);
                                this.segments[endX][z2 - 1] = corridor2;
                            }
                        } else if (startZ < endZ) {
                            this.segments[endX][endZ].openSide(Direction.NORTH);
                            for (z2 = startZ; z2 < endZ - 1; ++z2) {
                                if (this.segments[endX][z2 + 1] != null) {
                                    this.segments[endX][z2 + 1].openSide(z2 + 1 == endZ ? Direction.WEST : Direction.SOUTH);
                                    this.segments[endX][z2 + 1].openSide(Direction.NORTH);
                                    this.rotatePiece(this.segments[endX][z2 + 1]);
                                    continue;
                                }
                                corridor2 = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                                corridor2.setPosition(endX, z2 + 1);
                                corridor2.setRotation(z2 + 1 == endZ ? RotationHelper.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : RotationHelper.getRotationFromFacing(Direction.SOUTH));
                                corridor2.openSide(z2 + 1 == endZ ? Direction.WEST : Direction.SOUTH);
                                corridor2.openSide(Direction.NORTH);
                                this.segments[endX][z2 + 1] = corridor2;
                            }
                        } else {
                            this.segments[endX][endZ].openSide(Direction.EAST);
                        }
                        break block26;
                    }
                    if (startX >= endX) break block27;
                    this.segments[startX][startZ].openSide(Direction.EAST);
                    for (int x = startX; x < (startZ == endZ ? endX - 1 : endX); ++x) {
                        if (this.segments[x + 1][startZ] != null) {
                            this.segments[x + 1][startZ].openSide(x + 1 == endX ? (startZ < endZ ? Direction.SOUTH : Direction.NORTH) : Direction.EAST);
                            this.segments[x + 1][startZ].openSide(Direction.WEST);
                            this.rotatePiece(this.segments[x + 1][startZ]);
                            continue;
                        }
                        corridor = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                        corridor.setPosition(x + 1, startZ);
                        corridor.setRotation(x + 1 == endX ? RotationHelper.getRotationFromCW90DoubleFacing(startZ > endZ ? Direction.NORTH : Direction.SOUTH, Direction.WEST) : RotationHelper.getRotationFromFacing(Direction.EAST));
                        corridor.openSide(x + 1 == endX ? (startZ < endZ ? Direction.SOUTH : Direction.NORTH) : Direction.EAST);
                        corridor.openSide(Direction.WEST);
                        this.segments[x + 1][startZ] = corridor;
                    }
                    if (startZ > endZ) {
                        this.segments[endX][endZ].openSide(Direction.SOUTH);
                        for (z = startZ; z > endZ + 1; --z) {
                            if (this.segments[endX][z - 1] != null) {
                                this.segments[endX][z - 1].openSide(Direction.SOUTH);
                                this.segments[endX][z - 1].openSide(z - 1 == endZ ? Direction.EAST : Direction.NORTH);
                                this.rotatePiece(this.segments[endX][z - 1]);
                                continue;
                            }
                            corridor = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                            corridor.setPosition(endX, z - 1);
                            corridor.setRotation(z - 1 == endZ ? RotationHelper.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : RotationHelper.getRotationFromFacing(Direction.NORTH));
                            corridor.openSide(Direction.SOUTH);
                            corridor.openSide(z - 1 == endZ ? Direction.WEST : Direction.NORTH);
                            this.segments[endX][z - 1] = corridor;
                        }
                    } else if (startZ < endZ) {
                        this.segments[endX][endZ].openSide(Direction.NORTH);
                        for (z = startZ; z < endZ - 1; ++z) {
                            if (this.segments[endX][z + 1] != null) {
                                this.segments[endX][z + 1].openSide(z + 1 == endZ ? Direction.EAST : Direction.SOUTH);
                                this.segments[endX][z + 1].openSide(Direction.NORTH);
                                this.rotatePiece(this.segments[endX][z + 1]);
                                continue;
                            }
                            corridor = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                            corridor.setPosition(endX, z + 1);
                            corridor.setRotation(z + 1 == endZ ? RotationHelper.getRotationFromCW90DoubleFacing(Direction.NORTH, Direction.WEST) : RotationHelper.getRotationFromFacing(Direction.SOUTH));
                            corridor.openSide(z + 1 == endZ ? Direction.WEST : Direction.SOUTH);
                            corridor.openSide(Direction.NORTH);
                            this.segments[endX][z + 1] = corridor;
                        }
                    } else {
                        this.segments[endX][endZ].openSide(Direction.WEST);
                    }
                    break block26;
                }
                if (startZ <= endZ) break block28;
                this.segments[startX][startZ].openSide(Direction.NORTH);
                this.segments[endX][endZ].openSide(Direction.SOUTH);
                for (int z = startZ; z > endZ + 1; --z) {
                    if (this.segments[endX][z - 1] != null) {
                        this.segments[endX][z - 1].openSide(Direction.NORTH);
                        this.segments[endX][z - 1].openSide(Direction.SOUTH);
                        this.rotatePiece(this.segments[endX][z - 1]);
                        continue;
                    }
                    DungeonPieces.Corridor corridor = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                    corridor.setPosition(endX, z - 1);
                    corridor.setRotation(RotationHelper.getRotationFromFacing(Direction.NORTH));
                    corridor.openSide(Direction.SOUTH);
                    corridor.openSide(Direction.NORTH);
                    this.segments[endX][z - 1] = corridor;
                }
                break block26;
            }
            if (startZ >= endZ) break block26;
            this.segments[startX][startZ].openSide(Direction.SOUTH);
            this.segments[endX][endZ].openSide(Direction.NORTH);
            for (int z = startZ; z < endZ - 1; ++z) {
                if (this.segments[endX][z + 1] != null) {
                    this.segments[endX][z + 1].openSide(Direction.SOUTH);
                    this.segments[endX][z + 1].openSide(Direction.NORTH);
                    this.rotatePiece(this.segments[endX][z + 1]);
                    continue;
                }
                this.segments[endX][endZ].openSide(Direction.NORTH);
                DungeonPieces.Corridor corridor = new DungeonPieces.Corridor(null, DungeonPieces.DEFAULT_NBT);
                corridor.setPosition(endX, z + 1);
                corridor.setRotation(RotationHelper.getRotationFromFacing(Direction.SOUTH));
                corridor.openSide(Direction.SOUTH);
                corridor.openSide(Direction.NORTH);
                this.segments[endX][z + 1] = corridor;
            }
        }
    }

    public void createLootRoom() {
        if (this.end == null) {
            DungeonCrawl.LOGGER.warn("Failed to find a final room position for the last layer of a dungeon. Layer map start pos: ({}|{})", (Object)this.start.x, (Object)this.start.z);
            this.extraRooms = Dungeon.SIZE;
            return;
        }
        DungeonPieces.Part part1 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
        DungeonPieces.Part part2 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
        DungeonPieces.Part part3 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
        DungeonPieces.Part part4 = new DungeonPieces.Part(null, DungeonPieces.DEFAULT_NBT);
        part1.treasureType = 7;
        part2.treasureType = 7;
        part3.treasureType = 7;
        part4.treasureType = 7;
        part1.field_186169_c = Rotation.NONE;
        part2.field_186169_c = Rotation.NONE;
        part3.field_186169_c = Rotation.NONE;
        part4.field_186169_c = Rotation.NONE;
        part4.walls = true;
        part3.walls = true;
        part2.walls = true;
        part1.walls = true;
        part1.set(28, 0, 0, 0, 8, 16, 8);
        part2.set(28, 8, 0, 0, 8, 16, 8);
        part3.set(28, 8, 0, 8, 8, 16, 8);
        part4.set(28, 0, 0, 8, 8, 16, 8);
        part1.setPosition(this.end.x, this.end.z);
        part2.setPosition(this.end.x + 1, this.end.z);
        part3.setPosition(this.end.x + 1, this.end.z + 1);
        part4.setPosition(this.end.x, this.end.z + 1);
        part1.sides[0] = false;
        part1.sides[1] = true;
        part1.sides[2] = true;
        part1.sides[3] = false;
        part2.sides[0] = false;
        part2.sides[1] = false;
        part2.sides[2] = true;
        part2.sides[3] = true;
        part3.sides[0] = true;
        part3.sides[1] = false;
        part3.sides[2] = false;
        part3.sides[3] = true;
        part4.sides[0] = true;
        part4.sides[1] = true;
        part4.sides[2] = false;
        part4.sides[3] = false;
        this.segments[this.end.x][this.end.z] = part1;
        this.segments[this.end.x + 1][this.end.z] = part2;
        this.segments[this.end.x + 1][this.end.z + 1] = part3;
        this.segments[this.end.x][this.end.z + 1] = part4;
        this.map.markPositionAsOccupied(this.end);
        this.map.markPositionAsOccupied(new Position2D(this.end.x + 1, this.end.z));
        this.map.markPositionAsOccupied(new Position2D(this.end.x + 1, this.end.z + 1));
        this.map.markPositionAsOccupied(new Position2D(this.end.x, this.end.z + 1));
    }

    public Position2D findLargeRoomPosWithMaxDistance(DungeonBuilder builder, Position2D pos, int layer) {
        int x = pos.x;
        int z = pos.z;
        int xHalf = this.width / 2 - 1;
        int zHalf = this.length / 2 - 1;
        if (x > xHalf) {
            if (z > zHalf) {
                return this.findLargeRoomPosAtArea(builder, new Position2D(0, 0), layer);
            }
            return this.findLargeRoomPosAtArea(builder, new Position2D(0, this.length - 1), layer);
        }
        if (z > zHalf) {
            return this.findLargeRoomPosAtArea(builder, new Position2D(this.width - 1, 0), layer);
        }
        return this.findLargeRoomPosAtArea(builder, new Position2D(this.width - 1, this.length - 1), layer);
    }

    public Position2D forceLargeRoomPosWithMaxDistance(Position2D pos) {
        int x = pos.x;
        int z = pos.z;
        int xHalf = this.width / 2 - 1;
        int zHalf = this.length / 2 - 1;
        if (x > xHalf) {
            if (z > zHalf) {
                return this.getLargeRoomPos(new Position2D(0, 0));
            }
            return this.getLargeRoomPos(new Position2D(0, this.length - 1));
        }
        if (z > zHalf) {
            return this.getLargeRoomPos(new Position2D(this.width - 1, 0));
        }
        return this.getLargeRoomPos(new Position2D(this.width - 1, this.length - 1));
    }

    public Position2D findLargeRoomPosAtArea(DungeonBuilder builder, Position2D pos, int layer) {
        for (int i = 0; i < 16; ++i) {
            int z;
            int x;
            for (x = -i; x < i; ++x) {
                if (!Position2D.isValid(pos.x + x, pos.z + i, this.width, this.length) || !DungeonFeatures.canPlacePieceWithHeight(builder, layer, pos.x + x, pos.z + i, 2, 2, 1, false)) continue;
                return new Position2D(pos.x + x, pos.z + i);
            }
            for (z = -i; z < i; ++z) {
                if (!Position2D.isValid(pos.x + i, pos.z + z, this.width, this.length) || !DungeonFeatures.canPlacePieceWithHeight(builder, layer, pos.x + i, pos.z + z, 2, 2, 1, false)) continue;
                return new Position2D(pos.x + i, pos.z + z);
            }
            for (x = -i; x < i; ++x) {
                if (!Position2D.isValid(pos.x + x, pos.z - i, this.width, this.length) || !DungeonFeatures.canPlacePieceWithHeight(builder, layer, pos.x + x, pos.z - i, 2, 2, 1, false)) continue;
                return new Position2D(pos.x + x, pos.z - i);
            }
            for (z = -i; z < i; ++z) {
                if (!Position2D.isValid(pos.x - i, pos.z + z, this.width, this.length) || !DungeonFeatures.canPlacePieceWithHeight(builder, layer, pos.x - i, pos.z + z, 2, 2, 1, false)) continue;
                return new Position2D(pos.x - i, pos.z + z);
            }
        }
        return null;
    }

    public Tuple<Position2D, Rotation> findStarterRoomData(Position2D start) {
        for (int x = start.x - 2; x < start.x + 2; ++x) {
            for (int z = start.z - 2; z < start.z + 2; ++z) {
                Tuple<Position2D, Rotation> data;
                if (!Position2D.isValid(x, z, this.width, this.length) || this.segments[x][z] == null || this.segments[x][z].getType() != 0 || this.segments[x][z].connectedSides >= 4 || (data = this.findSideRoomData(new Position2D(x, z))) == null) continue;
                return data;
            }
        }
        return null;
    }

    public Tuple<Position2D, Rotation> findSideRoomData(Position2D base) {
        Position2D north = base.shift(Direction.NORTH, 1);
        Position2D east = base.shift(Direction.EAST, 1);
        Position2D south = base.shift(Direction.SOUTH, 1);
        Position2D west = base.shift(Direction.WEST, 1);
        if (north.isValid(this.width, this.length) && this.segments[north.x][north.z] == null) {
            return new Tuple((Object)north, (Object)Rotation.COUNTERCLOCKWISE_90);
        }
        if (east.isValid(this.width, this.length) && this.segments[east.x][east.z] == null) {
            return new Tuple((Object)east, (Object)Rotation.NONE);
        }
        if (south.isValid(this.width, this.length) && this.segments[south.x][south.z] == null) {
            return new Tuple((Object)south, (Object)Rotation.CLOCKWISE_90);
        }
        if (west.isValid(this.width, this.length) && this.segments[west.x][west.z] == null) {
            return new Tuple((Object)west, (Object)Rotation.CLOCKWISE_180);
        }
        return null;
    }

    public void rotatePiece(DungeonPieces.DungeonPiece piece) {
        if (piece.getType() == 12) {
            return;
        }
        switch (piece.connectedSides) {
            case 1: {
                piece.setRotation(RotationHelper.getRotationFromFacing(DungeonPieces.DungeonPiece.getOneWayDirection(piece)));
                return;
            }
            case 2: {
                if (piece.sides[0] && piece.sides[2]) {
                    piece.setRotation(RotationHelper.getRotationFromFacing(Direction.NORTH));
                    break;
                }
                if (piece.sides[1] && piece.sides[3]) {
                    piece.setRotation(RotationHelper.getRotationFromFacing(Direction.EAST));
                    break;
                }
                piece.setRotation(RotationHelper.getRotationFromCW90DoubleFacing(DungeonPieces.DungeonPiece.getOpenSide(piece, 0), DungeonPieces.DungeonPiece.getOpenSide(piece, 1)));
                break;
            }
            case 3: {
                piece.setRotation(RotationHelper.getRotationFromTripleFacing(DungeonPieces.DungeonPiece.getOpenSide(piece, 0), DungeonPieces.DungeonPiece.getOpenSide(piece, 1), DungeonPieces.DungeonPiece.getOpenSide(piece, 2)));
            }
        }
    }

    public void processAddition(Position2D[] additions, Position2D start, Position2D end, Position2D one, Random rand) {
        this.buildConnection(rand.nextBoolean() ? start : end, one);
        this.buildConnection(one, additions[rand.nextInt(additions.length)]);
    }

    public boolean canPutDoubleRoom(Position2D pos, Direction direction) {
        if (!pos.isValid(this.width, this.length) || this.segments[pos.x][pos.z] != null && this.map.isPositionFree(pos.x, pos.z)) {
            return false;
        }
        switch (direction) {
            case NORTH: {
                return pos.z > 0 && this.segments[pos.x][pos.z - 1] == null && this.map.isPositionFree(pos.x, pos.z - 1);
            }
            case EAST: {
                return pos.x < this.width - 1 && this.segments[pos.x + 1][pos.z] == null && this.map.isPositionFree(pos.x + 1, pos.z);
            }
            case SOUTH: {
                return pos.z < this.length - 1 && this.segments[pos.x][pos.z + 1] == null && this.map.isPositionFree(pos.x, pos.z + 1);
            }
            case WEST: {
                return pos.x > 0 && this.segments[pos.x - 1][pos.z] == null && this.map.isPositionFree(pos.x - 1, pos.z);
            }
        }
        return false;
    }

    public Position2D getLargeRoomPos(Position2D pos) {
        int a = Dungeon.SIZE - 1;
        int x = pos.x;
        int z = pos.z;
        if (x < a && z < a && this.get(x + 1, z) == null && this.get(x + 1, z + 1) == null && this.get(x, z + 1) == null) {
            return pos;
        }
        if (x < a && z > 0 && this.get(x + 1, z) == null && this.get(x + 1, z - 1) == null && this.get(x, z - 1) == null) {
            return new Position2D(x, z - 1);
        }
        if (x > 0 && z < a && this.get(x - 1, z) == null && this.get(x - 1, z + 1) == null && this.get(x, z + 1) == null) {
            return new Position2D(x - 1, z);
        }
        if (x > 0 && z > 0 && this.get(x - 1, z) == null && this.get(x - 1, z - 1) == null && this.get(x, z - 1) == null) {
            return new Position2D(x - 1, z - 1);
        }
        return null;
    }

    public static Position2D getLargeRoomPos(DungeonLayer layer, Position2D pos) {
        int a = Dungeon.SIZE - 1;
        int x = pos.x;
        int z = pos.z;
        if (x < a && z < a && layer.get(x + 1, z) == null && layer.get(x + 1, z + 1) == null && layer.get(x, z + 1) == null) {
            return pos;
        }
        if (x < a && z > 0 && layer.get(x + 1, z) == null && layer.get(x + 1, z - 1) == null && layer.get(x, z - 1) == null) {
            return new Position2D(x, z - 1);
        }
        if (x > 0 && z < a && layer.get(x - 1, z) == null && layer.get(x - 1, z + 1) == null && layer.get(x, z + 1) == null) {
            return new Position2D(x - 1, z);
        }
        if (x > 0 && z > 0 && layer.get(x - 1, z) == null && layer.get(x - 1, z - 1) == null && layer.get(x, z - 1) == null) {
            return new Position2D(x - 1, z - 1);
        }
        return null;
    }

    public void testBuildToWorld(World world, BlockPos start) {
        int posX = start.func_177958_n();
        int posY = start.func_177956_o();
        int posZ = start.func_177952_p();
        for (int x = 0; x < this.width; ++x) {
            for (int z = 0; z < this.length; ++z) {
                world.func_175656_a(new BlockPos(posX + x, posY, posZ + z), this.segments[x][z] == null ? Blocks.field_150350_a.func_176223_P() : (this.segments[x][z] instanceof DungeonPieces.StairsBot ? Blocks.field_196569_aY.func_176223_P() : (this.segments[x][z] instanceof DungeonPieces.StairsTop ? Blocks.field_196570_aZ.func_176223_P() : (this.segments[x][z] instanceof DungeonPieces.Room ? Blocks.field_196567_aW.func_176223_P() : Blocks.field_196556_aL.func_176223_P()))));
            }
        }
    }

    public boolean isInitialized() {
        return this.segments != null;
    }

    public DungeonPieces.DungeonPiece get(int x, int z) {
        return this.segments[x][z];
    }
}

