/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.vectorart;

import com.mojang.blaze3d.matrix.MatrixStack;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpBox;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpLine;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpText;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOpType;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;

public abstract class GfxOp {
    public abstract void render(MatrixStack var1, IRenderTypeBuffer var2);

    public abstract GfxOpType getType();

    public static GfxOp readFromNBT(CompoundNBT tag) {
        GfxOpType type = GfxOpType.values()[tag.func_74771_c("type")];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromNBTInternal(tag);
        return op;
    }

    public CompoundNBT writeToNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74774_a("type", (byte)this.getType().ordinal());
        this.writeToNBTInternal(tag);
        return tag;
    }

    protected abstract void readFromNBTInternal(CompoundNBT var1);

    protected abstract void writeToNBTInternal(CompoundNBT var1);

    public static GfxOp readFromBuf(PacketBuffer buf) {
        GfxOpType type = GfxOpType.values()[buf.readByte()];
        GfxOp op = GfxOp.createGfxOp(type);
        op.readFromBufInternal(buf);
        return op;
    }

    private static GfxOp createGfxOp(GfxOpType type) {
        GfxOp op = null;
        switch (type) {
            case OP_BOX: {
                op = new GfxOpBox();
                break;
            }
            case OP_LINE: {
                op = new GfxOpLine();
                break;
            }
            case OP_TEXT: {
                op = new GfxOpText();
            }
        }
        return op;
    }

    public void writeToBuf(PacketBuffer buf) {
        buf.writeByte(this.getType().ordinal());
        this.writeToBufInternal(buf);
    }

    protected abstract void readFromBufInternal(PacketBuffer var1);

    protected abstract void writeToBufInternal(PacketBuffer var1);
}

