/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature;

import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.HugeTreeFeatureConfig;

public abstract class HugeTreesFeature<T extends BaseTreeFeatureConfig>
extends AbstractTreeFeature<T> {
    public HugeTreesFeature(Function<Dynamic<?>, ? extends T> function) {
        super(function);
    }

    protected int func_227256_a_(Random random, HugeTreeFeatureConfig hugeTreeFeatureConfig) {
        int n = random.nextInt(3) + hugeTreeFeatureConfig.field_227371_p_;
        if (hugeTreeFeatureConfig.field_227275_a_ > 1) {
            n += random.nextInt(hugeTreeFeatureConfig.field_227275_a_);
        }
        return n;
    }

    private boolean func_175926_c(IWorldGenerationBaseReader iWorldGenerationBaseReader, BlockPos blockPos, int n) {
        boolean bl = true;
        if (blockPos.func_177956_o() < 1 || blockPos.func_177956_o() + n + 1 > 256) {
            return false;
        }
        for (int i = 0; i <= 1 + n; ++i) {
            \u2603 = 2;
            if (i == 0) {
                \u2603 = 1;
            } else if (i >= 1 + n - 2) {
                \u2603 = 2;
            }
            for (\u2603 = -\u2603; \u2603 <= \u2603 && bl; ++\u2603) {
                for (\u2603 = -\u2603; \u2603 <= \u2603 && bl; ++\u2603) {
                    if (blockPos.func_177956_o() + i >= 0 && blockPos.func_177956_o() + i < 256 && HugeTreesFeature.func_214587_a(iWorldGenerationBaseReader, blockPos.func_177982_a(\u2603, i, \u2603))) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean func_202405_b(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos) {
        \u2603 = blockPos.func_177977_b();
        if (!HugeTreesFeature.func_214589_h(iWorldGenerationReader, \u2603) || blockPos.func_177956_o() < 2) {
            return false;
        }
        this.func_214584_a(iWorldGenerationReader, \u2603);
        this.func_214584_a(iWorldGenerationReader, \u2603.func_177974_f());
        this.func_214584_a(iWorldGenerationReader, \u2603.func_177968_d());
        this.func_214584_a(iWorldGenerationReader, \u2603.func_177968_d().func_177974_f());
        return true;
    }

    protected boolean func_203427_a(IWorldGenerationReader iWorldGenerationReader, BlockPos blockPos, int n) {
        return this.func_175926_c(iWorldGenerationReader, blockPos, n) && this.func_202405_b(iWorldGenerationReader, blockPos);
    }

    protected void func_227255_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, int n, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        int n2 = n * n;
        for (\u2603 = -n; \u2603 <= n + 1; ++\u2603) {
            for (\u2603 = -n; \u2603 <= n + 1; ++\u2603) {
                \u2603 = Math.min(Math.abs(\u2603), Math.abs(\u2603 - 1));
                if (\u2603 + (\u2603 = Math.min(Math.abs(\u2603), Math.abs(\u2603 - 1))) >= 7 || \u2603 * \u2603 + \u2603 * \u2603 > n2) continue;
                this.func_227219_b_(iWorldGenerationReader, random, blockPos.func_177982_a(\u2603, 0, \u2603), set, mutableBoundingBox, baseTreeFeatureConfig);
            }
        }
    }

    protected void func_227257_b_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, int n, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, BaseTreeFeatureConfig baseTreeFeatureConfig) {
        int n2 = n * n;
        for (\u2603 = -n; \u2603 <= n; ++\u2603) {
            for (\u2603 = -n; \u2603 <= n; ++\u2603) {
                if (\u2603 * \u2603 + \u2603 * \u2603 > n2) continue;
                this.func_227219_b_(iWorldGenerationReader, random, blockPos.func_177982_a(\u2603, 0, \u2603), set, mutableBoundingBox, baseTreeFeatureConfig);
            }
        }
    }

    protected void func_227254_a_(IWorldGenerationReader iWorldGenerationReader, Random random, BlockPos blockPos, int n, Set<BlockPos> set, MutableBoundingBox mutableBoundingBox, HugeTreeFeatureConfig hugeTreeFeatureConfig) {
        BlockPos.Mutable mutable = new BlockPos.Mutable();
        for (int i = 0; i < n; ++i) {
            mutable.func_189533_g(blockPos).func_196234_d(0, i, 0);
            if (HugeTreesFeature.func_214587_a(iWorldGenerationReader, mutable)) {
                this.func_227216_a_(iWorldGenerationReader, random, mutable, set, mutableBoundingBox, hugeTreeFeatureConfig);
            }
            if (i >= n - 1) continue;
            mutable.func_189533_g(blockPos).func_196234_d(1, i, 0);
            if (HugeTreesFeature.func_214587_a(iWorldGenerationReader, mutable)) {
                this.func_227216_a_(iWorldGenerationReader, random, mutable, set, mutableBoundingBox, hugeTreeFeatureConfig);
            }
            mutable.func_189533_g(blockPos).func_196234_d(1, i, 1);
            if (HugeTreesFeature.func_214587_a(iWorldGenerationReader, mutable)) {
                this.func_227216_a_(iWorldGenerationReader, random, mutable, set, mutableBoundingBox, hugeTreeFeatureConfig);
            }
            mutable.func_189533_g(blockPos).func_196234_d(0, i, 1);
            if (!HugeTreesFeature.func_214587_a(iWorldGenerationReader, mutable)) continue;
            this.func_227216_a_(iWorldGenerationReader, random, mutable, set, mutableBoundingBox, hugeTreeFeatureConfig);
        }
    }
}

