/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypoint;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.command.CmdTeleportWaypoint;
import journeymap.client.log.JMLogger;
import journeymap.client.model.Waypoint;
import journeymap.client.properties.ClientCategory;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.Button;
import journeymap.client.ui.component.ButtonList;
import journeymap.client.ui.component.JmUI;
import journeymap.client.ui.component.OnOffButton;
import journeymap.client.ui.component.ScrollListPane;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.CategorySlot;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.client.ui.waypoint.DimensionsButton;
import journeymap.client.ui.waypoint.SortButton;
import journeymap.client.ui.waypoint.WaypointManagerItem;
import journeymap.client.waypoint.WaypointStore;
import journeymap.common.Journeymap;
import journeymap.common.properties.Category;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;

public class WaypointManager
extends JmUI {
    static final String ASCEND = "\u25b2";
    static final String DESCEND = "\u25bc";
    static final int COLWAYPOINT = 0;
    static final int COLLOCATION = 20;
    static final int COLNAME = 60;
    static final int DEFAULT_ITEMWIDTH = 460;
    private static WaypointManagerItem.Sort currentSort;
    private final String on = Constants.getString("jm.common.on");
    private final String off = Constants.getString("jm.common.off");
    protected int colWaypoint = 0;
    protected int colLocation = 20;
    protected int colName = 60;
    protected int itemWidth = 460;
    protected ScrollListPane itemScrollPane;
    protected int rowHeight = 16;
    Boolean canUserTeleport;
    private SortButton buttonSortName;
    private SortButton buttonSortDistance;
    private DimensionsButton buttonDimensions;
    private Button buttonClose;
    private Button buttonAdd;
    private Button buttonOptions;
    private OnOffButton buttonToggleAll;
    private ButtonList bottomButtons;
    private Waypoint focusWaypoint;
    private ArrayList<WaypointManagerItem> items = new ArrayList();
    private static boolean toggled;

    public WaypointManager() {
        this((Waypoint)null, (JmUI)null);
    }

    public WaypointManager(JmUI returnDisplay) {
        this((Waypoint)null, returnDisplay);
    }

    public WaypointManager(Waypoint focusWaypoint, JmUI returnDisplay) {
        super(Constants.getString("jm.waypoint.manage_title"), returnDisplay);
        this.focusWaypoint = focusWaypoint;
    }

    @Override
    public void init() {
        try {
            this.buttons.clear();
            Journeymap.getLogger().debug("Checking if tp is permitted");
            this.canUserTeleport = CmdTeleportWaypoint.isPermitted(Minecraft.func_71410_x());
            Journeymap.getLogger().debug("Checked if tp button should be displayed:" + this.canUserTeleport);
            FontRenderer fr = this.getFontRenderer();
            WaypointManagerItem.DistanceComparator distanceSort = new WaypointManagerItem.DistanceComparator((PlayerEntity)Minecraft.func_71410_x().field_71439_g, true);
            String distanceLabel = Constants.getString("jm.waypoint.distance");
            this.buttonSortDistance = new SortButton(distanceLabel, distanceSort, b -> {
                this.buttonSortDistance.toggle();
                this.updateSort(this.buttonSortDistance);
            });
            this.buttonSortDistance.setTextOnly(fr);
            this.buttons.add(this.buttonSortDistance);
            this.addButton((Widget)this.buttonSortDistance);
            WaypointManagerItem.NameComparator nameSort = new WaypointManagerItem.NameComparator(true);
            this.buttonSortName = new SortButton(Constants.getString("jm.waypoint.name"), nameSort, b -> {
                this.buttonSortName.toggle();
                this.updateSort(this.buttonSortName);
            });
            this.buttonSortName.setTextOnly(fr);
            this.addButton((Widget)this.buttonSortName);
            this.buttons.add(this.buttonSortName);
            String enableOn = Constants.getString("jm.waypoint.enable_all", "", this.on);
            String enableOff = Constants.getString("jm.waypoint.enable_all", "", this.off);
            this.buttonToggleAll = new OnOffButton(enableOff, enableOn, true, b -> {
                boolean state = this.buttonToggleAll.getToggled();
                state = this.toggleItems(state);
                this.buttonToggleAll.setToggled(state);
            });
            this.buttonToggleAll.setTextOnly(this.getFontRenderer());
            this.addButton((Widget)this.buttonToggleAll);
            this.buttons.add(this.buttonToggleAll);
            this.buttonDimensions = new DimensionsButton(b -> {
                this.buttonDimensions.nextValue();
                this.updateItems();
            });
            this.addButton((Widget)this.buttonDimensions);
            this.buttonAdd = (Button)this.addButton((Widget)new Button(Constants.getString("jm.waypoint.new"), button -> {
                Waypoint waypoint = Waypoint.of((PlayerEntity)this.minecraft.field_71439_g);
                UIManager.INSTANCE.openWaypointEditor(waypoint, true, this);
            }));
            this.buttonAdd.fitWidth(this.getFontRenderer());
            this.buttonAdd.setWidth(this.buttonAdd.getWidth() * 2);
            this.buttonOptions = (Button)this.addButton((Widget)new Button(Constants.getString("jm.common.options_button"), button -> UIManager.INSTANCE.openOptionsManager(this, ClientCategory.Waypoint, ClientCategory.WaypointBeacon)));
            this.buttonOptions.fitWidth(this.getFontRenderer());
            this.buttonClose = (Button)this.addButton((Widget)new Button(Constants.getString("jm.common.close"), button -> this.refreshAndClose()));
            this.bottomButtons = new ButtonList(this.buttonOptions, this.buttonAdd, this.buttonDimensions, this.buttonClose);
            this.buttons.addAll(this.bottomButtons);
            if (this.items.isEmpty()) {
                this.updateItems();
                if (currentSort == null) {
                    this.updateSort(this.buttonSortDistance);
                } else {
                    if (this.buttonSortDistance.sort.equals(currentSort)) {
                        this.buttonSortDistance.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortDistance.setActive(true);
                        this.buttonSortName.setActive(false);
                    }
                    if (this.buttonSortName.sort.equals(currentSort)) {
                        this.buttonSortName.sort.ascending = WaypointManager.currentSort.ascending;
                        this.buttonSortName.setActive(true);
                        this.buttonSortDistance.setActive(false);
                    }
                }
            }
            if (this.itemScrollPane == null) {
                this.itemScrollPane = new ScrollListPane(this, this.minecraft, this.width, this.height, 35, this.height - 30, 20);
            } else {
                this.itemScrollPane.updateSize(this.width, this.height, 35, this.height - 30);
                this.itemScrollPane.updateSlots();
            }
            this.itemScrollPane.setSlots(this.items);
            if (!this.items.isEmpty()) {
                this.itemScrollPane.scrollTo(this.items.get(0));
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.init(): " + t, t);
        }
    }

    @Override
    protected void layoutButtons() {
        if (this.buttons.isEmpty() || this.itemScrollPane == null) {
            this.init();
        }
        this.buttonToggleAll.setDrawButton(!this.items.isEmpty());
        this.buttonSortDistance.setDrawButton(!this.items.isEmpty());
        this.buttonSortName.setDrawButton(!this.items.isEmpty());
        this.bottomButtons.equalizeWidths(this.getFontRenderer());
        int bottomButtonWidth = Math.min(this.bottomButtons.getWidth(4) + 25, this.itemScrollPane.getRowWidth());
        this.bottomButtons.equalizeWidths(this.getFontRenderer(), 4, bottomButtonWidth);
        this.bottomButtons.layoutCenteredHorizontal(this.width / 2, this.height - 25, true, 4);
    }

    @Override
    public void render(int x, int y, float par3) {
        if (this.minecraft == null) {
            return;
        }
        if (this.buttons.isEmpty() || this.itemScrollPane == null) {
            this.init();
        }
        if (currentSort != null) {
            Collections.sort(this.items, currentSort);
        }
        if (this.itemScrollPane != null) {
            this.itemScrollPane.setSlots(this.items);
        }
        try {
            this.itemScrollPane.updateSize(this.width, this.height, 35, this.height - 30);
            Object[] lastTooltip = this.itemScrollPane.lastTooltip;
            long lastTooltipTime = this.itemScrollPane.lastTooltipTime;
            this.itemScrollPane.lastTooltip = null;
            this.itemScrollPane.render(x, y, par3);
            super.render(x, y, par3);
            if (!this.items.isEmpty()) {
                this.getFontRenderer().getClass();
                int headerY = 35 - 9;
                WaypointManagerItem firstRow = this.items.get(0);
                if (firstRow.y > headerY + 16) {
                    headerY = firstRow.y - 16;
                }
                this.buttonToggleAll.centerHorizontalOn(firstRow.getButtonEnableCenterX()).setY(headerY);
                this.buttonSortDistance.centerHorizontalOn(firstRow.getLocationLeftX()).setY(headerY);
                this.colName = this.buttonSortDistance.getRightX() + 10;
                this.buttonSortName.setPosition(this.colName - 5, headerY);
            }
            this.buttonToggleAll.drawUnderline();
            for (List<SlotMetadata> toolbar : this.getToolbars().values()) {
                for (SlotMetadata slotMetadata : toolbar) {
                    slotMetadata.getButton().secondaryDrawButton();
                }
            }
            if (this.itemScrollPane.lastTooltip != null && Arrays.equals(this.itemScrollPane.lastTooltip, lastTooltip)) {
                this.itemScrollPane.lastTooltipTime = lastTooltipTime;
                if (System.currentTimeMillis() - this.itemScrollPane.lastTooltipTime > this.itemScrollPane.hoverDelay) {
                    Button button = this.itemScrollPane.lastTooltipMetadata.getButton();
                    this.renderTooltip(this.itemScrollPane.lastTooltip, x, button.getBottomY() + 15);
                }
            }
        }
        catch (Throwable t) {
            JMLogger.logOnce("Error in OptionsManager.render(): " + t, t);
        }
    }

    @Override
    public void renderBackground() {
    }

    public void renderBackground(int tint) {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean pressed;
        if (mouseButton == 0 && (pressed = this.itemScrollPane.mouseClicked(mouseX, mouseY, mouseButton))) {
            this.checkPressedButton();
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        this.itemScrollPane.mouseReleased(mouseX, mouseY, mouseButton);
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double mouseDX, double mouseDY) {
        this.checkPressedButton();
        this.itemScrollPane.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
        return super.mouseDragged(mouseX, mouseY, button, mouseDX, mouseDY);
    }

    public boolean mouseScrolled(double x, double y, double scroll) {
        this.itemScrollPane.mouseScrolled(x, y, scroll);
        return super.mouseScrolled(x, y, scroll);
    }

    protected void checkPressedButton() {
        CategorySlot parentSlot;
        SlotMetadata slotMetadata = this.itemScrollPane.getLastPressed();
        if (slotMetadata != null) {
            // empty if block
        }
        if ((parentSlot = (CategorySlot)this.itemScrollPane.getLastPressedParentSlot()) != null) {
            // empty if block
        }
    }

    @Override
    public boolean charTyped(char typedChar, int keyCode) {
        switch (keyCode) {
            case 256: {
                this.closeAndReturn();
            }
        }
        boolean keyUsed = this.itemScrollPane.charTyped(typedChar, keyCode);
        if (keyUsed) {
            return true;
        }
        if (keyCode == 265) {
            this.itemScrollPane.scroll(-this.rowHeight);
            return true;
        }
        if (keyCode == 264) {
            this.itemScrollPane.scroll(this.rowHeight);
            return true;
        }
        if (keyCode == 266) {
            this.itemScrollPane.scroll(-this.itemScrollPane.getHeight());
            return true;
        }
        if (keyCode == 267) {
            this.itemScrollPane.scroll(this.itemScrollPane.getHeight());
            return true;
        }
        if (keyCode == 268) {
            this.itemScrollPane.scroll(-this.itemScrollPane.getScroll());
            return true;
        }
        if (keyCode == 269) {
            this.itemScrollPane.scroll(this.itemScrollPane.getScroll());
            return true;
        }
        return true;
    }

    protected boolean toggleItems(boolean enable) {
        for (WaypointManagerItem item : this.items) {
            if (enable != item.waypoint.isEnable()) continue;
            enable = !enable;
            break;
        }
        for (WaypointManagerItem item : this.items) {
            if (item.waypoint.isEnable() == enable) continue;
            item.enableWaypoint(enable);
        }
        return !enable;
    }

    public static void toggleAllWaypoints() {
        toggled = !toggled;
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        for (Waypoint waypoint : waypoints) {
            waypoint.setEnable(toggled);
            waypoint.setDirty();
        }
    }

    protected void updateItems() {
        this.items.clear();
        Integer currentDim = DimensionsButton.currentWorldProvider == null ? null : Integer.valueOf(DimensionsButton.currentWorldProvider.getDimensionId());
        FontRenderer fr = this.getFontRenderer();
        this.itemWidth = 0;
        Collection<Waypoint> waypoints = WaypointStore.INSTANCE.getAll();
        boolean allOn = true;
        for (Waypoint waypoint : waypoints) {
            WaypointManagerItem item = new WaypointManagerItem(waypoint, fr, this);
            item.getDistanceTo((PlayerEntity)this.minecraft.field_71439_g);
            if (currentDim != null && !item.waypoint.getDimensions().contains(currentDim)) continue;
            this.items.add(item);
            if (!allOn) continue;
            allOn = waypoint.isEnable();
        }
        this.itemWidth = this.items.isEmpty() ? 460 : this.items.get((int)0).internalWidth;
        this.buttonToggleAll.setToggled(!allOn);
        this.updateCount();
    }

    protected void updateSort(SortButton sortButton) {
        for (Widget button : this.buttons) {
            if (!(button instanceof SortButton)) continue;
            if (button == sortButton) {
                if (!sortButton.sort.equals(currentSort)) {
                    sortButton.setActive(true);
                }
                currentSort = sortButton.sort;
                continue;
            }
            ((SortButton)button).setActive(false);
        }
    }

    protected void updateCount() {
        String itemCount = this.items.isEmpty() ? "" : Integer.toString(this.items.size());
        String enableOn = Constants.getString("jm.waypoint.enable_all", itemCount, this.on);
        String enableOff = Constants.getString("jm.waypoint.enable_all", itemCount, this.off);
        this.buttonToggleAll.setLabels(enableOff, enableOn);
    }

    protected boolean isSelected(WaypointManagerItem item) {
        return this.itemScrollPane.isSelectedItem(item.getSlotIndex());
    }

    protected int getMargin() {
        return this.width > this.itemWidth + 2 ? (this.width - this.itemWidth) / 2 : 0;
    }

    public void removeWaypoint(WaypointManagerItem item) {
        WaypointStore.INSTANCE.remove(item.waypoint);
        this.items.remove((Object)item);
    }

    protected void refreshAndClose() {
        this.closeAndReturn();
    }

    @Override
    protected void closeAndReturn() {
        this.bottomButtons.setEnabled(false);
        WaypointStore.INSTANCE.bulkSave();
        Fullscreen.state().requireRefresh();
        this.bottomButtons.setEnabled(true);
        if (this.returnDisplay == null) {
            UIManager.INSTANCE.closeAll();
        } else {
            UIManager.INSTANCE.open(this.returnDisplay);
        }
    }

    Map<Category, List<SlotMetadata>> getToolbars() {
        return Collections.EMPTY_MAP;
    }

    static {
        toggled = true;
    }
}

