/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity.familiar;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.util.math.MathHelper;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.render.entity.familiar.FamiliarModelRenderer;

public class ModelFamiliar
extends SegmentedModel<FamiliarEntity> {
    FamiliarModelRenderer body;
    FamiliarModelRenderer tail;
    FamiliarModelRenderer wingLeft;
    FamiliarModelRenderer wingRight;
    FamiliarModelRenderer head;
    FamiliarModelRenderer beak1;
    FamiliarModelRenderer legLeft;
    FamiliarModelRenderer legRight;
    List<FamiliarModelRenderer> parts = new ArrayList<FamiliarModelRenderer>();
    List<FamiliarModelRenderer> renderparts = new ArrayList<FamiliarModelRenderer>();
    private State state = State.STANDING;

    public ModelFamiliar() {
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.body = new FamiliarModelRenderer((Model)this, 0, 0);
        this.body.addBox(-1.5f, 2.0f, -1.5f, 3.0f, 4.0f, 3.0f);
        this.body.func_78793_a(0.0f, 16.5f, -3.0f);
        this.tail = new FamiliarModelRenderer((Model)this, 0, 0);
        this.tail.addBox(-1.5f, -1.0f, -1.0f, 3.0f, 4.0f, 1.0f);
        this.tail.func_78793_a(0.0f, 21.07f, 1.16f);
        this.wingLeft = new FamiliarModelRenderer((Model)this, 0, 0);
        this.wingLeft.addBox(-1.0f, 1.8f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.wingLeft.func_78793_a(1.5f, 16.94f, -3.26f);
        this.wingRight = new FamiliarModelRenderer((Model)this, 0, 0);
        this.wingRight.addBox(-0.0f, 1.8f, -1.5f, 1.0f, 5.0f, 3.0f);
        this.wingRight.func_78793_a(-1.5f, 16.94f, -3.26f);
        this.head = new FamiliarModelRenderer((Model)this, 0, 0);
        this.head.addBox(-1.0f, 0.5f, -1.0f, 2.0f, 3.0f, 2.0f);
        this.head.func_78793_a(0.0f, 15.69f, -2.76f);
        this.beak1 = new FamiliarModelRenderer((Model)this, 0, 0);
        this.beak1.addBox(-0.5f, 1.2f, -0.5f, 1.0f, 1.0f, 1.0f);
        this.beak1.func_78793_a(0.0f, -0.5f, -1.5f);
        this.head.addChild(this.beak1);
        this.legLeft = new FamiliarModelRenderer((Model)this, 0, 0);
        this.legLeft.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.legLeft.func_78793_a(1.0f, 22.0f, -1.05f);
        this.legRight = new FamiliarModelRenderer((Model)this, 0, 0);
        this.legRight.addBox(-0.5f, 0.0f, -0.5f, 1.0f, 2.0f, 1.0f);
        this.legRight.func_78793_a(-1.0f, 22.0f, -1.05f);
        this.parts.add(this.body);
        this.parts.add(this.tail);
        this.parts.add(this.wingLeft);
        this.parts.add(this.wingRight);
        this.parts.add(this.head);
        this.parts.add(this.beak1);
        this.parts.add(this.legLeft);
        this.parts.add(this.legRight);
        for (FamiliarModelRenderer b : this.parts) {
            this.addBoxesToEachFace(b);
        }
    }

    public void addBoxesToEachFace(FamiliarModelRenderer box) {
        float rs = -0.001f;
        int sz = box.field_78804_l.size();
        for (int j = 0; j < sz; ++j) {
            FamiliarModelRenderer.ModelBox b = (FamiliarModelRenderer.ModelBox)((Object)box.field_78804_l.get(j));
            FamiliarModelRenderer mr = new FamiliarModelRenderer((Model)this, 0, 0);
            mr.addBox(b.field_78252_a + rs, b.field_78250_b + rs, b.field_78251_c + rs, b.field_78248_d - b.field_78252_a - rs - rs, b.field_78249_e - b.field_78250_b - rs - rs, b.field_78246_f - b.field_78251_c - rs - rs);
            box.addChild(mr);
            mr.isRenderChild = true;
        }
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return ImmutableList.of((Object)((Object)this.body), (Object)((Object)this.wingLeft), (Object)((Object)this.wingRight), (Object)((Object)this.tail), (Object)((Object)this.head), (Object)((Object)this.legLeft), (Object)((Object)this.legRight));
    }

    public Iterable<FamiliarModelRenderer> getFParts() {
        return ImmutableList.of((Object)((Object)this.body), (Object)((Object)this.wingLeft), (Object)((Object)this.wingRight), (Object)((Object)this.tail), (Object)((Object)this.head), (Object)((Object)this.legLeft), (Object)((Object)this.legRight));
    }

    public void setRotationAngles(FamiliarEntity familiarEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float f = ageInTicks * 0.3f;
        this.head.field_78795_f = headPitch * ((float)Math.PI / 180);
        this.head.field_78796_g = netHeadYaw * ((float)Math.PI / 180);
        this.head.field_78808_h = 0.0f;
        this.head.field_78800_c = 0.0f;
        this.body.field_78800_c = 0.0f;
        this.tail.field_78800_c = 0.0f;
        this.wingRight.field_78800_c = -1.3f;
        this.wingLeft.field_78800_c = 1.3f;
        if (this.state != State.FLYING) {
            if (this.state == State.SITTING) {
                return;
            }
            this.legLeft.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.legRight.field_78795_f += MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        }
        this.head.field_78797_d = 15.69f + f;
        this.tail.field_78795_f = 1.015f + MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 0.3f * limbSwingAmount;
        this.tail.field_78797_d = 21.07f + f;
        this.body.field_78797_d = 16.5f + f;
        this.wingLeft.field_78808_h = -0.0873f - ageInTicks;
        this.wingLeft.field_78797_d = 17.94f + f;
        this.wingRight.field_78808_h = 0.0873f + ageInTicks;
        this.wingRight.field_78797_d = 17.94f + f;
        this.legLeft.field_78797_d = 22.0f + f;
        this.legRight.field_78797_d = 22.0f + f;
    }

    public void setLivingAnimations(FamiliarEntity entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTickTime) {
        this.body.field_78795_f = 0.4937f;
        this.wingLeft.field_78795_f = -0.69813174f;
        this.wingLeft.field_78796_g = (float)(-Math.PI);
        this.wingRight.field_78795_f = -0.69813174f;
        this.wingRight.field_78796_g = (float)(-Math.PI);
        this.legLeft.field_78795_f = -0.0299f;
        this.legRight.field_78795_f = -0.0299f;
        this.legLeft.field_78797_d = 22.0f;
        this.legRight.field_78797_d = 22.0f;
        if (entitylivingbaseIn instanceof FamiliarEntity) {
            FamiliarEntity familiar = entitylivingbaseIn;
            if (familiar.func_70906_o()) {
                float f = 1.9f;
                this.head.field_78797_d = 17.59f;
                this.tail.field_78795_f = 1.5388988f;
                this.tail.field_78797_d = 22.97f;
                this.body.field_78797_d = 18.4f;
                this.wingLeft.field_78808_h = -0.0873f;
                this.wingLeft.field_78797_d = 17.94f;
                this.wingRight.field_78808_h = 0.0873f;
                this.wingRight.field_78797_d = 17.94f;
                this.legLeft.field_78797_d += 1.0f;
                this.legRight.field_78797_d += 1.0f;
                this.legLeft.field_78795_f += 1.0f;
                this.legRight.field_78795_f += 1.0f;
                this.state = State.SITTING;
            } else if (familiar.isFlying()) {
                this.legLeft.field_78795_f += 0.69813174f;
                this.legRight.field_78795_f += 0.69813174f;
                this.state = State.FLYING;
            } else {
                this.state = State.STANDING;
            }
            this.legLeft.field_78808_h = 0.0f;
            this.legRight.field_78808_h = 0.0f;
        }
    }

    public void func_225598_a_(MatrixStack stack, IVertexBuilder builder, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
    }

    public void render(MatrixStack stack, IRenderTypeBuffer buffer, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
        this.getFParts().forEach(p_228272_8_ -> p_228272_8_.render(stack, buffer, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_));
    }

    static enum State {
        FLYING,
        STANDING,
        SITTING;

    }
}

