/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;
import stepsword.mahoutsukai.tile.MahoujinProjectorTileEntity;

public class MahoujinProjectorUpdatePacket {
    int r;
    int g;
    int b;
    int a;
    int image;
    int runes;
    float x;
    float y;
    float z;
    float size;
    float speed;
    float yaw;
    float pitch;
    float ring;
    float height;
    float yspeed;
    float pspeed;
    float roffset;
    boolean sc;
    boolean sr;
    BlockPos pos;

    public MahoujinProjectorUpdatePacket() {
    }

    public MahoujinProjectorUpdatePacket(int r, int g, int b, int a, float x, float y, float z, float size, float speed, float yaw, float pitch, float ring, boolean sc, boolean sr, BlockPos pos, int image, int runes, float height, float yspeed, float pspeed, float roffset) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
        this.x = x;
        this.y = y;
        this.z = z;
        this.size = size;
        this.speed = speed;
        this.yaw = yaw;
        this.pitch = pitch;
        this.ring = ring;
        this.pos = pos;
        this.sc = sc;
        this.sr = sr;
        this.image = image;
        this.runes = runes;
        this.height = height;
        this.yspeed = yspeed;
        this.pspeed = pspeed;
        this.roffset = roffset;
    }

    public void fromBytes(PacketBuffer buf) {
        this.r = buf.readInt();
        this.g = buf.readInt();
        this.b = buf.readInt();
        this.a = buf.readInt();
        this.x = buf.readFloat();
        this.y = buf.readFloat();
        this.z = buf.readFloat();
        this.size = buf.readFloat();
        this.speed = buf.readFloat();
        this.yaw = buf.readFloat();
        this.pitch = buf.readFloat();
        this.ring = buf.readFloat();
        this.sc = buf.readBoolean();
        this.sr = buf.readBoolean();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.image = buf.readInt();
        this.runes = buf.readInt();
        this.height = buf.readFloat();
        this.yspeed = buf.readFloat();
        this.pspeed = buf.readFloat();
        this.roffset = buf.readFloat();
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeInt(this.r);
        buf.writeInt(this.g);
        buf.writeInt(this.b);
        buf.writeInt(this.a);
        buf.writeFloat(this.x);
        buf.writeFloat(this.y);
        buf.writeFloat(this.z);
        buf.writeFloat(this.size);
        buf.writeFloat(this.speed);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.ring);
        buf.writeBoolean(this.sc);
        buf.writeBoolean(this.sr);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
        buf.writeInt(this.image);
        buf.writeInt(this.runes);
        buf.writeFloat(this.height);
        buf.writeFloat(this.yspeed);
        buf.writeFloat(this.pspeed);
        buf.writeFloat(this.roffset);
    }

    public static void encode(MahoujinProjectorUpdatePacket msg, PacketBuffer buf) {
        msg.toBytes(buf);
    }

    public static MahoujinProjectorUpdatePacket decode(PacketBuffer buf) {
        MahoujinProjectorUpdatePacket msg = new MahoujinProjectorUpdatePacket();
        msg.fromBytes(buf);
        return msg;
    }

    public static void handle(final MahoujinProjectorUpdatePacket message, final Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                MahoujinProjectorUpdatePacket.updateTileEntity(message, ((NetworkEvent.Context)context.get()).getSender().field_70170_p);
            }
        });
        context.get().setPacketHandled(true);
    }

    public static void updateTileEntity(MahoujinProjectorUpdatePacket message, World world) {
        MahoujinProjectorTileEntity projector;
        if (world.func_175625_s(message.pos) instanceof MahoujinProjectorTileEntity && (projector = (MahoujinProjectorTileEntity)world.func_175625_s(message.pos)) != null) {
            projector.setCr(message.r);
            projector.setCg(message.g);
            projector.setCb(message.b);
            projector.setCa(message.a);
            projector.setCx(message.x);
            projector.setCy(message.y);
            projector.setCz(message.z);
            projector.setCsize(message.size);
            projector.setCspeed(message.speed);
            projector.setCyspeed(message.yspeed);
            projector.setCpspeed(message.pspeed);
            projector.setCyaw(message.yaw);
            projector.setCpitch(message.pitch);
            projector.setCringangle(message.ring);
            projector.setShowRing(message.sr);
            projector.setShowCircle(message.sc);
            projector.setImage(message.image);
            projector.setRunes(message.runes);
            projector.setHeight(message.height);
            projector.setRotationOffset(message.roffset);
            projector.sendUpdates();
        }
    }
}

