/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.entity;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.ObjectHolder;
import stepsword.mahoutsukai.entity.FamiliarEntity;
import stepsword.mahoutsukai.entity.GateWeaponProjectileEntity;
import stepsword.mahoutsukai.entity.MentalDisplacementEntity;
import stepsword.mahoutsukai.entity.WeaponProjectileEntity;
import stepsword.mahoutsukai.entity.fae.FaeEntity;
import stepsword.mahoutsukai.entity.mahoujin.AuthorityMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.MysticStaffMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.RhoAiasMahoujinEntity;
import stepsword.mahoutsukai.entity.mahoujin.SpatialDisorientationMahoujinEntity;

public class ModEntities {
    @ObjectHolder(value="mahoutsukai:weapon_projectile_entity")
    public static EntityType<WeaponProjectileEntity> WEAPON_PROJECTILE;
    @ObjectHolder(value="mahoutsukai:gate_weapon_projectile_entity")
    public static EntityType<GateWeaponProjectileEntity> GATE_WEAPON_PROJECTILE;
    @ObjectHolder(value="mahoutsukai:mental_displacement")
    public static EntityType<MentalDisplacementEntity> MENTAL_DISPLACEMENT;
    @ObjectHolder(value="mahoutsukai:mahoujin_entity")
    public static EntityType<MysticStaffMahoujinEntity> EXPLOSION_MAHOUJIN;
    @ObjectHolder(value="mahoutsukai:familiar_entity")
    public static EntityType<FamiliarEntity> FAMILIAR;
    @ObjectHolder(value="mahoutsukai:rho_aias_mahoujin_entity")
    public static EntityType<RhoAiasMahoujinEntity> RHO_AIAS;
    @ObjectHolder(value="mahoutsukai:spatial_mahoujin_entity")
    public static EntityType<SpatialDisorientationMahoujinEntity> SPATIAL_DISORIENTATION;
    @ObjectHolder(value="mahoutsukai:authority_mahoujin_entity")
    public static EntityType<AuthorityMahoujinEntity> AUTHORITY;
    @ObjectHolder(value="mahoutsukai:fae")
    public static EntityType<FaeEntity> FAE;

    public static void register(IForgeRegistry<EntityType<?>> registry) {
        registry.register(EntityType.Builder.func_220322_a(WeaponProjectileEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setShouldReceiveVelocityUpdates(true).setTrackingRange(90).setUpdateInterval(20).func_206830_a("weapon_projectile_entity").setRegistryName("mahoutsukai", "weapon_projectile_entity"));
        registry.register(EntityType.Builder.func_220322_a(GateWeaponProjectileEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setShouldReceiveVelocityUpdates(true).setTrackingRange(90).setUpdateInterval(20).func_206830_a("gate_weapon_projectile_entity").setRegistryName("mahoutsukai", "gate_weapon_projectile_entity"));
        registry.register(EntityType.Builder.func_220322_a(MentalDisplacementEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(1.0f, 1.0f).setShouldReceiveVelocityUpdates(true).setTrackingRange(80).setUpdateInterval(3).func_206830_a("mental_displacement").setRegistryName("mahoutsukai", "mental_displacement"));
        registry.register(EntityType.Builder.func_220322_a(FamiliarEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.5f, 0.5f).setShouldReceiveVelocityUpdates(false).setTrackingRange(200).setUpdateInterval(3).func_206830_a("familiar_entity").setRegistryName("mahoutsukai", "familiar_entity"));
        registry.register(EntityType.Builder.func_220322_a(MysticStaffMahoujinEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(false).setTrackingRange(200).setUpdateInterval(3).func_206830_a("mahoujin_entity").setRegistryName("mahoutsukai", "mahoujin_entity"));
        registry.register(EntityType.Builder.func_220322_a(RhoAiasMahoujinEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(false).setTrackingRange(200).setUpdateInterval(3).func_206830_a("rho_aias_mahoujin_entity").setRegistryName("mahoutsukai", "rho_aias_mahoujin_entity"));
        registry.register(EntityType.Builder.func_220322_a(SpatialDisorientationMahoujinEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(false).setTrackingRange(200).setUpdateInterval(3).func_206830_a("spatial_mahoujin_entity").setRegistryName("mahoutsukai", "spatial_mahoujin_entity"));
        registry.register(EntityType.Builder.func_220322_a(AuthorityMahoujinEntity::new, (EntityClassification)EntityClassification.MISC).setShouldReceiveVelocityUpdates(false).setTrackingRange(200).setUpdateInterval(3).func_206830_a("authority_mahoujin_entity").setRegistryName("mahoutsukai", "authority_mahoujin_entity"));
        registry.register(EntityType.Builder.func_220322_a(FaeEntity::new, (EntityClassification)EntityClassification.CREATURE).setShouldReceiveVelocityUpdates(false).setTrackingRange(200).setUpdateInterval(3).func_220321_a(0.5f, 0.5f).func_206830_a("fae").setRegistryName("mahoutsukai", "fae"));
        EntitySpawnPlacementRegistry.func_209343_a(FAE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, FaeEntity::getCanSpawnHere);
    }

    public static void registerSpawns() {
        ModEntities.addSpawn(FAE, 2, 3, 25, null, null);
    }

    public static void addSpawn(EntityType entityType, int min, int max, int weight, List<? extends String> include, List<? extends String> exclude) {
        if (weight > 0) {
            ArrayList spawnableBiomes = Lists.newArrayList();
            Collection includeList = BiomeDictionary.Type.getAll();
            ArrayList excludeList = new ArrayList();
            if (!includeList.isEmpty()) {
                for (BiomeDictionary.Type type : includeList) {
                    for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)type)) {
                        if (biome.func_76747_a(entityType.func_220339_d()).isEmpty()) continue;
                        spawnableBiomes.add(biome);
                    }
                }
                if (!excludeList.isEmpty()) {
                    for (BiomeDictionary.Type type : excludeList) {
                        if (type == null) continue;
                        Set excludeBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)type);
                        for (Biome biome : excludeBiomes) {
                            spawnableBiomes.remove(biome);
                        }
                    }
                }
            } else {
                throw new IllegalArgumentException("Do not leave the BiomeDictionary type inclusion list empty. If you wish to disable spawning of an entity, set the weight to 0 instead.");
            }
            for (Biome biome : spawnableBiomes) {
                biome.func_76747_a(entityType.func_220339_d()).add(new Biome.SpawnListEntry(entityType, weight, min, max));
            }
        }
    }

    public static BiomeDictionary.Type[] toBiomeTypeArray(List<? extends String> strings) {
        BiomeDictionary.Type[] types = new BiomeDictionary.Type[strings.size()];
        for (int i = 0; i < strings.size(); ++i) {
            String string = strings.get(i);
            types[i] = BiomeDictionary.Type.getType((String)string, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        }
        return types;
    }
}

