/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.mahou;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.util.BlockDim;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahouStorage
implements Capability.IStorage<IMahou> {
    private static String PLAYER_STORED_MANA = "MAHOUTSUKAI_PLAYER_STORED_MANA";
    private static String PLAYER_MAX_MANA = "MAHOUTSUKAI_PLAYER_MAX_MANA";
    private static String PLAYER_CHARGE_RATE = "MAHOUTSUKAI_PLAYER_CHARGE_RATE";
    private static String PLAYER_MANA_TO_USE_COUNTER = "MAHOUTSUKAI_MANA_UP_COUNTER";
    private static String PLAYER_FULL_MANA_FLAG = "MAHOUTSUKAI_MANA_FULL";
    private static String PLAYER_ENEMY = "MAHOUTSUKAI_PLAYER_ENEMY";
    private static String PLAYER_SAVED_SPAWN_X = "MAHOUTSUKAI_PLAYER_SAVED_SPAWN_X";
    private static String PLAYER_SAVED_SPAWN_Y = "MAHOUTSUKAI_PLAYER_SAVED_SPAWN_Y";
    private static String PLAYER_SAVED_SPAWN_Z = "MAHOUTSUKAI_PLAYER_SAVED_SPAWN_Z";
    private static String PLAYER_OLD_DIMENSION = "MAHOUTSUKAI_PLAYER_OLD_DIMENSION";
    private static String PLAYER_MARBLE_SPAWN_X = "MAHOUTSUKAI_PLAYER_MARBLE_SPAWN_X";
    private static String PLAYER_MARBLE_SPAWN_Y = "MAHOUTSUKAI_PLAYER_MARBLE_SPAWN_Y";
    private static String PLAYER_MARBLE_SPAWN_Z = "MAHOUTSUKAI_PLAYER_MARBLE_SPAWN_Z";
    private static String MEMORIZED_EDMTE_X = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_X";
    private static String MEMORIZED_EDMTE_Y = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_Y";
    private static String MEMORIZED_EDMTE_Z = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_Z";
    private static String MEMORIZED_EDMTE_D = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_D";
    private static String MENTAL_DISPLACEMENT_X = "MAHOUTSUKAI_PLAYER_MENTAL_DISPLACEMENT_ORIGINAL_X";
    private static String MENTAL_DISPLACEMENT_Y = "MAHOUTSUKAI_PLAYER_MENTAL_DISPLACEMENT_ORIGINAL_Y";
    private static String MENTAL_DISPLACEMENT_Z = "MAHOUTSUKAI_PLAYER_MENTAL_DISPLACEMENT_ORIGINAL_Z";
    private static String PLAYER_LAST_ARROW = "MAHOUTSUKAI_PLAYER_LAST_ARROW";
    private static String PROTECTIVE_DISPLACEMENT_USES = "MAHOUTSUKAI_PLAYER_PROTECTIVE_DISPLACEMENT_USES";
    private static String DAMAGE_EXCHANGE_USES = "MAHOUTSUKAI_PLAYER_DAMAGE_EXCHANGE_USES";
    private static String DEATH_COLLECTION_USES_LEFT = "MAHOUTSUKAI_PLAYER_DEATH_COLLECTION_USES_LEFT";
    private static String IS_POSSESSING = "MAHOUTSUKAI_PLAYER_POSSESSING";
    private static String DAMAGE_REPLICATION_TARGET = "MAHOUTSUKAI_PLAYER_DAMAGE_REPLICATION_TARGET";
    private static String HAS_MAGIC = "MAHOUTSUKAI_PLAYER_HAS_MAGIC";
    private static String PREV_YAW = "MAHOUTSUKAI_PLAYER_PREV_YAW";
    private static String PREV_PITCH = "MAHOUTSUKAI_PLAYER_PREV_PITCH";
    private static String PREV_EYE_X = "MAHOUTSUKAI_PLAYER_PREV_EYE_X";
    private static String PREV_EYE_Y = "MAHOUTSUKAI_PLAYER_PREV_EYE_Y";
    private static String PREV_EYE_Z = "MAHOUTSUKAI_PLAYER_PREV_EYE_Z";
    private static String LAST_RECIPE_CLOTH = "MAHOUTSUKAI_LAST_RECIPE_CLOTH";
    private static String LAST_RECIPE = "MAHOUTSUKAI_LAST_RECIPE";
    private static String AUTHORITY_HIT = "MAHOUTSUKAI_AUTHORITY_HIT";
    private static String INTERESTING_X = "MAHOUTSUKAI_FAMILIAR_INTERESTING_BLOCK_X";
    private static String INTERESTING_Y = "MAHOUTSUKAI_FAMILIAR_INTERESTING_BLOCK_Y";
    private static String INTERESTING_Z = "MAHOUTSUKAI_FAMILIAR_INTERESTING_BLOCK_Z";
    private static String FEAR_PERSON = "MAHOUTSUKAI_FEAR_PERSON";
    private static String IMMUNITY_DAMAGE_TYPE = "MAHOUTSUKAI_IMMUNITY_DAMAGE_TYPE";

    @Nullable
    public INBT writeNBT(Capability<IMahou> capability, IMahou instance, Direction side) {
        ArrayList<String> order;
        UnorderedList lst;
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a(PLAYER_STORED_MANA, instance.getStoredMana());
        nbt.func_74768_a(PLAYER_MAX_MANA, instance.getMaxMana());
        nbt.func_74780_a(PLAYER_CHARGE_RATE, instance.getChargeRate());
        nbt.func_74768_a(PLAYER_MANA_TO_USE_COUNTER, instance.getManaToUseCounter());
        nbt.func_74757_a(PLAYER_FULL_MANA_FLAG, instance.isManaFull());
        if (instance.getImmunityDamageType() != null) {
            nbt.func_74778_a(IMMUNITY_DAMAGE_TYPE, instance.getImmunityDamageType());
        }
        if (instance.getEnemy() != null) {
            nbt.func_186854_a(PLAYER_ENEMY, instance.getEnemy());
        }
        if (instance.getPlayerSavedSpawn() != null) {
            nbt.func_74768_a(PLAYER_SAVED_SPAWN_X, instance.getPlayerSavedSpawn().func_177958_n());
            nbt.func_74768_a(PLAYER_SAVED_SPAWN_Y, instance.getPlayerSavedSpawn().func_177956_o());
            nbt.func_74768_a(PLAYER_SAVED_SPAWN_Z, instance.getPlayerSavedSpawn().func_177952_p());
        }
        if (instance.getPlayerMarbleSpawn() != null) {
            nbt.func_74768_a(PLAYER_MARBLE_SPAWN_X, instance.getPlayerMarbleSpawn().func_177958_n());
            nbt.func_74768_a(PLAYER_MARBLE_SPAWN_Y, instance.getPlayerMarbleSpawn().func_177956_o());
            nbt.func_74768_a(PLAYER_MARBLE_SPAWN_Z, instance.getPlayerMarbleSpawn().func_177952_p());
        }
        if (instance.getPlayerOldDimension() != null) {
            nbt.func_74778_a(PLAYER_OLD_DIMENSION, instance.getPlayerOldDimension());
        }
        if (instance.getMemorizedEDMTE() != null) {
            nbt.func_74768_a(MEMORIZED_EDMTE_X, instance.getMemorizedEDMTE().pos.func_177958_n());
            nbt.func_74768_a(MEMORIZED_EDMTE_Y, instance.getMemorizedEDMTE().pos.func_177956_o());
            nbt.func_74768_a(MEMORIZED_EDMTE_Z, instance.getMemorizedEDMTE().pos.func_177952_p());
            if (instance.getMemorizedEDMTE().dim != null) {
                nbt.func_74778_a(MEMORIZED_EDMTE_D, instance.getMemorizedEDMTE().dim.getRegistryName().toString());
            }
        }
        if (instance.getLastArrowShot() != null) {
            nbt.func_186854_a(PLAYER_LAST_ARROW, instance.getLastArrowShot());
        }
        if (instance.getMentalDisplacementPos() != null) {
            nbt.func_74768_a(MENTAL_DISPLACEMENT_X, instance.getMentalDisplacementPos().func_177958_n());
            nbt.func_74768_a(MENTAL_DISPLACEMENT_Y, instance.getMentalDisplacementPos().func_177956_o());
            nbt.func_74768_a(MENTAL_DISPLACEMENT_Z, instance.getMentalDisplacementPos().func_177952_p());
        }
        nbt.func_74768_a(PROTECTIVE_DISPLACEMENT_USES, instance.getProtectiveDisplacement());
        nbt.func_74768_a(DAMAGE_EXCHANGE_USES, instance.getDamageExchangeUses());
        nbt.func_74776_a(DEATH_COLLECTION_USES_LEFT, instance.getDeathCollectionUsesLeft());
        nbt.func_74757_a(IS_POSSESSING, instance.isPossessing());
        nbt.func_74757_a(HAS_MAGIC, instance.hasMagic());
        nbt.func_74776_a(PREV_PITCH, instance.getPlayerPrevPitch());
        nbt.func_74776_a(PREV_YAW, instance.getPlayerPrevYaw());
        if (instance.getFearPerson() != null) {
            nbt.func_186854_a(FEAR_PERSON, instance.getFearPerson());
        }
        if (instance.getPlayerPrevEyePos() != null) {
            nbt.func_74776_a(PREV_EYE_X, (float)instance.getPlayerPrevEyePos().field_72450_a);
            nbt.func_74776_a(PREV_EYE_Y, (float)instance.getPlayerPrevEyePos().field_72448_b);
            nbt.func_74776_a(PREV_EYE_Z, (float)instance.getPlayerPrevEyePos().field_72449_c);
        }
        if (instance.getFamiliarInterestingBlock() != null) {
            nbt.func_74776_a(INTERESTING_X, (float)instance.getFamiliarInterestingBlock().func_177958_n());
            nbt.func_74776_a(INTERESTING_Y, (float)instance.getFamiliarInterestingBlock().func_177956_o());
            nbt.func_74776_a(INTERESTING_Z, (float)instance.getFamiliarInterestingBlock().func_177952_p());
        }
        if (instance.getDamageReplicationTarget() != null) {
            nbt.func_186854_a(DAMAGE_REPLICATION_TARGET, instance.getDamageReplicationTarget());
        }
        if (instance.getLastRecipe() != null && (lst = instance.getLastRecipe()).size() == 3 && (order = lst.getOrder()) != null && order.size() == 3) {
            String s1 = (String)order.get(0);
            String s2 = (String)order.get(1);
            String s3 = (String)order.get(2);
            nbt.func_74778_a(LAST_RECIPE + "1", s1);
            nbt.func_74778_a(LAST_RECIPE + "2", s2);
            nbt.func_74778_a(LAST_RECIPE + "3", s3);
        }
        nbt.func_74757_a(LAST_RECIPE_CLOTH, instance.getLastRecipeCloth());
        nbt.func_74757_a(AUTHORITY_HIT, instance.getAuthorityHit());
        return nbt;
    }

    public void readNBT(Capability<IMahou> capability, IMahou instance, Direction side, INBT nbtb) {
        CompoundNBT nbt = (CompoundNBT)nbtb;
        instance.setChargeRate(nbt.func_74769_h(PLAYER_CHARGE_RATE));
        instance.setManaFull(nbt.func_74767_n(PLAYER_FULL_MANA_FLAG));
        instance.setManaToUseCounter(nbt.func_74762_e(PLAYER_MANA_TO_USE_COUNTER));
        instance.setMaxMana(nbt.func_74762_e(PLAYER_MAX_MANA));
        if (nbt.func_74764_b(IMMUNITY_DAMAGE_TYPE)) {
            instance.setImmunityDamageType(nbt.func_74779_i(IMMUNITY_DAMAGE_TYPE));
        }
        instance.setStoredMana(nbt.func_74762_e(PLAYER_STORED_MANA));
        if (nbt.func_74764_b(PLAYER_SAVED_SPAWN_X) && nbt.func_74764_b(PLAYER_SAVED_SPAWN_Y) && nbt.func_74764_b(PLAYER_SAVED_SPAWN_Z)) {
            instance.setPlayerSavedSpawn(new BlockPos(nbt.func_74762_e(PLAYER_SAVED_SPAWN_X), nbt.func_74762_e(PLAYER_SAVED_SPAWN_Y), nbt.func_74762_e(PLAYER_SAVED_SPAWN_Z)));
        }
        if (nbt.func_74764_b(PLAYER_MARBLE_SPAWN_X) && nbt.func_74764_b(PLAYER_MARBLE_SPAWN_Y) && nbt.func_74764_b(PLAYER_MARBLE_SPAWN_Z)) {
            instance.setPlayerMarbleSpawn(new BlockPos(nbt.func_74762_e(PLAYER_MARBLE_SPAWN_X), nbt.func_74762_e(PLAYER_MARBLE_SPAWN_Y), nbt.func_74762_e(PLAYER_MARBLE_SPAWN_Z)));
        }
        if (nbt.func_74764_b(INTERESTING_X) && nbt.func_74764_b(INTERESTING_Y) && nbt.func_74764_b(INTERESTING_Z)) {
            instance.setFamiliarInterestingBlock(new BlockPos(nbt.func_74762_e(INTERESTING_X), nbt.func_74762_e(INTERESTING_Y), nbt.func_74762_e(INTERESTING_Z)));
        }
        if (nbt.func_74764_b(PLAYER_OLD_DIMENSION)) {
            instance.setPlayerOldDimension(nbt.func_74779_i(PLAYER_OLD_DIMENSION));
        }
        if (nbt.func_186855_b(PLAYER_ENEMY)) {
            instance.setEnemy(nbt.func_186857_a(PLAYER_ENEMY));
        }
        if (nbt.func_186855_b(PLAYER_LAST_ARROW)) {
            instance.setLastArrowShot(nbt.func_186857_a(PLAYER_LAST_ARROW));
        }
        if (nbt.func_74764_b(MEMORIZED_EDMTE_X) && nbt.func_74764_b(MEMORIZED_EDMTE_Y) && nbt.func_74764_b(MEMORIZED_EDMTE_Z)) {
            BlockDim blockDim = new BlockDim(new BlockPos(nbt.func_74762_e(MEMORIZED_EDMTE_X), nbt.func_74762_e(MEMORIZED_EDMTE_Y), nbt.func_74762_e(MEMORIZED_EDMTE_Z)), nbt.func_74764_b(MEMORIZED_EDMTE_D) ? DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(nbt.func_74779_i(MEMORIZED_EDMTE_D))) : DimensionType.field_223227_a_);
            instance.setMemorizedEDMTE(blockDim);
        }
        if (nbt.func_74764_b(MENTAL_DISPLACEMENT_X) && nbt.func_74764_b(MENTAL_DISPLACEMENT_Y) && nbt.func_74764_b(MENTAL_DISPLACEMENT_Z)) {
            BlockPos pos = new BlockPos(nbt.func_74762_e(MENTAL_DISPLACEMENT_X), nbt.func_74762_e(MENTAL_DISPLACEMENT_Y), nbt.func_74762_e(MENTAL_DISPLACEMENT_Z));
            instance.setMentalDisplacementPos(pos);
        }
        if (nbt.func_74764_b(PREV_EYE_X) && nbt.func_74764_b(PREV_EYE_Y) && nbt.func_74764_b(PREV_EYE_Z)) {
            Vec3d vec = new Vec3d((double)nbt.func_74760_g(PREV_EYE_X), (double)nbt.func_74760_g(PREV_EYE_Y), (double)nbt.func_74760_g(PREV_EYE_Z));
            instance.setPlayerPrevEyePos(vec);
        }
        instance.setProtectiveDisplacement(nbt.func_74762_e(PROTECTIVE_DISPLACEMENT_USES));
        instance.setDamageExchangeUses(nbt.func_74762_e(DAMAGE_EXCHANGE_USES));
        instance.setDeathCollectionUsesLeft(nbt.func_74760_g(DEATH_COLLECTION_USES_LEFT));
        instance.setPossessing(nbt.func_74767_n(IS_POSSESSING));
        instance.setHasMagic(nbt.func_74767_n(HAS_MAGIC));
        instance.setPlayerPrevPitch(nbt.func_74760_g(PREV_PITCH));
        instance.setPlayerPrevYaw(nbt.func_74760_g(PREV_YAW));
        if (nbt.func_186855_b(DAMAGE_REPLICATION_TARGET)) {
            instance.setDamageReplicationTarget(nbt.func_186857_a(DAMAGE_REPLICATION_TARGET));
        }
        if (nbt.func_186855_b(FEAR_PERSON)) {
            instance.setFearPerson(nbt.func_186857_a(FEAR_PERSON));
        }
        instance.setLastRecipeCloth(nbt.func_74767_n(LAST_RECIPE_CLOTH));
        if (nbt.func_74764_b(LAST_RECIPE + "1") && nbt.func_74764_b(LAST_RECIPE + "2") && nbt.func_74764_b(LAST_RECIPE + "3")) {
            UnorderedList ul = MahoujinRecipeRegistrar.makeRecipe(nbt.func_74779_i(LAST_RECIPE + "1"), nbt.func_74779_i(LAST_RECIPE + "2"), nbt.func_74779_i(LAST_RECIPE + "3"));
            instance.setLastRecipe(ul);
        }
        instance.setAuthorityHit(nbt.func_74767_n(AUTHORITY_HIT));
    }
}

