/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.thirdparty.computercraft;

import java.util.LinkedHashMap;
import java.util.List;
import me.desht.pneumaticcraft.common.thirdparty.computercraft.ILuaMethod;
import net.minecraft.util.Direction;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public abstract class LuaMethod
implements ILuaMethod {
    private final String methodName;

    protected LuaMethod(String methodName) {
        this.methodName = methodName;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    protected Direction getDirForString(String luaParm) {
        return Direction.valueOf((String)luaParm.toUpperCase());
    }

    LinkedHashMap<Integer, String> getStringTable(List<String> list) {
        LinkedHashMap<Integer, String> table = new LinkedHashMap<Integer, String>();
        for (int i = 0; i < list.size(); ++i) {
            table.put(i + 1, list.get(i));
        }
        return table;
    }

    protected void requireArgs(Object[] args, int min, int max, String desc) {
        Validate.isTrue((args.length >= min && args.length <= max ? 1 : 0) != 0, (String)String.format("Method '%s' takes between %d and %d arguments! (%s)", this.getMethodName(), min, max, desc), (Object[])new Object[0]);
    }

    protected void requireArgs(Object[] args, int len, String desc) {
        Validate.isTrue((args.length == len ? 1 : 0) != 0, (String)String.format("Method '%s' takes exactly %d arguments! (%s)", this.getMethodName(), len, desc), (Object[])new Object[0]);
    }

    protected void requireArgs(Object[] args, int[] argcount, String desc) {
        for (int a : argcount) {
            if (args.length != a) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method '%s' takes either %s arguments! (%s)", this.getMethodName(), StringUtils.join((Object[])ArrayUtils.toObject((int[])argcount), (String)" or "), desc));
    }

    protected void requireNoArgs(Object[] args) {
        Validate.isTrue((args.length == 0 ? 1 : 0) != 0, (String)String.format("Method '%s' takes no arguments!", this.getMethodName()), (Object[])new Object[0]);
    }
}

