/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.TrackerBlacklistManager;
import me.desht.pneumaticcraft.client.util.ClientUtils;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketSendNBTPacket
extends LocationIntPacket {
    private CompoundNBT tag;

    public PacketSendNBTPacket() {
    }

    public PacketSendNBTPacket(TileEntity te) {
        super(te.func_174877_v());
        this.tag = new CompoundNBT();
        te.func_189515_b(this.tag);
    }

    public PacketSendNBTPacket(PacketBuffer buffer) {
        super(buffer);
        try {
            this.tag = new PacketBuffer((ByteBuf)buffer).func_150793_b();
        }
        catch (Exception e) {
            Log.error("An exception occured when trying to decode a Send NBT Packet.", new Object[0]);
            e.printStackTrace();
        }
    }

    @Override
    public void toBytes(PacketBuffer buffer) {
        super.toBytes(buffer);
        try {
            buffer.func_150786_a(this.tag);
        }
        catch (Exception e) {
            Log.error("An exception occured when trying to encode a Send NBT Packet.", new Object[0]);
            e.printStackTrace();
        }
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            TileEntity te = ClientUtils.getClientTE(this.pos);
            if (te != null) {
                try {
                    te.func_145839_a(this.tag);
                }
                catch (Throwable e) {
                    TrackerBlacklistManager.addInventoryTEToBlacklist(te, e);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

