/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import me.desht.pneumaticcraft.common.block.BlockElevatorFrame;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftCamo;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorBase;
import me.desht.pneumaticcraft.common.tileentity.TileEntityElevatorCaller;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockElevatorCaller
extends BlockPneumaticCraftCamo {
    public BlockElevatorCaller() {
        super(ModBlocks.defaultProps());
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntityElevatorCaller.class;
    }

    @Override
    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult brtr) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityElevatorCaller) {
            int floor;
            TileEntityElevatorCaller teEC = (TileEntityElevatorCaller)te;
            if (!world.field_72995_K && (floor = this.getFloorForHit(teEC, brtr.func_216354_b(), brtr.func_216347_e().field_72450_a, brtr.func_216347_e().field_72448_b, brtr.func_216347_e().field_72449_c)) >= 0) {
                BlockElevatorCaller.setSurroundingElevators(world, pos, floor);
            }
        }
        return this.getRotation(state).func_176734_d() == brtr.func_216354_b() ? ActionResultType.SUCCESS : ActionResultType.PASS;
    }

    private int getFloorForHit(TileEntityElevatorCaller teEC, Direction side, double hitX, double hitY, double hitZ) {
        double x;
        switch (side) {
            case NORTH: {
                x = Math.abs(hitX % 1.0);
                break;
            }
            case SOUTH: {
                x = 1.0 - Math.abs(hitX % 1.0);
                break;
            }
            case EAST: {
                x = Math.abs(hitZ % 1.0);
                break;
            }
            case WEST: {
                x = 1.0 - Math.abs(hitZ % 1.0);
                break;
            }
            default: {
                return -1;
            }
        }
        double y = 1.0 - hitY % 1.0;
        for (TileEntityElevatorCaller.ElevatorButton button : teEC.getFloors()) {
            if (!(x >= (double)button.posX) || !(x <= (double)(button.posX + button.width)) || !(y >= (double)button.posY) || !(y <= (double)(button.posY + button.height))) continue;
            return button.floorNumber;
        }
        return -1;
    }

    @Override
    protected boolean doesCamoOverrideBounds() {
        return false;
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_197868_b();
    }

    public static void setSurroundingElevators(World world, BlockPos pos, int floor) {
        for (Direction dir : PneumaticCraftUtils.HORIZONTALS) {
            TileEntityElevatorBase elevator = BlockElevatorCaller.getElevatorBase(world, pos.func_177972_a(dir).func_177967_a(Direction.DOWN, 2));
            if (elevator == null) continue;
            elevator.goToFloor(floor);
        }
    }

    public void func_220082_b(BlockState newState, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.func_220082_b(newState, world, pos, oldState, isMoving);
        this.updateElevatorButtons(world, pos);
    }

    @Override
    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        this.updateElevatorButtons(world, pos);
        super.func_196243_a(state, world, pos, newState, isMoving);
    }

    private void updateElevatorButtons(World world, BlockPos pos) {
        for (Direction dir : PneumaticCraftUtils.HORIZONTALS) {
            TileEntityElevatorBase elevator = BlockElevatorCaller.getElevatorBase(world, pos.func_177972_a(dir).func_177967_a(Direction.DOWN, 2));
            if (elevator == null) continue;
            elevator.updateFloors();
            break;
        }
    }

    private static TileEntityElevatorBase getElevatorBase(World world, BlockPos pos) {
        TileEntity te;
        Block block = world.func_180495_p(pos).func_177230_c();
        TileEntityElevatorBase elevator = null;
        if (block == ModBlocks.ELEVATOR_FRAME.get()) {
            elevator = BlockElevatorFrame.getElevatorTE((IBlockReader)world, pos);
        }
        if (block == ModBlocks.ELEVATOR_BASE.get() && (te = world.func_175625_s(pos)) instanceof TileEntityElevatorBase && ((TileEntityElevatorBase)te).isCoreElevator()) {
            elevator = (TileEntityElevatorBase)te;
        }
        return elevator;
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader par1IBlockAccess, BlockPos pos, Direction side) {
        TileEntity te = par1IBlockAccess.func_175625_s(pos);
        if (te instanceof TileEntityElevatorCaller) {
            TileEntityElevatorCaller teEc = (TileEntityElevatorCaller)te;
            return teEc.getEmittingRedstone() ? 15 : 0;
        }
        return 0;
    }
}

