/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import me.desht.pneumaticcraft.client.gui.GuiPneumaticContainerBase;
import me.desht.pneumaticcraft.client.gui.widget.WidgetAnimatedStat;
import me.desht.pneumaticcraft.common.core.ModBlocks;
import me.desht.pneumaticcraft.common.inventory.ContainerAssemblyController;
import me.desht.pneumaticcraft.common.recipes.assembly.AssemblyProgram;
import me.desht.pneumaticcraft.common.tileentity.IAssemblyMachine;
import me.desht.pneumaticcraft.common.tileentity.TileEntityAssemblyController;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class GuiAssemblyController
extends GuiPneumaticContainerBase<ContainerAssemblyController, TileEntityAssemblyController> {
    private WidgetAnimatedStat statusStat;

    public GuiAssemblyController(ContainerAssemblyController container, PlayerInventory inv, ITextComponent displayString) {
        super(container, inv, displayString);
    }

    @Override
    public void init() {
        super.init();
        this.statusStat = this.addAnimatedStat("gui.tab.status", new ItemStack((IItemProvider)ModBlocks.ASSEMBLY_CONTROLLER.get()), -22016, false);
    }

    @Override
    protected void func_146979_b(int x, int y) {
        super.func_146979_b(x, y);
        this.font.func_211126_b("Prog.", 70.0f, 24.0f, 0x404040);
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return Textures.GUI_ASSEMBLY_CONTROLLER;
    }

    @Override
    public void tick() {
        super.tick();
        this.statusStat.setText(this.getStatusText());
    }

    private List<String> getStatusText() {
        ArrayList<String> text = new ArrayList<String>();
        EnumSet<AssemblyProgram.EnumMachine> foundMachines = EnumSet.of(AssemblyProgram.EnumMachine.CONTROLLER);
        for (IAssemblyMachine machine : ((TileEntityAssemblyController)this.te).findMachines(AssemblyProgram.EnumMachine.values().length)) {
            foundMachines.add(machine.getAssemblyType());
        }
        for (AssemblyProgram.EnumMachine m : AssemblyProgram.EnumMachine.values()) {
            if (m == AssemblyProgram.EnumMachine.CONTROLLER) continue;
            String s = foundMachines.contains((Object)m) ? TextFormatting.DARK_GREEN + "\u2714 " : TextFormatting.RED + "\u2717 ";
            text.add(s + TextFormatting.BLACK + " " + I18n.func_135052_a((String)m.getTranslationKey(), (Object[])new Object[0]));
        }
        return text;
    }

    @Override
    protected void addProblems(List<String> textList) {
        super.addProblems(textList);
        ((TileEntityAssemblyController)this.te).addProblems(textList);
    }
}

