/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostcities.worldgen;

import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FourWayBlock;
import net.minecraft.block.LadderBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.StairsShape;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.WorldGenRegion;

public class ChunkDriver {
    private WorldGenRegion region;
    private IChunk primer;
    private final BlockPos.Mutable current = new BlockPos.Mutable();
    private final BlockPos.Mutable pos = new BlockPos.Mutable();

    public void setPrimer(WorldGenRegion region, IChunk primer) {
        this.region = region;
        this.primer = primer;
    }

    public WorldGenRegion getRegion() {
        return this.region;
    }

    public IChunk getPrimer() {
        return this.primer;
    }

    public ChunkDriver current(int x, int y, int z) {
        this.current.func_181079_c(x, y, z);
        return this;
    }

    public ChunkDriver current(BlockPos i) {
        this.current.func_189533_g((Vec3i)i);
        return this;
    }

    public BlockPos getCurrentCopy() {
        return this.current.func_185334_h();
    }

    public void incY() {
        this.current.func_185336_p(this.current.func_177956_o() + 1);
    }

    public void incY(int amount) {
        this.current.func_185336_p(this.current.func_177956_o() + amount);
    }

    public void decY() {
        this.current.func_185336_p(this.current.func_177956_o() - 1);
    }

    public void incX() {
        this.current.func_223471_o(this.current.func_177958_n() + 1);
    }

    public void incZ() {
        this.current.func_223472_q(this.current.func_177952_p() + 1);
    }

    public int getX() {
        return this.current.func_177958_n();
    }

    public int getY() {
        return this.current.func_177956_o();
    }

    public int getZ() {
        return this.current.func_177952_p();
    }

    public void setBlockRange(int x, int y, int z, int y2, BlockState state) {
        this.pos.func_181079_c(x, y, z);
        while (y < y2) {
            if (this.primer.func_180495_p((BlockPos)this.pos) != state) {
                this.primer.func_177436_a((BlockPos)this.pos, state, false);
            }
            this.pos.func_185336_p(++y);
        }
    }

    public void setBlockRange(int x, int y, int z, int y2, BlockState state, Predicate<BlockState> test) {
        this.pos.func_181079_c(x, y, z);
        while (y < y2) {
            BlockState st = this.primer.func_180495_p((BlockPos)this.pos);
            if (st != state && test.test(st)) {
                this.primer.func_177436_a((BlockPos)this.pos, state, false);
            }
            this.pos.func_185336_p(++y);
        }
    }

    public void setBlockRangeSafe(int x, int y, int z, int y2, BlockState state) {
        this.pos.func_181079_c(x, y, z);
        while (y < y2) {
            if (this.primer.func_180495_p((BlockPos)this.pos) != state) {
                this.primer.func_177436_a((BlockPos)this.pos, state, false);
            }
            this.pos.func_185336_p(++y);
        }
    }

    public void setBlockRangeSafe(int x, int y, int z, int y2, BlockState state, Predicate<BlockState> test) {
        this.pos.func_181079_c(x, y, z);
        while (y < y2) {
            BlockState st = this.primer.func_180495_p((BlockPos)this.pos);
            if (st != state && test.test(st)) {
                this.primer.func_177436_a((BlockPos)this.pos, state, false);
            }
            this.pos.func_185336_p(++y);
        }
    }

    private BlockState updateAdjacent(BlockState state, Direction direction, BlockPos pos, IChunk thisChunk) {
        IChunk chunk;
        BlockState adjacent = this.region.func_180495_p(pos);
        if (adjacent.func_177230_c() instanceof LadderBlock) {
            return adjacent;
        }
        BlockState newAdjacent = null;
        try {
            newAdjacent = adjacent.func_196956_a(direction, state, (IWorld)this.region, pos, pos.func_177972_a(direction));
        }
        catch (Exception e) {
            return adjacent;
        }
        if (newAdjacent != adjacent && ((chunk = this.region.func_217349_x(pos)) == thisChunk || chunk.func_201589_g().func_209003_a(ChunkStatus.field_222617_m))) {
            this.region.func_180501_a(pos, newAdjacent, 0);
        }
        return newAdjacent;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.func_177230_c() instanceof StairsBlock;
    }

    private static boolean isDifferentStairs(BlockState state, IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(face));
        return !ChunkDriver.isBlockStairs(blockstate) || blockstate.func_177229_b((IProperty)StairsBlock.field_176309_a) != state.func_177229_b((IProperty)StairsBlock.field_176309_a) || blockstate.func_177229_b((IProperty)StairsBlock.field_176308_b) != state.func_177229_b((IProperty)StairsBlock.field_176308_b);
    }

    private static StairsShape getShapeProperty(BlockState state, IBlockReader worldIn, BlockPos pos) {
        Direction direction2;
        Direction direction1;
        Direction direction = (Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a);
        BlockState blockstate = worldIn.func_180495_p(pos.func_177972_a(direction));
        if (ChunkDriver.isBlockStairs(blockstate) && state.func_177229_b((IProperty)StairsBlock.field_176308_b) == blockstate.func_177229_b((IProperty)StairsBlock.field_176308_b) && (direction1 = (Direction)blockstate.func_177229_b((IProperty)StairsBlock.field_176309_a)).func_176740_k() != ((Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a)).func_176740_k() && ChunkDriver.isDifferentStairs(state, worldIn, pos, direction1.func_176734_d())) {
            if (direction1 == direction.func_176735_f()) {
                return StairsShape.OUTER_LEFT;
            }
            return StairsShape.OUTER_RIGHT;
        }
        BlockState blockstate1 = worldIn.func_180495_p(pos.func_177972_a(direction.func_176734_d()));
        if (ChunkDriver.isBlockStairs(blockstate1) && state.func_177229_b((IProperty)StairsBlock.field_176308_b) == blockstate1.func_177229_b((IProperty)StairsBlock.field_176308_b) && (direction2 = (Direction)blockstate1.func_177229_b((IProperty)StairsBlock.field_176309_a)).func_176740_k() != ((Direction)state.func_177229_b((IProperty)StairsBlock.field_176309_a)).func_176740_k() && ChunkDriver.isDifferentStairs(state, worldIn, pos, direction2)) {
            if (direction2 == direction.func_176735_f()) {
                return StairsShape.INNER_LEFT;
            }
            return StairsShape.INNER_RIGHT;
        }
        return StairsShape.STRAIGHT;
    }

    private static boolean canAttach(BlockState state) {
        if (state.func_196958_f()) {
            return false;
        }
        if (state.func_200132_m()) {
            return true;
        }
        return !Block.func_220073_a((Block)state.func_177230_c());
    }

    private BlockState correct(BlockState state) {
        int cx = this.current.func_177958_n() + this.primer.func_76632_l().field_77276_a * 16;
        int cy = this.current.func_177956_o();
        int cz = this.current.func_177952_p() + this.primer.func_76632_l().field_77275_b * 16;
        IChunk thisChunk = this.region.func_212866_a_(cx >> 4, cz >> 4);
        BlockState westState = this.updateAdjacent(state, Direction.EAST, (BlockPos)this.pos.func_181079_c(cx - 1, cy, cz), thisChunk);
        BlockState eastState = this.updateAdjacent(state, Direction.WEST, (BlockPos)this.pos.func_181079_c(cx + 1, cy, cz), thisChunk);
        BlockState northState = this.updateAdjacent(state, Direction.SOUTH, (BlockPos)this.pos.func_181079_c(cx, cy, cz - 1), thisChunk);
        BlockState southState = this.updateAdjacent(state, Direction.NORTH, (BlockPos)this.pos.func_181079_c(cx, cy, cz + 1), thisChunk);
        if (state.func_177230_c() instanceof FourWayBlock) {
            state = (BlockState)state.func_206870_a((IProperty)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(westState)));
            state = (BlockState)state.func_206870_a((IProperty)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(eastState)));
            state = (BlockState)state.func_206870_a((IProperty)FourWayBlock.field_196409_a, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(northState)));
            state = (BlockState)state.func_206870_a((IProperty)FourWayBlock.field_196413_c, (Comparable)Boolean.valueOf(ChunkDriver.canAttach(southState)));
        } else if (state.func_177230_c() instanceof StairsBlock) {
            state = (BlockState)state.func_206870_a((IProperty)StairsBlock.field_176310_M, (Comparable)ChunkDriver.getShapeProperty(state, (IBlockReader)this.region, (BlockPos)this.pos.func_181079_c(cx, cy, cz)));
        }
        return state;
    }

    public ChunkDriver blockImm(BlockState c) {
        this.primer.func_177436_a((BlockPos)this.current, c, false);
        return this;
    }

    public ChunkDriver block(BlockState c) {
        this.primer.func_177436_a((BlockPos)this.current, this.correct(c), false);
        return this;
    }

    public ChunkDriver add(BlockState state) {
        this.primer.func_177436_a((BlockPos)this.current, this.correct(state), false);
        this.incY();
        return this;
    }

    public BlockState getBlock() {
        return this.primer.func_180495_p((BlockPos)this.current);
    }

    public BlockState getBlockDown() {
        return this.primer.func_180495_p((BlockPos)this.pos.func_181079_c(this.current.func_177958_n(), this.current.func_177956_o() - 1, this.current.func_177952_p()));
    }

    public BlockState getBlockEast() {
        return this.primer.func_180495_p((BlockPos)this.pos.func_181079_c(this.current.func_177958_n() + 1, this.current.func_177956_o(), this.current.func_177952_p()));
    }

    public BlockState getBlockWest() {
        return this.primer.func_180495_p((BlockPos)this.pos.func_181079_c(this.current.func_177958_n() - 1, this.current.func_177956_o(), this.current.func_177952_p()));
    }

    public BlockState getBlockSouth() {
        return this.primer.func_180495_p((BlockPos)this.pos.func_181079_c(this.current.func_177958_n(), this.current.func_177956_o(), this.current.func_177952_p() + 1));
    }

    public BlockState getBlockNorth() {
        return this.primer.func_180495_p((BlockPos)this.pos.func_181079_c(this.current.func_177958_n(), this.current.func_177956_o(), this.current.func_177952_p() - 1));
    }

    public BlockState getBlock(int x, int y, int z) {
        return this.primer.func_180495_p((BlockPos)this.pos.func_181079_c(x, y, z));
    }
}

