/*
 * Decompiled with CFR 0.152.
 */
package snownee.lightingwand.compat;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaRecipeCategoryUid;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IExtendableRecipeCategory;
import mezz.jei.api.recipe.category.extensions.vanilla.crafting.ICraftingCategoryExtension;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IVanillaCategoryExtensionRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import snownee.lightingwand.common.RepairRecipe;

@JeiPlugin
public class JEICompat
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return new ResourceLocation("lightingwand", "lightingwand");
    }

    public void registerRecipes(IRecipeRegistration registration) {
        registration.addRecipes(RepairRecipe.Serializer.recipes, VanillaRecipeCategoryUid.CRAFTING);
    }

    public void registerVanillaCategoryExtensions(IVanillaCategoryExtensionRegistration registration) {
        IExtendableRecipeCategory craftingCategory = registration.getCraftingCategory();
        craftingCategory.addCategoryExtension(RepairRecipe.class, RepairRecipeWrapper::new);
    }

    private static class RepairRecipeWrapper
    implements ICraftingCategoryExtension {
        private RepairRecipe recipe;

        public RepairRecipeWrapper(RepairRecipe recipe) {
            this.recipe = recipe;
        }

        public void setIngredients(IIngredients ingredients) {
            ArrayList inputs = Lists.newArrayListWithCapacity((int)2);
            ItemStack broken = new ItemStack((IItemProvider)this.recipe.getRepairable());
            int duration = broken.func_77958_k();
            broken.func_196085_b(duration);
            inputs.add(Ingredient.func_193369_a((ItemStack[])new ItemStack[]{broken}));
            inputs.add(this.recipe.getMaterial());
            ingredients.setInputIngredients((List)inputs);
            ItemStack output = new ItemStack((IItemProvider)this.recipe.getRepairable());
            output.func_196085_b(MathHelper.func_76125_a((int)(duration - MathHelper.func_76123_f((float)(duration / this.recipe.getRatio()))), (int)0, (int)duration));
            ingredients.setOutput(VanillaTypes.ITEM, (Object)output);
        }
    }
}

