/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.message;

import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatUtils;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageRatCommand {
    public int ratId;
    public int newCommand;

    public MessageRatCommand() {
    }

    public MessageRatCommand(int ratId, int newCommand) {
        this.ratId = ratId;
        this.newCommand = newCommand;
    }

    public static MessageRatCommand read(PacketBuffer buf) {
        return new MessageRatCommand(buf.readInt(), buf.readInt());
    }

    public static void write(MessageRatCommand message, PacketBuffer buf) {
        buf.writeInt(message.ratId);
        buf.writeInt(message.newCommand);
    }

    public static class Handler {
        public static void handle(MessageRatCommand message, Supplier<NetworkEvent.Context> context) {
            Entity entity;
            context.get().setPacketHandled(true);
            ServerPlayerEntity player = context.get().getSender();
            if (player != null && (entity = player.field_70170_p.func_73045_a(message.ratId)) instanceof EntityRat) {
                EntityRat rat = (EntityRat)entity;
                rat.setCommand(RatUtils.wrapCommand(message.newCommand));
            }
        }
    }
}

