/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.server.entity.EntityFeralRatlantean;
import com.github.alexthe666.rats.server.entity.EntityRatMountBase;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class EntityRatBeastMount
extends EntityRatMountBase
implements IAnimatedEntity {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_SLASH = Animation.create((int)25);
    public static final Animation ANIMATION_SNIFF = Animation.create((int)20);
    private static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityFeralRatlantean.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int animationTick;
    private Animation currentAnimation;

    protected EntityRatBeastMount(EntityType<? extends MobEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70138_W = 1.0f;
        this.upgrade = RatsItemRegistry.RAT_UPGRADE_BEAST_MOUNT;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.4);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(64.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(4.0);
        this.func_110148_a(SWIM_SPEED).func_111128_a(1.0);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(this.field_70146_Z.nextBoolean() ? ANIMATION_SLASH : ANIMATION_BITE);
        }
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        float idleSpeed = 0.3f;
        float idleDegree = 0.015f;
        float walkSpeed = 0.4f;
        float walkDegree = 0.1f;
        float bob = -((float)(Math.sin((float)this.field_70173_aa * idleSpeed) * (double)idleDegree - (double)idleDegree));
        float bob_walk = -((float)(Math.sin(this.field_184619_aG * walkSpeed) * (double)this.field_70721_aZ * (double)walkDegree - (double)walkDegree));
        this.riderY = 0.8f + bob + bob_walk;
        this.riderXZ = 0.1f;
        if (this.getAnimation() == ANIMATION_SNIFF || this.getAnimation() == ANIMATION_SLASH) {
            float max;
            float jumpAdd = max = 0.75f;
            if (this.getAnimationTick() < 5) {
                jumpAdd = (float)this.getAnimationTick() * (max / 3.0f);
            }
            if (this.getAnimationTick() > 15) {
                jumpAdd = (float)(20 - this.getAnimationTick()) * (max / 10.0f);
            }
            this.riderY += (double)jumpAdd;
        }
        if (this.func_70638_az() != null && this.func_70032_d((Entity)this.func_70638_az()) < 5.0f && this.func_70685_l((Entity)this.func_70638_az()) && this.func_70638_az().func_70089_S()) {
            this.func_70625_a((Entity)this.func_70638_az(), 360.0f, 80.0f);
            if (this.getAnimation() == ANIMATION_BITE && this.getAnimationTick() > 8 && this.getAnimationTick() < 12) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 5.0f);
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 0.25f, this.func_226277_ct_() - this.func_70638_az().func_226277_ct_(), this.func_226281_cx_() - this.func_70638_az().func_226281_cx_());
            }
            if (this.getAnimation() == ANIMATION_SLASH && (this.getAnimationTick() == 8 || this.getAnimationTick() == 16)) {
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 5.0f);
                this.func_70638_az().func_70653_a((Entity)this.func_70638_az(), 0.25f, this.func_226277_ct_() - this.func_70638_az().func_226277_ct_(), this.func_226281_cx_() - this.func_70638_az().func_226281_cx_());
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.field_70146_Z.nextInt(150) == 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SNIFF);
        }
    }

    public int getColorVariant() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)color);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("ColorVariant", this.getColorVariant());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setColorVariant(compound.func_74762_e("ColorVariant"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setColorVariant(this.func_70681_au().nextInt(4));
        return spawnDataIn;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_BITE, ANIMATION_SLASH, ANIMATION_SNIFF};
    }

    protected SoundEvent func_184639_G() {
        return RatsSoundRegistry.RAT_PLAGUE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return RatsSoundRegistry.RAT_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return RatsSoundRegistry.RAT_DIE;
    }

    protected float func_70647_i() {
        return super.func_70647_i() * 0.4f;
    }
}

