/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.blocks.BlockRatCage;
import com.github.alexthe666.rats.server.blocks.BlockRatHole;
import com.github.alexthe666.rats.server.blocks.BlockRatTube;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityCheeseCannonball;
import com.github.alexthe666.rats.server.entity.EntityLaserBeam;
import com.github.alexthe666.rats.server.entity.EntityLaserPortal;
import com.github.alexthe666.rats.server.entity.EntityRatDragonFire;
import com.github.alexthe666.rats.server.entity.EntityRatKing;
import com.github.alexthe666.rats.server.entity.EntityRatMountBase;
import com.github.alexthe666.rats.server.entity.EntityRattlingGun;
import com.github.alexthe666.rats.server.entity.EntityThrownBlock;
import com.github.alexthe666.rats.server.entity.IRatlantean;
import com.github.alexthe666.rats.server.entity.ISummonsRats;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatNukeExplosion;
import com.github.alexthe666.rats.server.entity.RatStatus;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.ai.AquaticRatPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.EtherealRatPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.FlyingRatPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.RatAIAttackMelee;
import com.github.alexthe666.rats.server.entity.ai.RatAIDepositEnergy;
import com.github.alexthe666.rats.server.entity.ai.RatAIDepositFluid;
import com.github.alexthe666.rats.server.entity.ai.RatAIDepositInInventory;
import com.github.alexthe666.rats.server.entity.ai.RatAIEnterTrap;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleeMobs;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleePosition;
import com.github.alexthe666.rats.server.entity.ai.RatAIFleeSun;
import com.github.alexthe666.rats.server.entity.ai.RatAIFollowOwner;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestBreeder;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestCrops;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestFarmer;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestFisherman;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestMilk;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestMine;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestPlacer;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestShears;
import com.github.alexthe666.rats.server.entity.ai.RatAIHarvestTrees;
import com.github.alexthe666.rats.server.entity.ai.RatAIHuntPrey;
import com.github.alexthe666.rats.server.entity.ai.RatAIHurtByTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAIOwnerHurtByTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAIOwnerHurtTarget;
import com.github.alexthe666.rats.server.entity.ai.RatAIPickupEnergy;
import com.github.alexthe666.rats.server.entity.ai.RatAIPickupFluid;
import com.github.alexthe666.rats.server.entity.ai.RatAIPickupFromInventory;
import com.github.alexthe666.rats.server.entity.ai.RatAIRaidChests;
import com.github.alexthe666.rats.server.entity.ai.RatAIRaidCrops;
import com.github.alexthe666.rats.server.entity.ai.RatAISit;
import com.github.alexthe666.rats.server.entity.ai.RatAISwimming;
import com.github.alexthe666.rats.server.entity.ai.RatAITargetItems;
import com.github.alexthe666.rats.server.entity.ai.RatAIWander;
import com.github.alexthe666.rats.server.entity.ai.RatAIWanderAquatic;
import com.github.alexthe666.rats.server.entity.ai.RatAIWanderFlight;
import com.github.alexthe666.rats.server.entity.ai.RatAquaticMoveHelper;
import com.github.alexthe666.rats.server.entity.ai.RatEtherealMoveHelper;
import com.github.alexthe666.rats.server.entity.ai.RatFlyingMoveHelper;
import com.github.alexthe666.rats.server.entity.ai.RatPathNavigate;
import com.github.alexthe666.rats.server.entity.ai.RatPathPathNavigateGround;
import com.github.alexthe666.rats.server.entity.ai.RatTubeMoveHelper;
import com.github.alexthe666.rats.server.entity.ai.RatTubePathNavigate;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatCraftingTable;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatHole;
import com.github.alexthe666.rats.server.inventory.ContainerRat;
import com.github.alexthe666.rats.server.items.ItemRatSack;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeBucket;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeCombined;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeEnergy;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeJuryRigged;
import com.github.alexthe666.rats.server.items.ItemRatUpgradeOreDoubling;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import com.github.alexthe666.rats.server.message.MessageDancingRat;
import com.github.alexthe666.rats.server.message.MessageSyncThrownBlock;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.github.alexthe666.rats.server.recipes.RatsRecipeRegistry;
import com.github.alexthe666.rats.server.recipes.SharedRecipe;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.EntitySenses;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockNamedItem;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityRat
extends TameableEntity
implements IAnimatedEntity,
IRatlantean {
    public static final Animation ANIMATION_EAT = Animation.create((int)10);
    public static final Animation ANIMATION_IDLE_SCRATCH = Animation.create((int)25);
    public static final Animation ANIMATION_IDLE_SNIFF = Animation.create((int)20);
    public static final Animation ANIMATION_DANCE_0 = Animation.create((int)35);
    public static final Animation ANIMATION_DANCE_1 = Animation.create((int)30);
    public static final ResourceLocation CHRISTMAS_LOOT = new ResourceLocation("rats", "christmas_rat_gifts");
    protected static final DataParameter<Optional<UUID>> MONSTER_OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> IS_MALE = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TOGA = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> PLAGUE = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> VISUAL_FLAG = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TAMED_BY_MONSTER = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> COMMAND = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR_VARIANT = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DANCING = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> DANCE_MOVES = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> HELD_RF = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> RESPAWN_COUNTDOWN = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_CUSTOM_RADIUS = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<BlockPos> RADIUS_CENTER = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Integer> SEARCH_RADIUS = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DYED = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EntityRat.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final ResourceLocation PLAGUE_RAT_LOOT_TABLE = new ResourceLocation("rats", "entities/plague_rat");
    private static final String[] RAT_TEXTURES = new String[]{"rats:textures/entity/rat/rat_blue.png", "rats:textures/entity/rat/rat_black.png", "rats:textures/entity/rat/rat_brown.png", "rats:textures/entity/rat/rat_green.png", "rats:textures/entity/rat/tamed/rat_albino.png", "rats:textures/entity/rat/tamed/rat_hooded.png", "rats:textures/entity/rat/tamed/rat_hooded_brown.png", "rats:textures/entity/rat/tamed/rat_hooded_gray.png", "rats:textures/entity/rat/tamed/rat_siamese.png", "rats:textures/entity/rat/tamed/rat_white.png", "rats:textures/entity/rat/tamed/rat_hooded_yellow.png", "rats:textures/entity/rat/tamed/rat_brown_undercoat.png", "rats:textures/entity/rat/tamed/rat_dark_undercoat.png"};
    private static final SoundEvent[] CRAFTING_SOUNDS = new SoundEvent[]{SoundEvents.field_187698_i, SoundEvents.field_187881_gQ, SoundEvents.field_191253_dD, SoundEvents.field_187647_cU, SoundEvents.field_187726_cu, SoundEvents.field_187728_s, SoundEvents.field_187719_p, SoundEvents.field_187713_n, SoundEvents.field_187927_ha};
    public float sitProgress;
    public float holdProgress;
    public float deadInTrapProgress;
    public float sleepProgress;
    public boolean isDeadInTrap;
    public BlockPos fleePos;
    public boolean holdInMouth = true;
    public int wildTrust = 0;
    public BlockPos depositPos;
    public Direction depositFacing = Direction.UP;
    public BlockPos pickupPos;
    public BlockPos tubeTarget = null;
    public int cheeseFeedings = 0;
    public boolean climbingTube = false;
    public boolean waterBased = false;
    public boolean crafting = false;
    public int cookingProgress = 0;
    public int coinCooldown = 0;
    public int breedCooldown = 0;
    public float flyingPitch;
    public float prevFlyingPitch;
    public BlockPos jukeboxPos;
    public boolean isFleeing = false;
    public FluidStack transportingFluid = FluidStack.EMPTY;
    public int mountRespawnCooldown = 0;
    public List<BlockPos> openRatTubes = new ArrayList<BlockPos>();
    protected Inventory ratInventory;
    protected int navigatorType;
    private boolean inTube;
    private boolean inCage;
    private int animationTick;
    private Animation currentAnimation;
    private RatStatus status = RatStatus.IDLE;
    private BlockPos finalDigPathPoint = null;
    private BlockPos diggingPos = null;
    private int breakingTime;
    private int previousBreakProgress = -1;
    private int digCooldown = 0;
    private int eatingTicks = 0;
    private ItemStack prevUpgrade = ItemStack.field_190927_a;
    private int eatenItems = 0;
    private Goal aiHarvest;
    private Goal aiPickup;
    private Goal aiDeposit;
    private int rangedAttackCooldownCannon = 0;
    private int rangedAttackCooldownLaser = 0;
    private int rangedAttackCooldownPsychic = 0;
    private int rangedAttackCooldownDragon = 0;
    private int visualCooldown = 0;
    private int poopCooldown = 0;
    private int randomEffectCooldown = 0;

    public EntityRat(EntityType type, World worldIn) {
        super(type, worldIn);
        this.func_184644_a(PathNodeType.RAIL, 1000.0f);
        this.switchNavigator(1);
        this.initInventory();
    }

    public static BlockPos getPositionRelativetoGround(EntityRat rat, World world, double x, double z, Random rng) {
        if (rat.func_213394_dL()) {
            x = (float)(rat.func_213384_dI().func_177958_n() + rng.nextInt((int)rat.func_213391_dJ())) - rat.func_213391_dJ() / 2.0f;
            z = (float)(rat.func_213384_dI().func_177952_p() + rng.nextInt((int)rat.func_213391_dJ())) - rat.func_213391_dJ() / 2.0f;
        }
        BlockPos pos = new BlockPos(x, rat.func_226278_cu_(), z);
        while ((world.func_175623_d(pos.func_177977_b()) || world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockRatCage) && pos.func_177956_o() > 0) {
            pos = pos.func_177977_b();
        }
        if (rat.isInCage()) {
            return pos.func_177981_b(rat.func_70681_au().nextInt(3));
        }
        return pos.func_177981_b(3 + rat.func_70681_au().nextInt(3));
    }

    public static BlockPos getPositionRelativetoWater(EntityRat rat, World world, double x, double z, Random rng) {
        BlockPos topY = new BlockPos(x, rat.func_226278_cu_(), z);
        BlockPos bottomY = new BlockPos(x, rat.func_226278_cu_(), z);
        while (world.func_180495_p(topY).func_185904_a() == Material.field_151586_h && topY.func_177956_o() < world.func_217301_I()) {
            topY = topY.func_177984_a();
        }
        while (world.func_180495_p(bottomY).func_185904_a() == Material.field_151586_h && bottomY.func_177956_o() > 0) {
            bottomY = bottomY.func_177977_b();
        }
        for (int tries = 0; tries < 5; ++tries) {
            BlockPos pos = new BlockPos(x, (double)(bottomY.func_177956_o() + 1 + rng.nextInt(Math.max(1, topY.func_177956_o() - bottomY.func_177956_o() - 2))), z);
            if (world.func_180495_p(pos).func_185904_a() != Material.field_151586_h) continue;
            return pos;
        }
        return rat.func_180425_c();
    }

    public static boolean canEntityTypeSpawn(EntityType<? extends MobEntity> p_223315_0_, IWorld p_223315_1_, SpawnReason p_223315_2_, BlockPos p_223315_3_, Random p_223315_4_) {
        if (RatConfig.ratOverworldOnly && p_223315_1_.func_201675_m().func_186058_p() != DimensionType.field_223227_a_) {
            return false;
        }
        BlockPos blockpos = p_223315_3_.func_177977_b();
        if (p_223315_1_.func_175659_aa() != Difficulty.PEACEFUL || p_223315_4_.nextInt(32) == 0) {
            return p_223315_2_ == SpawnReason.SPAWNER || EntityRat.spawnCheck(p_223315_1_, p_223315_3_, p_223315_4_);
        }
        return false;
    }

    private static boolean spawnCheck(IWorld world, BlockPos pos, Random rand) {
        int spawnRoll = RatConfig.ratSpawnDecrease;
        if (RatUtils.canSpawnInDimension(world)) {
            if (RatConfig.ratsSpawnLikeMonsters) {
                if (world.func_175659_aa() == Difficulty.PEACEFUL) {
                    spawnRoll *= 2;
                }
                if (spawnRoll == 0 || rand.nextInt(spawnRoll) == 0) {
                    return EntityRat.isValidLightLevel(world, rand, pos);
                }
            } else {
                return (spawnRoll /= 2) == 0 || rand.nextInt(spawnRoll) == 0;
            }
        }
        return false;
    }

    protected static boolean isValidLightLevel(IWorld world, Random rand, BlockPos pos) {
        if (world.func_226658_a_(LightType.SKY, pos) > rand.nextInt(32)) {
            return false;
        }
        int i = world.func_201672_e().func_72911_I() ? world.func_205049_d(pos, 10) : world.func_201696_r(pos);
        return i <= rand.nextInt(8);
    }

    protected void func_184651_r() {
        this.aiHarvest = new RatAIHarvestCrops(this);
        this.aiPickup = new RatAIPickupFromInventory(this);
        this.aiDeposit = new RatAIDepositInInventory(this);
        this.field_70714_bg.func_75776_a(0, (Goal)new RatAIAttackMelee(this, 1.45, true));
        this.field_70714_bg.func_75776_a(1, (Goal)new RatAISwimming(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RatAIFleeMobs(this, new Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                return entity.func_70089_S() && entity instanceof PlayerEntity && ((PlayerEntity)entity).func_184582_a(EquipmentSlotType.HEAD).func_77973_b() != RatsItemRegistry.PIPER_HAT && !((PlayerEntity)entity).func_184812_l_() || entity instanceof OcelotEntity;
            }
        }, 10.0f, 0.8, 1.225));
        this.field_70714_bg.func_75776_a(3, (Goal)new RatAIFollowOwner(this, 1.225, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new RatAIFleeSun(this, 1.225));
        this.field_70911_d = new RatAISit(this);
        this.field_70714_bg.func_75776_a(5, (Goal)this.field_70911_d);
        this.field_70714_bg.func_75776_a(6, (Goal)new RatAIWander(this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new RatAIWanderFlight(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new RatAIWanderAquatic(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RatAIRaidChests(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RatAIRaidCrops(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RatAIEnterTrap(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new RatAIFleePosition(this));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, LivingEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, new RatAITargetItems(this, false));
        this.field_70715_bh.func_75776_a(1, new RatAIHuntPrey(this, new Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                if (EntityRat.this.hasPlague()) {
                    return entity instanceof PlayerEntity && !entity.func_184191_r((Entity)EntityRat.this) && entity.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() != RatsItemRegistry.BLACK_DEATH_MASK && entity.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL;
                }
                if (entity instanceof TameableEntity && ((TameableEntity)entity).func_70909_n()) {
                    return false;
                }
                if (EntityRat.this.shouldHuntMonster()) {
                    return entity instanceof IMob;
                }
                return entity != null && !(entity instanceof EntityRat) && !(entity instanceof EntityRatMountBase) && !(entity instanceof PlayerEntity) && !entity.func_70631_g_();
            }
        }));
        this.field_70715_bh.func_75776_a(2, (Goal)new RatAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new RatAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(4, (Goal)new RatAIHurtByTarget(this, CatEntity.class, OcelotEntity.class));
    }

    protected void setupDynamicAI() {
        this.field_70714_bg.func_85156_a(this.aiHarvest);
        this.field_70714_bg.func_85156_a(this.aiDeposit);
        this.field_70714_bg.func_85156_a(this.aiPickup);
        boolean flag = false;
        this.aiHarvest = new RatAIHarvestCrops(this);
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) && !(this.aiHarvest instanceof RatAIHarvestTrees)) {
            this.aiHarvest = new RatAIHarvestTrees(this);
            flag = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !(this.aiHarvest instanceof RatAIHarvestMine)) {
            this.aiHarvest = new RatAIHarvestMine(this);
            flag = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && !(this.aiHarvest instanceof RatAIHarvestFarmer)) {
            this.aiHarvest = new RatAIHarvestFarmer(this);
            flag = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && !(this.aiHarvest instanceof RatAIHarvestFisherman)) {
            this.aiHarvest = new RatAIHarvestFisherman(this);
            flag = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MILKER) && !(this.aiHarvest instanceof RatAIHarvestMilk)) {
            this.aiHarvest = new RatAIHarvestMilk(this);
            flag = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS) && !(this.aiHarvest instanceof RatAIHarvestShears)) {
            this.aiHarvest = new RatAIHarvestShears(this);
            flag = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLACER) && !(this.aiHarvest instanceof RatAIHarvestPlacer)) {
            this.aiHarvest = new RatAIHarvestPlacer(this);
            flag = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BREEDER) && !(this.aiHarvest instanceof RatAIHarvestBreeder)) {
            this.aiHarvest = new RatAIHarvestBreeder(this);
            flag = true;
        }
        if (this.aiHarvest == null || !flag) {
            this.aiHarvest = new RatAIHarvestCrops(this);
        }
        if (this.getMBTransferRate() > 0) {
            this.aiDeposit = new RatAIPickupFluid(this);
            this.aiPickup = new RatAIDepositFluid(this);
        } else if (this.getRFTransferRate() > 0) {
            this.aiDeposit = new RatAIPickupEnergy(this);
            this.aiPickup = new RatAIDepositEnergy(this);
        } else {
            this.aiDeposit = new RatAIDepositInInventory(this);
            this.aiPickup = new RatAIPickupFromInventory(this);
        }
        this.field_70714_bg.func_75776_a(3, this.aiHarvest);
        this.field_70714_bg.func_75776_a(4, this.aiDeposit);
        this.field_70714_bg.func_75776_a(4, this.aiPickup);
    }

    @Nullable
    public LivingEntity getMonsterOwner() {
        try {
            Entity entity;
            UUID uuid = this.getMonsterOwnerID();
            if (!this.field_70170_p.field_72995_K && (entity = this.field_70170_p.func_73046_m().func_71218_a(this.field_71093_bK).func_217461_a(uuid)) instanceof LivingEntity) {
                return (LivingEntity)entity;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    @Nullable
    public LivingEntity func_70902_q() {
        try {
            PlayerEntity player;
            UUID uuid = this.func_184753_b();
            PlayerEntity playerEntity = player = uuid == null ? null : this.field_70170_p.func_217371_b(uuid);
            if (player != null) {
                return player;
            }
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
        return null;
    }

    public boolean func_213397_c(double distanceToClosestPlayer) {
        if (RatConfig.ratsSpawnLikeMonsters) {
            return (!this.func_70909_n() || this.wasTamedByMonster()) && !this.func_70631_g_();
        }
        return super.func_213397_c(distanceToClosestPlayer);
    }

    public void func_70623_bb() {
        if (!this.func_104002_bU() && !this.func_213392_I()) {
            PlayerEntity entity = this.field_70170_p.func_217362_a((Entity)this, -1.0);
            Event.Result result = ForgeEventFactory.canEntityDespawn((MobEntity)this);
            if (result == Event.Result.DENY) {
                this.field_70708_bq = 0;
                entity = null;
            } else if (result == Event.Result.ALLOW) {
                this.func_70106_y();
                entity = null;
            }
            if (entity != null) {
                double d0 = entity.func_70068_e((Entity)this);
                if (this.func_213397_c(d0) && d0 > RatConfig.ratDespawnFarDistance * RatConfig.ratDespawnFarDistance) {
                    this.func_70106_y();
                }
                double closeDist = RatConfig.ratDespawnCloseDistance * RatConfig.ratDespawnCloseDistance;
                if (this.field_70708_bq > 600 && this.field_70146_Z.nextInt(RatConfig.ratDespawnRandomChance) == 0 && d0 > closeDist && this.func_213397_c(d0)) {
                    this.func_70106_y();
                } else if (d0 < closeDist) {
                    this.field_70708_bq = 0;
                }
            }
        }
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        int spawnRoll = RatConfig.ratSpawnDecrease;
        if (RatUtils.canSpawnInDimension((IWorld)this.field_70170_p)) {
            if (RatConfig.ratsSpawnLikeMonsters) {
                if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
                    spawnRoll *= 2;
                }
                if (spawnRoll == 0 || this.field_70146_Z.nextInt(spawnRoll) == 0) {
                    BlockPos pos = new BlockPos((Entity)this);
                    BlockState BlockState2 = this.field_70170_p.func_180495_p(pos.func_177977_b());
                    return this.isValidLightLevel() && BlockState2.func_215688_a((IBlockReader)this.field_70170_p, pos.func_177977_b(), RatsEntityRegistry.RAT);
                }
            } else {
                return ((spawnRoll /= 2) == 0 || this.field_70146_Z.nextInt(spawnRoll) == 0) && super.func_213380_a(worldIn, spawnReasonIn);
            }
        }
        return false;
    }

    public boolean func_70648_aU() {
        return this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC);
    }

    public boolean isValidLightLevel() {
        BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b, this.func_226281_cx_());
        if (this.field_70170_p.func_226658_a_(LightType.SKY, blockpos) > this.field_70146_Z.nextInt(32)) {
            return false;
        }
        int i = this.field_70170_p.func_72911_I() ? this.field_70170_p.func_205049_d(blockpos, 10) : this.field_70170_p.func_201696_r(blockpos);
        return i <= this.field_70146_Z.nextInt(8);
    }

    public boolean func_70617_f_() {
        if (this.inTube()) {
            return this.climbingTube;
        }
        return super.func_70617_f_();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_MALE, (Object)false);
        this.field_70180_af.func_187214_a(TOGA, (Object)false);
        this.field_70180_af.func_187214_a(PLAGUE, (Object)false);
        this.field_70180_af.func_187214_a(VISUAL_FLAG, (Object)false);
        this.field_70180_af.func_187214_a(TAMED_BY_MONSTER, (Object)false);
        this.field_70180_af.func_187214_a(COMMAND, (Object)0);
        this.field_70180_af.func_187214_a(COLOR_VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(DANCING, (Object)false);
        this.field_70180_af.func_187214_a(DANCE_MOVES, (Object)0);
        this.field_70180_af.func_187214_a(HELD_RF, (Object)0);
        this.field_70180_af.func_187214_a(RESPAWN_COUNTDOWN, (Object)0);
        this.field_70180_af.func_187214_a(RADIUS_CENTER, (Object)this.func_180425_c());
        this.field_70180_af.func_187214_a(HAS_CUSTOM_RADIUS, (Object)false);
        this.field_70180_af.func_187214_a(SEARCH_RADIUS, (Object)RatConfig.defaultRatRadius);
        this.field_70180_af.func_187214_a(DYED, (Object)false);
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(MONSTER_OWNER_UNIQUE_ID, Optional.empty());
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(128.0);
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void switchNavigator(int type) {
        if (type == 1) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new RatPathPathNavigateGround(this, this.field_70170_p);
            this.navigatorType = 1;
        } else if (type == 0) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new RatPathPathNavigateGround(this, this.field_70170_p);
            this.navigatorType = 0;
        } else if (type == 2) {
            this.field_70765_h = new RatFlyingMoveHelper(this);
            this.field_70699_by = new FlyingRatPathNavigate(this, this.field_70170_p);
            this.navigatorType = 2;
        } else if (type == 3) {
            this.field_70765_h = new RatTubeMoveHelper(this);
            RatTubePathNavigate newNav = new RatTubePathNavigate((MobEntity)this, this.field_70170_p);
            if (this.field_70699_by.func_75505_d() != null && this.field_70699_by.func_75505_d().func_75870_c() != null) {
                PathPoint point = this.field_70699_by.func_75505_d().func_75870_c();
                newNav.func_75492_a(point.field_75839_a, point.field_75837_b, point.field_75838_c, 1.0);
                this.field_70699_by.func_75499_g();
            }
            this.field_70699_by = newNav;
            this.navigatorType = 3;
        } else if (type == 4) {
            this.field_70765_h = new RatAquaticMoveHelper(this);
            this.field_70699_by = new AquaticRatPathNavigate(this, this.field_70170_p);
            this.navigatorType = 4;
        } else if (type == 5) {
            this.field_70765_h = new RatEtherealMoveHelper(this);
            this.field_70699_by = new EtherealRatPathNavigate(this, this.field_70170_p);
            this.navigatorType = 5;
        }
    }

    protected PathNavigator func_175447_b(World worldIn) {
        if (this.func_70909_n() && !this.isInCage()) {
            return super.func_175447_b(worldIn);
        }
        return new RatPathNavigate((MobEntity)this, worldIn);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("HomeDistance", this.func_213391_dJ());
        if (this.func_213384_dI() != null) {
            compound.func_74768_a("HomePosX", this.func_213384_dI().func_177958_n());
            compound.func_74768_a("HomePosY", this.func_213384_dI().func_177956_o());
            compound.func_74768_a("HomePosZ", this.func_213384_dI().func_177952_p());
        }
        if (this.getSearchRadiusCenter() != null) {
            compound.func_74768_a("RadiusPosX", this.getSearchRadiusCenter().func_177958_n());
            compound.func_74768_a("RadiusPosY", this.getSearchRadiusCenter().func_177956_o());
            compound.func_74768_a("RadiusPosZ", this.getSearchRadiusCenter().func_177952_p());
        }
        compound.func_74757_a("CustomSearchZone", this.hasCustomSearchZone());
        compound.func_74768_a("SearchRadius", this.getSearchRadius());
        compound.func_74768_a("CookingProgress", this.cookingProgress);
        compound.func_74768_a("DigCooldown", this.digCooldown);
        compound.func_74768_a("BreedCooldown", this.breedCooldown);
        compound.func_74768_a("CoinCooldown", this.coinCooldown);
        compound.func_74768_a("CheeseFeedings", this.cheeseFeedings);
        compound.func_74768_a("MountCooldown", this.mountRespawnCooldown);
        compound.func_74768_a("TransportingRF", this.getHeldRF());
        compound.func_74768_a("RespawnCountdown", this.getRespawnCountdown());
        compound.func_74768_a("Command", this.getCommandInteger());
        compound.func_74768_a("ColorVariant", this.getColorVariant());
        compound.func_74757_a("Plague", this.hasPlague());
        compound.func_74757_a("TamedByMonster", this.wasTamedByMonster());
        compound.func_74757_a("VisualFlag", this.getVisualFlag());
        compound.func_74757_a("Dancing", this.isDancing());
        compound.func_74757_a("Toga", this.hasToga());
        compound.func_74757_a("IsMale", this.isMale());
        compound.func_74768_a("WildTrust", this.wildTrust);
        compound.func_74757_a("Dyed", this.isDyed());
        compound.func_74774_a("DyeColor", (byte)this.getDyeColor());
        if (this.ratInventory != null) {
            ListNBT nbttaglist = new ListNBT();
            for (int i = 0; i < this.ratInventory.func_70302_i_(); ++i) {
                ItemStack itemstack = this.ratInventory.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                CompoundNBT CompoundNBT2 = new CompoundNBT();
                CompoundNBT2.func_74774_a("Slot", (byte)i);
                itemstack.func_77955_b(CompoundNBT2);
                nbttaglist.add((Object)CompoundNBT2);
            }
            compound.func_218657_a("Items", (INBT)nbttaglist);
        }
        compound.func_74768_a("EatenItems", this.eatenItems);
        if (this.pickupPos != null) {
            compound.func_74768_a("PickupPosX", this.pickupPos.func_177958_n());
            compound.func_74768_a("PickupPosY", this.pickupPos.func_177956_o());
            compound.func_74768_a("PickupPosZ", this.pickupPos.func_177952_p());
        }
        if (this.depositPos != null) {
            compound.func_74768_a("DepositPosX", this.depositPos.func_177958_n());
            compound.func_74768_a("DepositPosY", this.depositPos.func_177956_o());
            compound.func_74768_a("DepositPosZ", this.depositPos.func_177952_p());
            compound.func_74768_a("DepositFacing", this.depositFacing.ordinal());
        }
        compound.func_74768_a("RandomEffectCooldown", this.randomEffectCooldown);
        if (this.transportingFluid != null) {
            CompoundNBT fluidTag = new CompoundNBT();
            this.transportingFluid.writeToNBT(fluidTag);
            compound.func_218657_a("TransportingFluid", (INBT)fluidTag);
        }
        if (this.func_145818_k_()) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.func_200201_e()));
        }
        if (this.getMonsterOwnerID() == null) {
            compound.func_74778_a("MonsterOwnerUUID", "");
        } else {
            compound.func_74778_a("MonsterOwnerUUID", this.getMonsterOwnerID().toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        CompoundNBT fluidTag;
        ListNBT nbttaglist;
        super.func_70037_a(compound);
        if (compound.func_74764_b("HomePosX") && compound.func_74764_b("HomePosY") && compound.func_74764_b("HomePosZ")) {
            this.func_213390_a(new BlockPos(compound.func_74762_e("HomePosX"), compound.func_74762_e("HomePosY"), compound.func_74762_e("HomePosZ")), compound.func_74762_e("HomeDistance"));
        }
        if (compound.func_74764_b("RadiusPosX") && compound.func_74764_b("RadiusPosY") && compound.func_74764_b("RadiusPosZ")) {
            this.setSearchRadiusCenter(new BlockPos(compound.func_74762_e("RadiusPosX"), compound.func_74762_e("RadiusPosY"), compound.func_74762_e("RadiusPosZ")));
        }
        this.setCustomSearchZone(compound.func_74767_n("CustomSearchZone"));
        this.setSearchRadius(compound.func_74762_e("SearchRadius"));
        this.cookingProgress = compound.func_74762_e("CookingProgress");
        this.digCooldown = compound.func_74762_e("DigCooldown");
        this.breedCooldown = compound.func_74762_e("BreedCooldown");
        this.coinCooldown = compound.func_74762_e("CoinCooldown");
        this.wildTrust = compound.func_74762_e("WildTrust");
        this.eatenItems = compound.func_74762_e("EatenItems");
        this.mountRespawnCooldown = compound.func_74762_e("MountCooldown");
        this.cheeseFeedings = compound.func_74762_e("CheeseFeedings");
        this.randomEffectCooldown = compound.func_74762_e("RandomEffectCooldown");
        this.setHeldRF(compound.func_74762_e("TransportingRF"));
        this.setRespawnCountdown(compound.func_74762_e("RespawnCountdown"));
        this.setCommandInteger(compound.func_74762_e("Command"));
        this.setPlague(compound.func_74767_n("Plague"));
        this.setTamedByMonster(compound.func_74767_n("TamedByMonster"));
        this.setDancing(compound.func_74767_n("Dancing"));
        this.setVisualFlag(compound.func_74767_n("VisualFlag"));
        this.setToga(compound.func_74767_n("Toga"));
        this.setMale(compound.func_74767_n("IsMale"));
        this.setColorVariant(compound.func_74762_e("ColorVariant"));
        this.setDyed(compound.func_74767_n("Dyed"));
        this.setDyeColor(compound.func_74771_c("DyeColor"));
        if (this.ratInventory != null) {
            nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT2 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT2.func_74771_c("Slot") & 0xFF;
                if (j > 4) continue;
                ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)CompoundNBT2);
                this.ratInventory.func_70299_a(j, itemstack);
            }
        } else {
            nbttaglist = compound.func_150295_c("Items", 10);
            this.initInventory();
            for (int i = 0; i < nbttaglist.size(); ++i) {
                CompoundNBT CompoundNBT3 = nbttaglist.func_150305_b(i);
                int j = CompoundNBT3.func_74771_c("Slot") & 0xFF;
                ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)CompoundNBT3);
                this.ratInventory.func_70299_a(j, itemstack);
            }
        }
        if (compound.func_74764_b("PickupPosX") && compound.func_74764_b("PickupPosY") && compound.func_74764_b("PickupPosZ")) {
            this.pickupPos = new BlockPos(compound.func_74762_e("PickupPosX"), compound.func_74762_e("PickupPosY"), compound.func_74762_e("PickupPosZ"));
        }
        if (compound.func_74764_b("DepositPosX") && compound.func_74764_b("DepositPosY") && compound.func_74764_b("DepositPosZ")) {
            this.depositPos = new BlockPos(compound.func_74762_e("DepositPosX"), compound.func_74762_e("DepositPosY"), compound.func_74762_e("DepositPosZ"));
            if (compound.func_74764_b("DepositFacing")) {
                this.depositFacing = Direction.values()[compound.func_74762_e("DepositFacing")];
            }
        }
        if (compound.func_74764_b("TransportingFluid") && !(fluidTag = compound.func_74775_l("TransportingFluid")).isEmpty()) {
            this.transportingFluid = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTag);
        }
        if (compound.func_150297_b("CustomName", 8) && !compound.func_74779_i("CustomName").startsWith("TextComponent")) {
            this.func_200203_b(ITextComponent.Serializer.func_150699_a((String)compound.func_74779_i("CustomName")));
        }
        String s = "";
        if (compound.func_150297_b("MonsterOwnerUUID", 8)) {
            s = compound.func_74779_i("MonsterOwnerUUID");
        }
        if (!s.isEmpty()) {
            try {
                this.setMonsterOwnerUniqueId(UUID.fromString(s));
                this.setTamedByMonster(true);
            }
            catch (Throwable var4) {
                this.setTamedByMonster(false);
            }
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source) || source == DamageSource.field_76368_d && this.func_184218_aH()) {
            return false;
        }
        Entity entity = source.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof PlayerEntity) && !(entity instanceof ArrowEntity)) {
            amount = (amount + 1.0f) / 2.0f;
        }
        return super.func_70097_a(source, amount);
    }

    private int getCommandInteger() {
        return (Integer)this.field_70180_af.func_187225_a(COMMAND);
    }

    private void setCommandInteger(int command) {
        this.field_70180_af.func_187227_b(COMMAND, (Object)command);
        if (command == RatCommand.SIT.ordinal()) {
            this.func_70904_g(true);
        } else {
            this.func_70904_g(false);
        }
    }

    public int getColorVariant() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR_VARIANT);
    }

    public void setColorVariant(int color) {
        this.field_70180_af.func_187227_b(COLOR_VARIANT, (Object)color);
    }

    public void setToga(boolean plague) {
        this.field_70180_af.func_187227_b(TOGA, (Object)plague);
    }

    public boolean hasToga() {
        return (Boolean)this.field_70180_af.func_187225_a(TOGA);
    }

    public void setPlague(boolean plague) {
        this.field_70180_af.func_187227_b(PLAGUE, (Object)plague);
    }

    public boolean hasPlague() {
        return (Boolean)this.field_70180_af.func_187225_a(PLAGUE);
    }

    public void setTamedByMonster(boolean plague) {
        this.field_70180_af.func_187227_b(TAMED_BY_MONSTER, (Object)plague);
    }

    public boolean wasTamedByMonster() {
        return (Boolean)this.field_70180_af.func_187225_a(TAMED_BY_MONSTER);
    }

    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_MALE);
    }

    public void setMale(boolean male) {
        this.field_70180_af.func_187227_b(IS_MALE, (Object)male);
    }

    public boolean getVisualFlag() {
        return (Boolean)this.field_70180_af.func_187225_a(VISUAL_FLAG);
    }

    public void setVisualFlag(boolean flag) {
        this.field_70180_af.func_187227_b(VISUAL_FLAG, (Object)flag);
    }

    public boolean isDancing() {
        return (Boolean)this.field_70180_af.func_187225_a(DANCING);
    }

    public void setDancing(boolean dancing) {
        this.field_70180_af.func_187227_b(DANCING, (Object)dancing);
    }

    public int getDanceMoves() {
        return (Integer)this.field_70180_af.func_187225_a(DANCE_MOVES);
    }

    public void setDanceMoves(int moves) {
        this.field_70180_af.func_187227_b(DANCE_MOVES, (Object)moves);
    }

    public int getHeldRF() {
        return (Integer)this.field_70180_af.func_187225_a(HELD_RF);
    }

    public void setHeldRF(int rf) {
        this.field_70180_af.func_187227_b(HELD_RF, (Object)rf);
    }

    public int getRespawnCountdown() {
        return (Integer)this.field_70180_af.func_187225_a(RESPAWN_COUNTDOWN);
    }

    public void setRespawnCountdown(int respawn) {
        this.field_70180_af.func_187227_b(RESPAWN_COUNTDOWN, (Object)respawn);
    }

    @Nullable
    public UUID getMonsterOwnerID() {
        return ((Optional)this.field_70180_af.func_187225_a(MONSTER_OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setMonsterOwnerUniqueId(@Nullable UUID p_184754_1_) {
        this.field_70180_af.func_187227_b(MONSTER_OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public boolean isDyed() {
        return (Boolean)this.field_70180_af.func_187225_a(DYED);
    }

    public void setDyed(boolean dyed) {
        this.field_70180_af.func_187227_b(DYED, (Object)dyed);
    }

    public int getDyeColor() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR)).byteValue();
    }

    public void setDyeColor(int color) {
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)color));
    }

    public RatCommand getCommand() {
        return RatCommand.values()[MathHelper.func_76125_a((int)this.getCommandInteger(), (int)0, (int)(RatCommand.values().length - 1))];
    }

    public void setCommand(RatCommand command) {
        this.setCommandInteger(command.ordinal());
    }

    public boolean isFollowing() {
        return this.getCommandInteger() == 2;
    }

    public boolean isTargetCommand() {
        return this.getCommandInteger() == 4 || this.getCommandInteger() == 5;
    }

    public EntitySenses getSenses() {
        return this.func_70635_at();
    }

    public boolean isHoldingFood() {
        return !this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHEF) && (RatUtils.isRatFood(this.func_184586_b(Hand.MAIN_HAND)) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && ItemRatUpgradeOreDoubling.isProcessable(this.func_184614_ca()));
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.func_184187_bx() != null && this.getMountEntityType() != null && this.func_184187_bx().func_200600_R() == this.getMountEntityType() && this.func_184187_bx() instanceof EntityRatMountBase) {
            if (entityIn instanceof LivingEntity) {
                ((EntityRatMountBase)this.func_184187_bx()).func_70624_b((LivingEntity)entityIn);
            }
            return ((EntityRatMountBase)this.func_184187_bx()).func_70652_k(entityIn);
        }
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e()));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
            if (this.hasPlague() && entityIn instanceof LivingEntity && this.rollForPlague((LivingEntity)entityIn)) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 6000));
            }
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FERAL_BITE)) {
                entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 5.0f);
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 600));
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 600));
            }
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BEE)) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, 1200, 1));
            }
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT)) {
                Explosion.Mode explosion$mode = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
                Explosion explosion = new Explosion(this.field_70170_p, null, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 16.0f), this.func_226281_cx_(), 4.0f, false, explosion$mode);
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR)) {
                RatNukeExplosion explosion = new RatNukeExplosion(this.field_70170_p, (Entity)this, this.func_226277_ct_(), this.func_226278_cu_() + (double)(this.func_213302_cg() / 16.0f), this.func_226281_cx_(), 4.0f, false, this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b));
                explosion.func_77278_a();
                explosion.func_77279_a(true);
            }
        }
        return flag;
    }

    public int func_70658_aO() {
        if (this.func_70909_n()) {
            return super.func_70658_aO() * 3;
        }
        return super.func_70658_aO();
    }

    public void func_70636_d() {
        double d1;
        TileEntity te;
        float particleRand;
        double extraY;
        double extraZ;
        double extraX;
        double d12;
        boolean holdingInHands;
        float plateau;
        double planeDist;
        this.setRatStatus(RatStatus.IDLE);
        if (this.getRespawnCountdown() > 0) {
            this.setRespawnCountdown(this.getRespawnCountdown() - 1);
        }
        if (this.getUpgradeSlot() != this.prevUpgrade) {
            this.onUpgradeChanged();
        }
        super.func_70636_d();
        this.prevFlyingPitch = this.flyingPitch;
        if (this.inTube()) {
            if (this.navigatorType != 3) {
                this.switchNavigator(3);
            }
            if (this.climbingTube) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.1, this.func_213322_ci().field_72449_c);
            } else if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().func_186678_a((double)0.6).field_72448_b, this.func_213322_ci().field_72449_c);
            }
            double ydist = this.field_70167_r - this.func_226278_cu_();
            planeDist = (Math.abs(this.func_213322_ci().field_72450_a) + Math.abs(this.func_213322_ci().field_72449_c)) * 12.0;
            this.flyingPitch += (float)ydist * 100.0f;
            this.flyingPitch = MathHelper.func_76131_a((float)this.flyingPitch, (float)-90.0f, (float)90.0f);
            plateau = 2.0f;
            if (this.flyingPitch > plateau) {
                this.flyingPitch = (float)((double)this.flyingPitch - planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
            }
            if (this.flyingPitch < -plateau) {
                this.flyingPitch = (float)((double)this.flyingPitch + planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
            }
            if (this.flyingPitch > 2.0f) {
                this.flyingPitch -= this.field_70122_E ? Math.max(this.flyingPitch, 10.0f) : 1.0f;
            }
            if (this.flyingPitch < -2.0f) {
                this.flyingPitch += this.field_70122_E ? Math.max(this.flyingPitch, 10.0f) : 1.0f;
            }
            if (this.flyingPitch < 1.0f && this.flyingPitch > -1.0f && this.field_70122_E) {
                this.flyingPitch = 0.0f;
            }
        } else if (this.hasFlightUpgrade() && !this.func_70090_H()) {
            if (this.navigatorType != 2) {
                this.switchNavigator(2);
            }
            if (this.canMove()) {
                if (this.field_70765_h.func_179919_e() > this.func_226278_cu_() && !this.func_184218_aH()) {
                    this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.08, this.func_213322_ci().field_72449_c);
                }
            } else if (!this.field_70122_E) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.08, this.func_213322_ci().field_72449_c);
            }
            if (!this.field_70122_E) {
                double ydist = this.field_70167_r - this.func_226278_cu_();
                planeDist = (Math.abs(this.func_213322_ci().field_72450_a) + Math.abs(this.func_213322_ci().field_72449_c)) * 12.0;
                this.flyingPitch += (float)ydist * 20.0f;
                this.flyingPitch = MathHelper.func_76131_a((float)this.flyingPitch, (float)-90.0f, (float)90.0f);
                plateau = 2.0f;
                if (this.flyingPitch > plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch - planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch < -plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch + planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch > 2.0f) {
                    this.flyingPitch -= 1.0f;
                } else if (this.flyingPitch < -2.0f) {
                    this.flyingPitch += 1.0f;
                }
            } else {
                this.flyingPitch = 0.0f;
            }
        } else if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC) && this.func_70090_H()) {
            if (this.navigatorType != 4) {
                this.switchNavigator(4);
            }
            if (this.canMove()) {
                if (this.field_70765_h.func_179919_e() > this.func_226278_cu_()) {
                    this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b + 0.08, this.func_213322_ci().field_72449_c);
                }
            } else if (!this.field_70122_E) {
                this.func_213293_j(this.func_213322_ci().field_72450_a, this.func_213322_ci().field_72448_b - 0.08, this.func_213322_ci().field_72449_c);
            }
            if (!this.field_70122_E) {
                double ydist = this.field_70167_r - this.func_226278_cu_();
                planeDist = (Math.abs(this.func_213322_ci().field_72450_a) + Math.abs(this.func_213322_ci().field_72449_c)) * 12.0;
                this.flyingPitch += (float)ydist * 20.0f;
                this.flyingPitch = MathHelper.func_76131_a((float)this.flyingPitch, (float)-90.0f, (float)90.0f);
                plateau = 2.0f;
                if (this.flyingPitch > plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch - planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch < -plateau) {
                    this.flyingPitch = (float)((double)this.flyingPitch + planeDist * (double)Math.abs(this.flyingPitch) / 90.0);
                }
                if (this.flyingPitch > 2.0f) {
                    this.flyingPitch -= 1.0f;
                } else if (this.flyingPitch < -2.0f) {
                    this.flyingPitch += 1.0f;
                }
            } else {
                this.flyingPitch = 0.0f;
            }
        } else if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            if (!this.inTube()) {
                this.flyingPitch = 0.0f;
            }
            if (this.navigatorType != 5) {
                this.switchNavigator(5);
            }
            this.field_70145_X = true;
        } else {
            boolean wildNavigate;
            if (!this.inTube()) {
                this.flyingPitch = 0.0f;
            }
            boolean bl = wildNavigate = !this.func_70909_n() || this.isInCage();
            if (wildNavigate && this.navigatorType != 1) {
                this.switchNavigator(1);
            }
            if (!wildNavigate && this.navigatorType != 0) {
                this.switchNavigator(0);
            }
        }
        if (this.breedCooldown > 0) {
            --this.breedCooldown;
        }
        if (this.isMoving()) {
            this.setRatStatus(RatStatus.MOVING);
        }
        boolean sitting = this.func_70906_o() || this.func_184218_aH() || this.isDancing() || (this.getAnimation() == ANIMATION_IDLE_SCRATCH || this.getAnimation() == ANIMATION_IDLE_SNIFF) && this.shouldSitDuringAnimation();
        float sitInc = this.getAnimation() == ANIMATION_IDLE_SCRATCH || this.getAnimation() == ANIMATION_IDLE_SNIFF ? 5.0f : 1.0f;
        boolean bl = holdingInHands = !sitting && (!this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && (!this.holdInMouth || this.cookingProgress > 0) || this.getAnimation() == ANIMATION_EAT || this.holdsItemInHandUpgrade() || this.getMBTransferRate() > 0);
        if (sitting && this.sitProgress < 20.0f) {
            this.sitProgress += sitInc;
        } else if (!sitting && this.sitProgress > 0.0f) {
            this.sitProgress -= sitInc;
        }
        if (holdingInHands && this.holdProgress < 5.0f) {
            this.holdProgress += 0.5f;
        } else if (!holdingInHands && this.holdProgress > 0.0f) {
            this.holdProgress -= 0.5f;
        }
        boolean inTrap = this.isDeadInTrap;
        if (inTrap && this.deadInTrapProgress < 5.0f) {
            this.deadInTrapProgress += 1.0f;
        } else if (!inTrap && this.deadInTrapProgress > 0.0f) {
            this.deadInTrapProgress -= 1.0f;
        }
        if (this.digCooldown <= 0 && RatConfig.ratsDigBlocks && this.canDigHoles()) {
            this.findDigTarget();
            this.digTarget();
        }
        if (this.getCommand() == RatCommand.SIT && !this.func_70906_o()) {
            this.func_70904_g(true);
        }
        if (this.func_70906_o() && this.getCommand() != RatCommand.SIT) {
            this.func_70904_g(false);
        }
        if (this.getAnimation() == ANIMATION_EAT && this.isHoldingFood()) {
            ++this.eatingTicks;
            this.eatItem(this.func_184586_b(Hand.MAIN_HAND), 3);
            if (this.eatingTicks >= 40) {
                ItemStack pooStack = new ItemStack((IItemProvider)RatsItemRegistry.RAT_NUGGET);
                if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && ItemRatUpgradeOreDoubling.isProcessable(this.func_184586_b(Hand.MAIN_HAND))) {
                    pooStack = new ItemStack((IItemProvider)RatsItemRegistry.RAT_NUGGET_ORE, 2);
                    CompoundNBT poopTag = new CompoundNBT();
                    CompoundNBT oreTag = new CompoundNBT();
                    ItemRatUpgradeOreDoubling.getProcessedOre(this.func_184586_b(Hand.MAIN_HAND)).func_77955_b(oreTag);
                    poopTag.func_218657_a("OreItem", (INBT)oreTag);
                    pooStack.func_77982_d(poopTag);
                }
                this.func_184586_b(Hand.MAIN_HAND).func_190918_g(1);
                if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) || this.field_70146_Z.nextFloat() <= 0.1f) {
                    if (RatConfig.ratFartNoises) {
                        this.func_184185_a(RatsSoundRegistry.RAT_POOP, 0.5f + this.field_70146_Z.nextFloat() * 0.5f, 1.0f + this.field_70146_Z.nextFloat() * 0.5f);
                    }
                    if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && this.func_184586_b(Hand.MAIN_HAND).func_190926_b()) {
                        ItemStack oneStack = pooStack.func_77946_l();
                        oneStack.func_190920_e(1);
                        this.func_184611_a(Hand.MAIN_HAND, oneStack);
                        pooStack.func_190918_g(1);
                    }
                    if (pooStack.func_190916_E() > 0 && !this.field_70170_p.field_72995_K) {
                        this.func_70099_a(pooStack, 0.0f);
                    }
                }
                int healAmount = 1;
                if (this.func_184586_b(Hand.MAIN_HAND).func_77973_b().func_219971_r()) {
                    healAmount = this.func_184586_b(Hand.MAIN_HAND).func_77973_b().func_219967_s().func_221466_a();
                }
                this.func_70691_i(healAmount);
                this.eatingTicks = 0;
            }
        }
        if (!(this.field_70170_p.field_72995_K || !this.isHoldingFood() || this.func_70681_au().nextInt(20) != 0 && this.eatingTicks <= 0 || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHEF) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS) || this.getCommand() == RatCommand.GATHER || this.getCommand() == RatCommand.HARVEST || !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) && (this.getCommand() == RatCommand.TRANSPORT || !this.shouldDepositItem(this.func_184614_ca())) || this.getCommand() == RatCommand.HARVEST && this.getCommand() == RatCommand.HUNT_ANIMALS && this.getCommand() == RatCommand.HUNT_MONSTERS && !(this.func_110143_aJ() < this.func_110138_aP()))) {
            this.setAnimation(ANIMATION_EAT);
            this.setRatStatus(RatStatus.EATING);
        }
        if (this.hasPlague() && this.field_70146_Z.nextFloat() < 0.3f) {
            double d0 = 0.0;
            double d13 = this.field_70146_Z.nextGaussian() * 0.05 + 0.5;
            double d2 = 0.0;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197625_r, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d13, d2);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHEF) && !this.func_184614_ca().func_190926_b()) {
            this.tryCooking();
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d12 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 99) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                } else {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    if (this.field_70146_Z.nextFloat() < 0.125f) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    }
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARCHEOLOGIST) && !this.func_184614_ca().func_190926_b()) {
            this.tryArcheology();
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d12 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 99) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                } else {
                    this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, RatsBlockRegistry.GARBAGE_PILE.func_176223_P()), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    if (this.field_70146_Z.nextFloat() < 0.125f) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197623_p, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    }
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GEMCUTTER) && !this.func_184614_ca().func_190926_b()) {
            this.tryGemcutter();
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d12 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 99) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                } else {
                    this.field_70170_p.func_195594_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, Blocks.field_150482_ag.func_176223_P()), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                }
            }
        }
        if ((this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENCHANTER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DISENCHANTER)) && !this.func_184614_ca().func_190926_b()) {
            this.tryEnchanting(this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DISENCHANTER));
            if (this.cookingProgress > 0) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d12 = this.field_70146_Z.nextGaussian() * 0.02;
                if (this.cookingProgress == 999) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                } else {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197623_p, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197623_p, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS)) {
            this.tryGiftgiving();
            if (this.cookingProgress > 0 && this.cookingProgress == 71999) {
                this.field_70170_p.func_72960_a((Entity)this, (byte)126);
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT)) {
            if (this.coinCooldown <= 0) {
                this.coinCooldown = this.field_70146_Z.nextInt(6000) + 6000;
                if (!this.field_70170_p.field_72995_K) {
                    this.func_70099_a(new ItemStack((IItemProvider)RatsItemRegistry.TINY_COIN, 1 + this.field_70146_Z.nextInt(2)), 0.0f);
                }
                this.func_184185_a(SoundEvents.field_187665_Y, this.func_70599_aP(), this.func_70647_i());
            } else {
                --this.coinCooldown;
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER)) {
            if (!this.field_70170_p.field_72995_K) {
                if (this.func_70661_as().func_75505_d() != null && this.func_70661_as().func_75505_d().func_75870_c() != null && !this.func_184218_aH()) {
                    Vec3d target = new Vec3d((double)this.func_70661_as().func_75505_d().func_75870_c().field_75839_a, (double)this.func_70661_as().func_75505_d().func_75870_c().field_75837_b, (double)this.func_70661_as().func_75505_d().func_75870_c().field_75838_c);
                    if (this.func_70092_e(target.field_72450_a, target.field_72448_b, target.field_72449_c) > 20.0 || !this.isDirectPathBetweenPoints(target)) {
                        this.attemptTeleport(target.field_72450_a, target.field_72448_b, target.field_72449_c);
                    }
                }
            } else {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d12 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d12, d2);
            }
        }
        if (this.field_70170_p.field_72995_K && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FERAL_BITE) && this.func_70681_au().nextInt(5) == 0) {
            float sitAddition = 0.125f * (this.sitProgress / 20.0f);
            float radius = 0.3f - sitAddition;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            extraY = 0.125 + this.func_226278_cu_() + (double)sitAddition;
            particleRand = 0.1f;
            RatsMod.PROXY.addParticle("saliva", extraX + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, extraY, extraZ + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, 0.0, 0.0, 0.0);
        }
        if (this.field_70170_p.field_72995_K && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PSYCHIC) && this.func_70681_au().nextInt(5) == 0) {
            float sitAddition = 0.125f * (this.sitProgress / 20.0f);
            float radius = 0.45f - sitAddition;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            extraX = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
            extraZ = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
            extraY = 0.12 + this.func_226278_cu_() + (double)sitAddition;
            particleRand = 0.4f;
            RatsMod.PROXY.addParticle("rat_lightning", extraX + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, extraY, extraZ + (double)(this.field_70146_Z.nextFloat() * particleRand * 2.0f) - (double)particleRand, 0.0, 0.0, 0.0);
        }
        if (this.isInCage() && this.func_70638_az() != null) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.isRidingSpecialMount() && this.func_70638_az().func_184215_y((Entity)this)) {
            this.func_70624_b(null);
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_145782_y() == this.func_145782_y()) {
            this.func_70624_b(null);
        }
        if (this.func_70909_n() && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CRAFTING) && (te = this.field_70170_p.func_175625_s(new BlockPos((Entity)this).func_177977_b())) != null && te instanceof TileEntityRatCraftingTable && !this.field_70170_p.field_72995_K) {
            TileEntityRatCraftingTable ratCraftingTable = (TileEntityRatCraftingTable)te;
            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
            d1 = this.field_70146_Z.nextGaussian() * 0.02;
            if (ratCraftingTable.getField(0) > 0) {
                this.crafting = true;
                this.field_70170_p.func_72960_a((Entity)this, (byte)85);
                ItemStack stack = ratCraftingTable.func_70301_a(0);
                if (stack.func_190926_b()) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197601_L, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                } else {
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                }
                if (ratCraftingTable.prevCookTime % 20 == 0) {
                    this.func_184185_a(CRAFTING_SOUNDS[this.field_70146_Z.nextInt(CRAFTING_SOUNDS.length - 1)], 0.6f, 0.75f + this.field_70146_Z.nextFloat());
                }
            } else {
                this.crafting = false;
                this.field_70170_p.func_72960_a((Entity)this, (byte)86);
            }
            if (ratCraftingTable.prevCookTime == 199) {
                for (int i = 0; i < 4; ++i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                }
                this.func_184185_a(SoundEvents.field_187638_cR, 1.0f, 1.0f);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.getRatStatus() == RatStatus.IDLE && this.func_184586_b(Hand.MAIN_HAND).func_190926_b() && this.getAnimation() == NO_ANIMATION && this.func_70681_au().nextInt(350) == 0 && this.shouldNotIdleAnimation()) {
            this.setAnimation(this.func_70681_au().nextBoolean() ? ANIMATION_IDLE_SNIFF : ANIMATION_IDLE_SCRATCH);
        }
        if (!this.field_70170_p.field_72995_K && this.getMonsterOwnerID() != null && this.getMonsterOwner() instanceof ISummonsRats && this.getMonsterOwner() instanceof MobEntity) {
            MobEntity mob = (MobEntity)this.getMonsterOwner();
            ISummonsRats summonsRats = (ISummonsRats)this.getMonsterOwner();
            if (mob.func_70638_az() != null) {
                this.func_70624_b(mob.func_70638_az());
            }
            if (summonsRats.readsorbRats()) {
                if (this.func_70638_az() == null || !this.func_70638_az().func_70089_S()) {
                    this.func_70661_as().func_75497_a((Entity)mob, (double)1.225f);
                }
                if (this.func_70032_d((Entity)mob) < mob.func_213311_cf()) {
                    this.func_70106_y();
                    summonsRats.setRatsSummoned(summonsRats.getRatsSummoned() - 1);
                }
            } else if (summonsRats.encirclesSummoner() && (this.func_70638_az() == null || !this.func_70638_az().func_70089_S())) {
                float radius = summonsRats.getRadius();
                int maxRatStuff = 360 / Math.max(summonsRats.getRatsSummoned(), 1);
                int ratIndex = this.func_145782_y() % Math.max(summonsRats.getRatsSummoned(), 1);
                float angle = (float)Math.PI / 180 * ((float)(ratIndex * maxRatStuff) + (float)this.field_70173_aa * 4.1f);
                double extraX2 = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + mob.func_226277_ct_();
                double extraZ2 = (double)(radius * MathHelper.func_76134_b((float)angle)) + mob.func_226281_cx_();
                BlockPos runToPos = new BlockPos(extraX2, mob.func_226278_cu_(), extraZ2);
                for (int steps = 0; this.field_70170_p.func_180495_p(runToPos).func_200015_d((IBlockReader)this.field_70170_p, runToPos) && steps < 10; ++steps) {
                    runToPos = runToPos.func_177984_a();
                }
                this.func_70661_as().func_75492_a(extraX2, (double)runToPos.func_177956_o(), extraZ2, (double)1.225f);
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER) && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            this.func_70691_i(1.0f);
        }
        if ((this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_VOODOO) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PSYCHIC)) && this.func_110143_aJ() < this.func_110138_aP() && this.field_70173_aa % 30 == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PSYCHIC) && this.rangedAttackCooldownPsychic == 0 && this.func_70638_az() != null) {
            if (this.field_70146_Z.nextBoolean()) {
                this.rangedAttackCooldownPsychic = 50;
                BlockPos ourPos = new BlockPos((Entity)this);
                int searchRange = 10;
                ArrayList<BlockPos> listOfAll = new ArrayList<BlockPos>();
                for (BlockPos pos : BlockPos.func_218281_b((BlockPos)ourPos.func_177982_a(-searchRange, -searchRange, -searchRange), (BlockPos)ourPos.func_177982_a(searchRange, searchRange, searchRange)).map(BlockPos::func_185334_h).collect(Collectors.toList())) {
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    if (this.field_70170_p.func_175623_d(pos) || !WitherEntity.func_181033_a((BlockState)state)) continue;
                    listOfAll.add(pos);
                }
                if (listOfAll.size() > 0) {
                    BlockPos pos = (BlockPos)listOfAll.get(this.field_70146_Z.nextInt(listOfAll.size()));
                    EntityThrownBlock thrownBlock = new EntityThrownBlock(RatsEntityRegistry.THROWN_BLOCK, this.field_70170_p, this.field_70170_p.func_180495_p(pos), (LivingEntity)this);
                    thrownBlock.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 2.5, (double)pos.func_177952_p() + 0.5);
                    thrownBlock.dropBlock = false;
                    if (!this.field_70170_p.field_72995_K) {
                        this.field_70170_p.func_217376_c((Entity)thrownBlock);
                    }
                    RatsMod.sendMSGToAll(new MessageSyncThrownBlock(thrownBlock.func_145782_y(), pos.func_218275_a()));
                } else {
                    this.rangedAttackCooldownPsychic = 5;
                }
            } else {
                this.rangedAttackCooldownPsychic = 100;
                int bounds = 5;
                for (int i = 0; i < this.field_70146_Z.nextInt(2) + 1; ++i) {
                    EntityLaserPortal laserPortal = new EntityLaserPortal(RatsEntityRegistry.LASER_PORTAL, this.field_70170_p, this.func_70638_az().func_226277_ct_() + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, this.func_226278_cu_() + 2.0, this.func_70638_az().func_226281_cx_() + (double)this.field_70146_Z.nextInt(bounds * 2) - (double)bounds, (LivingEntity)this);
                    this.field_70170_p.func_217376_c((Entity)laserPortal);
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BUCCANEER)) {
            if (this.getVisualFlag() && this.visualCooldown == 0) {
                this.setVisualFlag(false);
            }
            if (this.rangedAttackCooldownCannon == 0 && this.func_70638_az() != null) {
                this.rangedAttackCooldownCannon = 60;
                EntityCheeseCannonball cannonball = new EntityCheeseCannonball(RatsEntityRegistry.CHEESE_CANNONBALL, this.field_70170_p, (LivingEntity)this);
                double extraY2 = 0.6 + this.func_226278_cu_();
                double d0 = this.func_70638_az().func_226278_cu_() + (double)this.func_70638_az().func_70047_e() - (double)1.1f;
                double d14 = this.func_70638_az().func_226277_ct_() - this.func_226277_ct_();
                double d3 = this.func_70638_az().func_226281_cx_() - this.func_226281_cx_();
                double d2 = d0 - extraY2;
                float f = MathHelper.func_76133_a((double)(d14 * d14 + d3 * d3)) * 0.2f;
                cannonball.func_70107_b(this.func_226277_ct_(), extraY2, this.func_226281_cx_());
                cannonball.func_70186_c(d14, d2 + (double)f, d3, 0.75f, 0.4f);
                this.setVisualFlag(true);
                this.visualCooldown = 4;
                this.func_184185_a(SoundEvents.field_187539_bB, 3.0f, 2.3f / (this.func_70681_au().nextFloat() * 0.4f + 0.8f));
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)cannonball);
                }
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            if (this.getVisualFlag() && this.visualCooldown == 0) {
                this.setVisualFlag(false);
            }
            if (this.rangedAttackCooldownDragon == 0 && this.func_70638_az() != null) {
                this.rangedAttackCooldownDragon = 5;
                float radius = 0.3f;
                float angle = (float)Math.PI / 180 * this.field_70761_aq;
                double extraX3 = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
                double extraZ3 = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
                double extraY3 = 0.2 + this.func_226278_cu_();
                double targetRelativeX = this.func_70638_az().func_226277_ct_() - extraX3;
                double targetRelativeY = this.func_70638_az().func_226278_cu_() + (double)(this.func_70638_az().func_213302_cg() / 2.0f) - extraY3;
                double targetRelativeZ = this.func_70638_az().func_226281_cx_() - extraZ3;
                this.func_184185_a(SoundEvents.field_187616_bj, 1.0f, 1.25f + this.field_70146_Z.nextFloat() * 0.5f);
                EntityRatDragonFire beam = new EntityRatDragonFire(RatsEntityRegistry.RAT_DRAGON_FIRE, (LivingEntity)this, this.field_70170_p, targetRelativeX, targetRelativeY, targetRelativeZ);
                beam.func_70107_b(extraX3, extraY3, extraZ3);
                if (!this.field_70170_p.field_72995_K) {
                    this.field_70170_p.func_217376_c((Entity)beam);
                }
            }
            this.func_70066_B();
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR) && this.rangedAttackCooldownLaser == 0 && this.func_70638_az() != null) {
            this.rangedAttackCooldownLaser = 10;
            float radius = 0.3f;
            for (int i = 0; i < 2; ++i) {
                float angle = (float)Math.PI / 180 * (this.field_70761_aq + (float)(i == 0 ? 90 : -90));
                double extraX4 = (double)(radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)))) + this.func_226277_ct_();
                double extraZ4 = (double)(radius * MathHelper.func_76134_b((float)angle)) + this.func_226281_cx_();
                extraY = 0.2 + this.func_226278_cu_();
                double targetRelativeX = this.func_70638_az().func_226277_ct_() - extraX4;
                double targetRelativeY = this.func_70638_az().func_226278_cu_() + (double)(this.func_70638_az().func_213302_cg() / 2.0f) - extraY;
                double targetRelativeZ = this.func_70638_az().func_226281_cx_() - extraZ4;
                this.func_184185_a(RatsSoundRegistry.LASER, 1.0f, 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
                EntityLaserBeam beam = new EntityLaserBeam(RatsEntityRegistry.LASER_BEAM, this.field_70170_p, (LivingEntity)this);
                beam.setRGB(1.0f, 0.0f, 0.0f);
                beam.func_70239_b(2.0);
                beam.func_70107_b(extraX4, extraY, extraZ4);
                beam.func_70186_c(targetRelativeX, targetRelativeY, targetRelativeZ, 2.0f, 0.4f);
                if (this.field_70170_p.field_72995_K) continue;
                this.field_70170_p.func_217376_c((Entity)beam);
            }
        }
        if (this.rangedAttackCooldownCannon > 0) {
            --this.rangedAttackCooldownCannon;
        }
        if (this.rangedAttackCooldownLaser > 0) {
            --this.rangedAttackCooldownLaser;
        }
        if (this.rangedAttackCooldownPsychic > 0) {
            --this.rangedAttackCooldownPsychic;
        }
        if (this.rangedAttackCooldownDragon > 0) {
            --this.rangedAttackCooldownDragon;
        }
        if (this.visualCooldown > 0) {
            --this.visualCooldown;
        }
        this.prevUpgrade = this.getUpgradeSlot();
        if (!this.field_70170_p.field_72995_K) {
            this.inCage = this.inCageLogic();
        }
        if (this.func_70909_n()) {
            this.inTube = this.inTubeLogic();
        }
        if (this.poopCooldown > 0) {
            --this.poopCooldown;
        }
        if (this.getHeldRF() > 0 && this.field_70146_Z.nextFloat() < 0.1f && this.getRFTransferRate() > 0) {
            this.func_184185_a(RatsSoundRegistry.NEORATLANTEAN_IDLE, this.func_70599_aP(), 0.75f + this.field_70146_Z.nextFloat() * 0.5f);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.isDancing() && this.getAnimation() != this.getDanceAnimation()) {
            this.setAnimation(this.getDanceAnimation());
        }
        if (this.isDancing() && (this.jukeboxPos == null || this.jukeboxPos.func_218140_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), true) > 225.0 || this.field_70170_p.func_180495_p(this.jukeboxPos).func_177230_c() != Blocks.field_150421_aI)) {
            this.setDancing(false);
        }
        if (this.field_70145_X && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            this.field_70145_X = false;
        }
        if (this.getMountEntityType() != null && !this.func_184218_aH() && this.mountRespawnCooldown == 0) {
            Entity entity = this.getMountEntityType().func_200721_a(this.field_70170_p);
            entity.func_82149_j((Entity)this);
            if (!this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_217376_c(entity);
            }
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197598_I, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
            if (entity instanceof MobEntity) {
                ((MobEntity)entity).func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(new BlockPos((Entity)this)), SpawnReason.MOB_SUMMONED, null, null);
            }
            this.func_184205_a(entity, true);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BEE) && this.randomEffectCooldown == 0) {
            this.randomEffectCooldown = 500 + this.field_70146_Z.nextInt(500);
            if (this.field_70146_Z.nextInt(3) == 0) {
                RatUtils.polinateAround(this.field_70170_p, this.func_180425_c());
            }
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TICK_ACCELERATOR)) {
            RatUtils.accelerateTick(this.field_70170_p, this.func_180425_c().func_177984_a());
            RatUtils.accelerateTick(this.field_70170_p, this.func_180425_c());
            RatUtils.accelerateTick(this.field_70170_p, this.func_180425_c().func_177977_b());
        }
        if (this.mountRespawnCooldown > 0) {
            --this.mountRespawnCooldown;
        }
        if (this.randomEffectCooldown > 0) {
            --this.randomEffectCooldown;
        }
    }

    public boolean canDigHoles() {
        return !this.func_70909_n();
    }

    private boolean inCageLogic() {
        return this.field_70170_p.func_180495_p(this.func_180425_c()).func_177230_c() instanceof BlockRatCage;
    }

    private boolean shouldSitDuringAnimation() {
        return !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS);
    }

    public void createBabiesFrom(EntityRat mother, EntityRat father) {
        for (int i = 0; i < 1; ++i) {
            EntityRat baby = new EntityRat(RatsEntityRegistry.RAT, this.field_70170_p);
            baby.setMale(this.field_70146_Z.nextBoolean());
            int babyColor = 0;
            babyColor = father.getColorVariant() <= 3 && mother.getColorVariant() <= 3 ? (this.field_70146_Z.nextInt(6) == 0 ? 4 + this.field_70146_Z.nextInt(RAT_TEXTURES.length - 5) : this.field_70146_Z.nextInt(4)) : this.field_70146_Z.nextInt(RAT_TEXTURES.length);
            baby.setColorVariant(babyColor);
            baby.func_70107_b(mother.func_226277_ct_(), mother.func_226278_cu_(), mother.func_226281_cx_());
            baby.func_70873_a(-24000);
            if (mother.func_70909_n()) {
                baby.func_70903_f(true);
                baby.func_184754_b(mother.func_184753_b());
            } else if (father.func_70909_n()) {
                baby.func_70903_f(true);
                baby.func_184754_b(father.func_184753_b());
            }
            this.field_70170_p.func_217376_c((Entity)baby);
        }
    }

    public boolean func_70067_L() {
        return !this.func_184218_aH() || !(this.func_184187_bx() instanceof PlayerEntity);
    }

    public ItemStack getCookingResultFor(ItemStack stack) {
        Inventory iinventory = new Inventory(new ItemStack[]{stack});
        FurnaceRecipe irecipe = this.field_70170_p.func_199532_z().func_215371_a(IRecipeType.field_222150_b, (IInventory)iinventory, this.field_70170_p).orElse(null);
        SharedRecipe recipe = RatsRecipeRegistry.getRatChefRecipe(stack);
        if (recipe != null) {
            return recipe.getOutput().func_77946_l();
        }
        if (irecipe != null && !irecipe.func_77571_b().func_190926_b()) {
            ItemStack burntItem = irecipe.func_77571_b().func_77946_l();
            return burntItem;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getArcheologyResultFor(ItemStack stack) {
        SharedRecipe recipe = RatsRecipeRegistry.getArcheologistRecipe(stack);
        if (recipe != null) {
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack getGemcutterResultFor(ItemStack stack) {
        SharedRecipe recipe = RatsRecipeRegistry.getGemcutterRecipe(stack);
        if (recipe != null) {
            return recipe.getOutput().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private void tryArcheology() {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = this.getArcheologyResultFor(heldItem);
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 100) {
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(Hand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private void tryCooking() {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = this.getCookingResultFor(heldItem);
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 100) {
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(Hand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private void tryGemcutter() {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = this.getGemcutterResultFor(heldItem);
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 100) {
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(Hand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private void tryEnchanting(boolean disenchant) {
        ItemStack heldItem = this.func_184614_ca();
        ItemStack burntItem = ItemStack.field_190927_a;
        if (heldItem.func_77973_b() == Items.field_151122_aG && !disenchant) {
            burntItem = heldItem.func_77946_l();
        }
        if (heldItem.func_77973_b() == Items.field_151134_bR && disenchant) {
            burntItem = new ItemStack((IItemProvider)Items.field_151122_aG, heldItem.func_190916_E());
        }
        if (heldItem.func_77956_u() && !disenchant && !heldItem.func_77948_v()) {
            burntItem = heldItem.func_77946_l();
        }
        if (disenchant && heldItem.func_77948_v()) {
            burntItem = heldItem.func_77946_l();
            burntItem.func_77986_q().clear();
        }
        if (burntItem.func_190926_b()) {
            this.cookingProgress = 0;
        } else {
            ++this.cookingProgress;
            if (this.cookingProgress == 1000) {
                heldItem.func_190918_g(1);
                if (!disenchant) {
                    float power = 0.0f;
                    BlockPos position = this.func_180425_c();
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            if (j == 0 && k == 0 || !this.field_70170_p.func_175623_d(position.func_177982_a(k, 0, j)) || !this.field_70170_p.func_175623_d(position.func_177982_a(k, 1, j))) continue;
                            power += this.getPower(this.field_70170_p, position.func_177982_a(k * 2, 0, j * 2));
                            power += this.getPower(this.field_70170_p, position.func_177982_a(k * 2, 1, j * 2));
                            if (k == 0 || j == 0) continue;
                            power += this.getPower(this.field_70170_p, position.func_177982_a(k * 2, 0, j));
                            power += this.getPower(this.field_70170_p, position.func_177982_a(k * 2, 1, j));
                            power += this.getPower(this.field_70170_p, position.func_177982_a(k, 0, j * 2));
                            power += this.getPower(this.field_70170_p, position.func_177982_a(k, 1, j * 2));
                        }
                    }
                    burntItem = EnchantmentHelper.func_77504_a((Random)this.func_70681_au(), (ItemStack)burntItem, (int)((int)(2.0f + (float)this.func_70681_au().nextInt(2) + power)), (boolean)false);
                }
                if (heldItem.func_190926_b()) {
                    this.func_184611_a(Hand.MAIN_HAND, burntItem);
                } else if (!this.tryDepositItemInContainers(burntItem) && !this.field_70170_p.field_72995_K) {
                    this.func_70099_a(burntItem, 0.25f);
                }
                this.cookingProgress = 0;
            }
        }
    }

    private float getPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }

    private void tryGiftgiving() {
        ItemStack heldItem = this.func_184614_ca();
        boolean held = false;
        boolean luck = true;
        if (!this.field_70170_p.field_72995_K) {
            LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.field_70170_p);
            lootcontext$builder.func_186469_a((float)luck);
            LootParameterSet.Builder lootparameterset$builder = new LootParameterSet.Builder();
            List result = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(CHRISTMAS_LOOT).func_216113_a(lootcontext$builder.func_216022_a(lootparameterset$builder.func_216270_a()));
            if (result.isEmpty()) {
                this.cookingProgress = 0;
            } else {
                ++this.cookingProgress;
                if (this.cookingProgress == 72000) {
                    for (ItemStack stack : result) {
                        if (heldItem.func_190926_b() && !held) {
                            this.func_184611_a(Hand.MAIN_HAND, stack.func_77946_l());
                            held = true;
                            continue;
                        }
                        if (this.tryDepositItemInContainers(stack.func_77946_l()) || this.field_70170_p.field_72995_K) continue;
                        this.func_70099_a(stack.func_77946_l(), 0.25f);
                    }
                    this.cookingProgress = 0;
                }
            }
        }
    }

    private boolean tryDepositItemInContainers(ItemStack burntItem) {
        TileEntity te;
        LazyOptional handler;
        if (this.field_70170_p.func_175625_s(new BlockPos((Entity)this)) != null && (handler = (te = this.field_70170_p.func_175625_s(new BlockPos((Entity)this))).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP)).orElse(null) != null && ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)burntItem, (boolean)true).func_190926_b()) {
            ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)handler.orElse(null)), (ItemStack)burntItem, (boolean)false);
            return true;
        }
        return false;
    }

    protected void eatItem(ItemStack stack, int eatingParticleCount) {
        if (!stack.func_190926_b()) {
            if (stack.func_77975_n() == UseAction.DRINK) {
                this.func_184185_a(SoundEvents.field_187664_bz, 0.5f, this.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (RatUtils.isRatFood(stack) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING)) {
                for (int i = 0; i < eatingParticleCount; ++i) {
                    Vec3d vec3d = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                    vec3d = vec3d.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                    vec3d = vec3d.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    double d0 = (double)(-this.field_70146_Z.nextFloat()) * 0.6 - 0.3;
                    Vec3d vec3d1 = new Vec3d(((double)this.field_70146_Z.nextFloat() - 0.5) * 0.3, d0, 0.1);
                    vec3d1 = vec3d1.func_178789_a(-this.field_70125_A * ((float)Math.PI / 180));
                    vec3d1 = vec3d1.func_178785_b(-this.field_70177_z * ((float)Math.PI / 180));
                    vec3d1 = vec3d1.func_72441_c(this.func_226277_ct_(), this.func_226278_cu_() + 0.25, this.func_226281_cx_());
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c);
                }
                this.func_184185_a(SoundEvents.field_187537_bA, 0.25f + 0.25f * (float)this.field_70146_Z.nextInt(2), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.3f);
            }
        }
    }

    private void digTarget() {
        if (this.diggingPos != null) {
            ++this.breakingTime;
            int i = (int)((float)this.breakingTime / 160.0f * 10.0f);
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            this.func_213293_j(0.0, 0.0, 0.0);
            if (this.breakingTime % 40 == 0) {
                this.func_184185_a(RatsSoundRegistry.RAT_DIG, this.func_70599_aP(), this.func_70647_i());
            }
            if (i != this.previousBreakProgress) {
                this.field_70170_p.func_175715_c(this.func_145782_y(), this.diggingPos, i);
                this.previousBreakProgress = i;
            }
            if (this.breakingTime == 160) {
                TileEntity tileentity1;
                this.breakingTime = 0;
                this.previousBreakProgress = -1;
                BlockState prevState = this.field_70170_p.func_180495_p(this.diggingPos);
                double d1 = (this.finalDigPathPoint == null ? this.func_226277_ct_() : (double)this.finalDigPathPoint.func_177958_n()) - (double)this.diggingPos.func_177958_n();
                double d2 = (this.finalDigPathPoint == null ? this.func_226281_cx_() : (double)this.finalDigPathPoint.func_177952_p()) - (double)this.diggingPos.func_177952_p();
                float rotation = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                Direction facing = Direction.func_176731_b((int)(MathHelper.func_76128_c((double)((double)(rotation * 4.0f / 360.0f) + 0.5)) & 3));
                this.field_70170_p.func_175656_a(this.diggingPos, RatsBlockRegistry.RAT_HOLE.func_176223_P());
                if (this.field_70170_p.func_180495_p(this.diggingPos).func_177230_c() instanceof BlockRatHole && (tileentity1 = this.field_70170_p.func_175625_s(this.diggingPos)) instanceof TileEntityRatHole) {
                    ((TileEntityRatHole)tileentity1).setImmitatedBlockState(prevState);
                }
                this.digCooldown = 3000;
                this.diggingPos = null;
            }
            if (this.diggingPos != null && this.func_70092_e(this.diggingPos.func_177958_n(), this.diggingPos.func_177956_o(), this.diggingPos.func_177952_p()) > 2.0) {
                this.breakingTime = 0;
                this.previousBreakProgress = -1;
                this.field_70170_p.func_175715_c(this.func_145782_y(), this.diggingPos, 0);
                this.diggingPos = null;
            }
        } else {
            this.breakingTime = 0;
            this.previousBreakProgress = -1;
        }
    }

    protected void func_82167_n(Entity entityIn) {
        if (!(this.isInRatHole() || this.crafting || this.inTube())) {
            entityIn.func_70108_f((Entity)this);
        }
        if (this.hasPlague()) {
            if (entityIn instanceof EntityRat && !((EntityRat)entityIn).func_70909_n()) {
                ((EntityRat)entityIn).setPlague(true);
            } else if (entityIn instanceof LivingEntity && this.rollForPlague((LivingEntity)entityIn) && ((LivingEntity)entityIn).func_70660_b(RatsMod.PLAGUE_POTION) != null) {
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(RatsMod.PLAGUE_POTION, 6000));
            }
        }
    }

    private boolean rollForPlague(LivingEntity target) {
        boolean mask;
        boolean bl = mask = target.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == RatsItemRegistry.PLAGUE_DOCTOR_MASK || target.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == RatsItemRegistry.BLACK_DEATH_MASK;
        if (mask) {
            return this.field_70146_Z.nextFloat() < 0.3f;
        }
        return true;
    }

    public boolean isInRatHole() {
        return RatUtils.isRatHoleInBoundingBox(this.func_174813_aQ().func_72314_b(0.5, 0.5, 0.5), this.field_70170_p);
    }

    private void findDigTarget() {
        if (this.func_70661_as() instanceof RatPathPathNavigateGround) {
            BlockPos digPos;
            BlockPos target;
            if (((RatPathPathNavigateGround)this.func_70661_as()).targetPosition != null && this.field_70170_p.func_175625_s(target = ((RatPathPathNavigateGround)this.func_70661_as()).targetPosition.func_177977_b()) != null) {
                this.finalDigPathPoint = target;
            }
            if (!this.field_70123_F || !this.func_70661_as().func_75500_f()) {
                return;
            }
            if (this.finalDigPathPoint != null && (digPos = this.rayTraceBlockPos(this.finalDigPathPoint)) != null && this.func_70092_e(digPos.func_177958_n(), digPos.func_177956_o(), digPos.func_177952_p()) < 2.0 && this.field_70170_p.func_175625_s(digPos) == null) {
                Material material = this.field_70170_p.func_180495_p(digPos).func_185904_a();
                if (RatUtils.canRatBreakBlock(this.field_70170_p, digPos, this) && this.canDigBlock(this.field_70170_p, digPos) && (material.func_76229_l() || material == Material.field_151596_z) && digPos.func_177956_o() == (int)Math.round(this.func_226278_cu_())) {
                    this.diggingPos = digPos;
                }
            }
        }
    }

    private boolean canDigBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_200015_d((IBlockReader)world, pos);
    }

    public BlockPos rayTraceBlockPos(BlockPos targetPos) {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.field_70170_p, this.func_174791_d(), new Vec3d((double)targetPos.func_177958_n() + 0.5, (double)targetPos.func_177956_o() + 0.5, (double)targetPos.func_177952_p() + 0.5), false, (Entity)this);
        if (rayTrace instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            BlockPos sidePos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
            if (!this.field_70170_p.func_175623_d(sidePos)) {
                return sidePos;
            }
            if (!this.field_70170_p.func_175623_d(pos)) {
                return pos;
            }
            return null;
        }
        return null;
    }

    public void updateAIgoalSelector() {
        if (this.field_70765_h.func_75640_a()) {
            double d0 = this.field_70765_h.func_75638_b();
            if (d0 == 0.6) {
                this.func_226284_e_(true);
                this.func_70031_b(false);
            } else if (d0 >= 1.1 && d0 < 2.0) {
                this.func_226284_e_(false);
                this.func_70031_b(true);
            } else {
                this.func_226284_e_(false);
                this.func_70031_b(false);
            }
        } else {
            this.func_226284_e_(false);
            this.func_70031_b(false);
        }
    }

    protected void func_174808_Z() {
    }

    public void func_213352_e(Vec3d vec3d) {
        if (!this.canMove()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vec3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public void openGUI(PlayerEntity playerEntity) {
        if (!(this.field_70170_p.field_72995_K || this.func_184207_aI() && !this.func_184196_w((Entity)playerEntity))) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)playerEntity), (INamedContainerProvider)new INamedContainerProvider(){

                public Container createMenu(int p_createMenu_1_, PlayerInventory p_createMenu_2_, PlayerEntity p_createMenu_3_) {
                    return new ContainerRat(p_createMenu_1_, (IInventory)EntityRat.this.ratInventory, p_createMenu_2_, EntityRat.this);
                }

                public ITextComponent func_145748_c_() {
                    return new TranslationTextComponent("entity.rats.rat", new Object[0]);
                }
            });
        }
        RatsMod.PROXY.setRefrencedRat(this);
    }

    public boolean canMove() {
        return this.diggingPos == null && !this.func_70906_o() && this.getCommand().freeMove && !this.func_70631_g_();
    }

    public boolean isInCage() {
        return this.inCage;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_EAT, ANIMATION_IDLE_SCRATCH, ANIMATION_IDLE_SNIFF, ANIMATION_DANCE_0, ANIMATION_DANCE_1};
    }

    public Animation getDanceAnimation() {
        switch (this.getDanceMoves()) {
            case 0: {
                return ANIMATION_DANCE_0;
            }
        }
        return NO_ANIMATION;
    }

    public boolean canPhaseThroughBlock(IWorld world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof FenceBlock || world.func_180495_p(pos).func_177230_c() instanceof FenceBlock;
    }

    public void setKilledInTrap() {
        this.isDeadInTrap = true;
        this.func_70097_a(DamageSource.field_76368_d, Float.MAX_VALUE);
    }

    protected boolean func_146066_aG() {
        return super.func_146066_aG() && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ANGEL);
    }

    protected void func_70609_aI() {
        int maxDeathTime;
        ++this.field_70725_aQ;
        int n = maxDeathTime = this.isDeadInTrap ? 60 : 20;
        if (this.field_70725_aQ == maxDeathTime) {
            if (!this.field_70170_p.field_72995_K && (this.func_70684_aJ() || this.field_70718_bc > 0 && this.func_146066_aG() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223602_e))) {
                int j;
                int i = this.func_70693_a(this.field_70717_bb);
                for (i = ForgeEventFactory.getExperienceDrop((LivingEntity)this, (PlayerEntity)this.field_70717_bb, (int)i); i > 0; i -= j) {
                    j = ExperienceOrbEntity.func_70527_a((int)i);
                    this.field_70170_p.func_217376_c((Entity)new ExperienceOrbEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), j));
                }
                if (this.hasToga()) {
                    this.func_70099_a(new ItemStack((IItemProvider)RatsItemRegistry.RAT_TOGA), 0.0f);
                    if (this.field_71093_bK == DimensionType.func_186069_a((int)RatConfig.ratlantisDimensionId)) {
                        boolean flag = false;
                        if (!flag && this.field_70146_Z.nextFloat() < 0.01f) {
                            this.func_70099_a(new ItemStack((IItemProvider)Items.field_151045_i), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.6f) {
                            this.func_70099_a(new ItemStack((IItemProvider)RatsItemRegistry.CHEESE, 1 + this.field_70146_Z.nextInt(3)), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.3f) {
                            this.func_70099_a(new ItemStack((IItemProvider)Items.field_151043_k), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.3f) {
                            this.func_70099_a(new ItemStack((IItemProvider)Items.field_179563_cD), 0.0f);
                            flag = true;
                        }
                        if (!flag && this.field_70146_Z.nextFloat() < 0.3f) {
                            this.func_70099_a(new ItemStack((IItemProvider)Items.field_151122_aG), 0.0f);
                            flag = true;
                        }
                    }
                }
            }
            this.spawnAngelCopy();
            this.func_70106_y();
            for (int k = 0; k < 20; ++k) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d2, d0, d1);
            }
        }
    }

    public void func_70106_y() {
        if (!this.func_70089_S() && this.func_70909_n() && this.getMonsterOwner() != null && this.getMonsterOwner() instanceof ISummonsRats) {
            ISummonsRats illagerPiper = (ISummonsRats)this.getMonsterOwner();
            illagerPiper.setRatsSummoned(illagerPiper.getRatsSummoned() - 1);
            this.func_184754_b(null);
            this.setTamedByMonster(false);
        }
        super.func_70106_y();
    }

    public void spawnAngelCopy() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ANGEL)) {
            EntityRat copy = new EntityRat(RatsEntityRegistry.RAT, this.field_70170_p);
            CompoundNBT nbt = new CompoundNBT();
            this.func_213281_b(nbt);
            nbt.func_74757_a("NoAI", false);
            nbt.func_74777_a("HurtTime", (short)0);
            nbt.func_74768_a("HurtByTimestamp", 0);
            nbt.func_74777_a("DeathTime", (short)0);
            copy.func_70037_a(nbt);
            copy.func_70606_j(copy.func_110138_aP());
            copy.func_82149_j((Entity)this);
            copy.setRespawnCountdown(1200);
            this.field_70170_p.func_217376_c((Entity)copy);
        }
    }

    public void func_70098_U() {
        Entity entity = this.func_184187_bx();
        if (entity != null && (!entity.func_70089_S() || entity instanceof LivingEntity && ((LivingEntity)entity).func_110143_aJ() <= 0.0f)) {
            this.func_184210_p();
        } else {
            this.func_213293_j(0.0, 0.0, 0.0);
            this.func_70071_h_();
            if (this.func_184218_aH()) {
                if (this.func_184187_bx() instanceof EntityRatMountBase || this.func_184187_bx() instanceof EntityRattlingGun) {
                    this.field_70177_z = this.field_70761_aq;
                    super.func_70098_U();
                } else {
                    this.updateRiding(entity);
                }
            }
        }
    }

    public boolean func_184198_c(CompoundNBT compound) {
        String s = this.func_70022_Q();
        compound.func_74778_a("id", s);
        this.func_189511_e(compound);
        return true;
    }

    public void func_184226_ay() {
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.func_184196_w((Entity)this) && riding instanceof PlayerEntity) {
            int i = riding.func_184188_bt().indexOf(this);
            float radius = (i == 0 ? 0.0f : 0.4f) + (float)(((PlayerEntity)riding).func_184613_cA() ? 2 : 0);
            float angle = (float)Math.PI / 180 * ((PlayerEntity)riding).field_70761_aq + (i == 2 ? -92.5f : (i == 1 ? 92.5f : 0.0f));
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            double extraY = riding.func_225608_bj_() ? 1.1 : 1.4;
            this.field_70177_z = ((PlayerEntity)riding).field_70759_as;
            this.field_70759_as = ((PlayerEntity)riding).field_70759_as;
            this.field_70126_B = ((PlayerEntity)riding).field_70759_as;
            this.func_70107_b(riding.func_226277_ct_() + extraX, riding.func_226278_cu_() + extraY, riding.func_226281_cx_() + extraZ);
            if (((PlayerEntity)riding).func_184613_cA()) {
                this.func_184210_p();
            }
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.getRespawnCountdown() > 0) {
            return false;
        }
        if (itemstack.func_77973_b() == RatsItemRegistry.FILTH_CORRUPTION) {
            this.func_184185_a(SoundEvents.field_187945_hs, 1.0f, 1.5f);
            this.func_70106_y();
            EntityRatKing ratKing = new EntityRatKing(RatsEntityRegistry.RAT_KING, this.field_70170_p);
            ratKing.func_82149_j((Entity)this);
            ratKing.func_213386_a((IWorld)this.field_70170_p, this.field_70170_p.func_175649_E(this.func_180425_c()), SpawnReason.CONVERSION, null, null);
            this.field_70170_p.func_217376_c((Entity)ratKing);
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            return true;
        }
        if (itemstack.func_77973_b() == RatsItemRegistry.RAT_TOGA) {
            if (!this.hasToga()) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70099_a(new ItemStack((IItemProvider)RatsItemRegistry.RAT_TOGA), 0.0f);
            }
            this.setToga(!this.hasToga());
            this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.5f);
        }
        if (itemstack.func_77973_b() == RatsItemRegistry.CREATIVE_CHEESE && this.canBeTamed()) {
            this.func_70903_f(true);
            this.field_70170_p.func_72960_a((Entity)this, (byte)83);
            this.func_193101_c(player);
            return true;
        }
        if (itemstack.func_111282_a(player, (LivingEntity)this, hand)) {
            return true;
        }
        if (!super.func_184645_a(player, hand)) {
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CARRAT) && player.func_71024_bL().func_75121_c()) {
                player.func_71024_bL().func_75122_a(1, 0.1f);
                player.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
                for (int i = 0; i < 8; ++i) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Items.field_151172_bF)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 2.0f) - (double)this.func_213302_cg(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                }
                return true;
            }
            if (this.func_70909_n() && !this.func_70631_g_() && (this.func_152114_e((LivingEntity)player) || player.func_184812_l_())) {
                if (itemstack.func_77973_b() == Item.func_150898_a((Block)RatsBlockRegistry.DYE_SPONGE)) {
                    this.setDyed(false);
                    this.setDyeColor(0);
                    for (int i = 0; i < 8; ++i) {
                        double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                        double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                        this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)Item.func_150898_a((Block)RatsBlockRegistry.DYE_SPONGE))), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 2.0f) - (double)this.func_213302_cg(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                    }
                    this.func_184185_a(SoundEvents.field_187630_M, this.func_70599_aP(), this.func_70647_i());
                    return true;
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.RATBOW_ESSENCE) {
                    if (!this.isDyed()) {
                        this.setDyed(true);
                    }
                    if (this.getDyeColor() != 100) {
                        this.setDyeColor(100);
                        for (int i = 0; i < 8; ++i) {
                            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)RatsItemRegistry.RATBOW_ESSENCE)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 2.0f) - (double)this.func_213302_cg(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                        }
                        this.func_184185_a(SoundEvents.field_187870_fk, this.func_70599_aP(), this.func_70647_i());
                        itemstack.func_190918_g(1);
                        return true;
                    }
                }
                if (itemstack.func_77973_b() instanceof DyeItem) {
                    DyeItem dyeItem = (DyeItem)itemstack.func_77973_b();
                    if (!this.isDyed()) {
                        this.setDyed(true);
                    }
                    if (this.getDyeColor() != dyeItem.func_195962_g().func_196059_a()) {
                        this.setDyeColor(dyeItem.func_195962_g().func_196059_a());
                        for (int i = 0; i < 8; ++i) {
                            double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                            double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                            this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, new ItemStack((IItemProvider)dyeItem)), this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 2.0f) - (double)this.func_213302_cg(), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
                        }
                        this.func_184185_a(SoundEvents.field_187870_fk, this.func_70599_aP(), this.func_70647_i());
                        itemstack.func_190918_g(1);
                        return true;
                    }
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.RAT_SACK) {
                    CompoundNBT compound = itemstack.func_77978_p();
                    if (compound == null) {
                        compound = new CompoundNBT();
                        itemstack.func_77982_d(compound);
                    }
                    CompoundNBT ratTag = new CompoundNBT();
                    this.func_213281_b(ratTag);
                    int currentRat = ItemRatSack.getRatsInStack(itemstack) + 1;
                    compound.func_218657_a("Rat_" + currentRat, (INBT)ratTag);
                    this.func_184185_a(SoundEvents.field_187728_s, 1.0f, 1.0f);
                    this.func_70106_y();
                    player.func_184609_a(hand);
                    return true;
                }
                if (itemstack.func_77973_b() == RatsItemRegistry.CHEESE_STICK || itemstack.func_77973_b() == RatsItemRegistry.RADIUS_STICK) {
                    itemstack.func_77978_p().func_186854_a("RatUUID", this.func_110124_au());
                    player.func_184609_a(hand);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.rats.rat.staff.bind", new Object[]{this.func_200200_C_()}), true);
                    return true;
                }
                if (itemstack.func_77973_b() == Items.field_151032_g) {
                    itemstack.func_190918_g(1);
                    ItemStack ratArrowStack = new ItemStack((IItemProvider)RatsItemRegistry.RAT_ARROW);
                    CompoundNBT compound = new CompoundNBT();
                    CompoundNBT ratTag = new CompoundNBT();
                    this.func_213281_b(ratTag);
                    compound.func_218657_a("Rat", (INBT)ratTag);
                    ratArrowStack.func_77982_d(compound);
                    if (itemstack.func_190926_b()) {
                        player.func_184611_a(hand, ratArrowStack);
                    } else if (!player.field_71071_by.func_70441_a(ratArrowStack)) {
                        player.func_71019_a(ratArrowStack, false);
                    }
                    this.func_184185_a(RatsSoundRegistry.RAT_HURT, 1.0f, 1.0f);
                    player.func_184609_a(hand);
                    this.func_70106_y();
                    return true;
                }
                if (!player.func_225608_bj_() && this.canBeTamed()) {
                    this.openGUI(player);
                    return true;
                }
                if (player.func_184188_bt().size() < 3) {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("entity.rats.rat.dismount_instructions", new Object[0]), true);
                    this.func_184205_a((Entity)player, true);
                }
                return true;
            }
        }
        return false;
    }

    public void func_70903_f(boolean tamed) {
        if (tamed) {
            Arrays.fill(this.field_184655_bs, 1.0f);
            Arrays.fill(this.field_82174_bp, 1.0f);
        }
        super.func_70903_f(tamed);
    }

    public int func_70627_aG() {
        if (this.hasPlague() && this.func_70909_n()) {
            return 200;
        }
        return super.func_70627_aG();
    }

    public boolean canBeTamed() {
        return !this.hasPlague();
    }

    public ItemStack func_184582_a(EquipmentSlotType slotIn) {
        if (slotIn == EquipmentSlotType.MAINHAND) {
            return this.ratInventory.func_70301_a(0);
        }
        if (slotIn == EquipmentSlotType.HEAD) {
            return this.ratInventory.func_70301_a(1);
        }
        if (slotIn == EquipmentSlotType.OFFHAND) {
            return this.ratInventory.func_70301_a(2);
        }
        return super.func_184582_a(slotIn);
    }

    public void func_184201_a(EquipmentSlotType slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlotType.MAINHAND) {
            this.ratInventory.func_70299_a(0, stack);
        } else if (slotIn == EquipmentSlotType.HEAD) {
            this.ratInventory.func_70299_a(1, stack);
        } else if (slotIn == EquipmentSlotType.OFFHAND) {
            this.ratInventory.func_70299_a(2, stack);
        } else {
            super.func_184582_a(slotIn);
        }
    }

    private void initInventory() {
        this.ratInventory = new Inventory(4);
        if (this.ratInventory != null) {
            for (int j = 0; j < this.ratInventory.func_70302_i_(); ++j) {
                ItemStack itemstack = this.ratInventory.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.ratInventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.setupDynamicAI();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (!(this.hasFlightUpgrade() || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) || this.inTube() || this.func_184218_aH())) {
            return super.func_225503_b_(distance, damageMultiplier);
        }
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (!this.hasFlightUpgrade() && !this.inTube()) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public RatStatus getRatStatus() {
        return this.status;
    }

    public void setRatStatus(RatStatus status) {
        if (this.status.canBeOverriden(this)) {
            this.status = status;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 82) {
            this.playEffect(0);
        } else if (id == 83) {
            this.playEffect(1);
        } else if (id == 84) {
            this.playEffect(2);
        } else if (id == 85) {
            this.crafting = true;
        } else if (id == 86) {
            this.crafting = false;
        } else if (id == 101) {
            this.playEffect(3);
        } else if (id != 125) {
            if (id == 126) {
                this.playEffect(5);
            } else {
                super.func_70103_a(id);
            }
        }
    }

    protected void playEffect(int type) {
        if (type == 3) {
            for (int j = 0; j < 5; ++j) {
                double d6 = (double)j / 5.0;
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d3 = this.field_70169_q + (this.func_226277_ct_() - this.field_70169_q) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
                double d4 = this.field_70167_r + (this.func_226278_cu_() - this.field_70167_r) * d6 + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg();
                double d5 = this.field_70166_s + (this.func_226281_cx_() - this.field_70166_s) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_218422_X, d3, d4, d5, (double)f, (double)f1, (double)f2);
            }
        } else if (type == 2) {
            for (int j = 0; j < 5; ++j) {
                double d6 = (double)j / 5.0;
                float f = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f1 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                float f2 = (this.field_70146_Z.nextFloat() - 0.5f) * 0.2f;
                double d3 = this.field_70169_q + (this.func_226277_ct_() - this.field_70169_q) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
                double d4 = this.field_70167_r + (this.func_226278_cu_() - this.field_70167_r) * d6 + this.field_70146_Z.nextDouble() * (double)this.func_213302_cg();
                double d5 = this.field_70166_s + (this.func_226281_cx_() - this.field_70166_s) * d6 + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, d3, d4, d5, (double)f, (double)f1, (double)f2);
            }
        } else {
            BasicParticleType p = ParticleTypes.field_197601_L;
            if (type == 1) {
                p = ParticleTypes.field_197633_z;
            }
            if (type == 5) {
                p = ParticleTypes.field_197593_D;
            }
            for (int i = 0; i < 9; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)p, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), d0, d1, d2);
            }
        }
    }

    public boolean isMoving() {
        return Math.abs(this.func_213322_ci().field_72450_a) >= 0.05 || Math.abs(this.func_213322_ci().field_72449_c) >= 0.05;
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        spawnDataIn = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setColorVariant(this.func_70681_au().nextInt(4));
        this.setMale(this.func_70681_au().nextBoolean());
        if (this.func_70681_au().nextInt(15) == 0 && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL && RatConfig.plagueRats && reason != SpawnReason.CONVERSION) {
            this.setPlague(true);
        }
        this.field_70170_p.func_201675_m();
        if (this.field_70170_p.func_201675_m().func_186058_p() == RatsWorldRegistry.RATLANTIS_DIMENSION_TYPE) {
            this.setToga(true);
        }
        if (this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i > 10 && this.field_70146_Z.nextFloat() <= 0.25f) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)Blocks.field_150423_aK));
                this.field_184655_bs[EquipmentSlotType.HEAD.func_188454_b()] = 1.0f;
            }
            if ((j == 11 && i > 15 || j == 12 || j == 1 && i <= 10) && this.field_70146_Z.nextFloat() <= 0.25f) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)RatsItemRegistry.SANTA_HAT));
                this.field_184655_bs[EquipmentSlotType.HEAD.func_188454_b()] = 1.0f;
            }
        }
        return spawnDataIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getRatTexture() {
        return RAT_TEXTURES[MathHelper.func_76125_a((int)this.getColorVariant(), (int)0, (int)(RAT_TEXTURES.length - 1))];
    }

    public ITextComponent func_200200_C_() {
        if (this.hasPlague()) {
            return new TranslationTextComponent("entity.rats.plague_rat", new Object[0]);
        }
        return super.func_200200_C_();
    }

    public boolean shouldHuntAnimal() {
        return this.getCommandInteger() == 3;
    }

    public boolean shouldHuntMonster() {
        return this.getCommandInteger() == 7;
    }

    public boolean shouldWander() {
        int cmd = this.getCommandInteger();
        return cmd != 4 && cmd != 5 && cmd != 6;
    }

    public boolean shouldEyesGlow() {
        return this.hasPlague() || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ENDER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AQUATIC);
    }

    protected SoundEvent func_184639_G() {
        SoundEvent possibleDragonSound;
        if (this.hasPlague() && this.func_70638_az() != null) {
            return RatsSoundRegistry.RAT_PLAGUE;
        }
        if (!this.hasPlague() && this.func_70909_n() && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS)) {
            return RatsSoundRegistry.RAT_SANTA;
        }
        if (!this.hasPlague() && (double)this.func_110143_aJ() <= (double)this.func_110138_aP() / 2.0 || this.func_70631_g_()) {
            return RatsSoundRegistry.RAT_IDLE;
        }
        if (RatsMod.ICEANDFIRE_LOADED && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) && (possibleDragonSound = (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation("iceandfire", "firedragon_child_idle"))) != null) {
            return possibleDragonSound;
        }
        return super.func_184639_G();
    }

    protected SoundEvent func_184615_bR() {
        SoundEvent possibleDragonSound;
        if (RatsMod.ICEANDFIRE_LOADED && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) && (possibleDragonSound = (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation("iceandfire", "firedragon_child_death"))) != null) {
            return possibleDragonSound;
        }
        return RatsSoundRegistry.RAT_DIE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        SoundEvent possibleDragonSound;
        if (RatsMod.ICEANDFIRE_LOADED && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) && (possibleDragonSound = (SoundEvent)Registry.field_212633_v.func_82594_a(new ResourceLocation("iceandfire", "firedragon_child_hurt"))) != null) {
            return possibleDragonSound;
        }
        return RatsSoundRegistry.RAT_HURT;
    }

    public boolean onHearFlute(PlayerEntity player, RatCommand ratCommand) {
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !this.func_70631_g_() && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NO_FLUTE)) {
            this.setCommand(ratCommand);
            return true;
        }
        return false;
    }

    public boolean canRatPickupItem(ItemStack stack) {
        CompoundNBT CompoundNBT1;
        if ((this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_WHITELIST)) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && (CompoundNBT1 = this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST) ? this.getUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST).func_77978_p() : this.getUpgrade(RatsItemRegistry.RAT_UPGRADE_WHITELIST).func_77978_p()) != null && CompoundNBT1.func_150297_b("Items", 9)) {
            NonNullList nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)CompoundNBT1, (NonNullList)nonnulllist);
            if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BLACKLIST)) {
                for (ItemStack itemstack : nonnulllist) {
                    if (!itemstack.func_77969_a(stack)) continue;
                    return false;
                }
                return true;
            }
            for (ItemStack itemstack : nonnulllist) {
                if (!itemstack.func_77969_a(stack)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean attemptTeleport(double x, double y, double z) {
        double d0 = this.func_226277_ct_();
        double d1 = this.func_226278_cu_();
        double d2 = this.func_226281_cx_();
        this.func_70107_b(x, y, z);
        this.field_70170_p.func_72960_a((Entity)this, (byte)84);
        boolean flag = false;
        BlockPos blockpos = new BlockPos((Entity)this);
        World world = this.field_70170_p;
        Random random = this.func_70681_au();
        if (world.func_175667_e(blockpos)) {
            boolean flag1 = false;
            while (!flag1 && blockpos.func_177956_o() > 0) {
                BlockPos blockpos1 = blockpos.func_177977_b();
                BlockState BlockState2 = world.func_180495_p(blockpos1);
                if (BlockState2.func_185904_a().func_76230_c()) {
                    flag1 = true;
                    continue;
                }
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
                blockpos = blockpos1;
            }
            if (flag1) {
                this.func_70634_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
                if (world.func_223439_a((Entity)this, this.func_174813_aQ(), (Set)ImmutableSet.of()).toArray().length == 0 && !world.func_72953_d(this.func_174813_aQ())) {
                    flag = true;
                }
            }
        }
        if (!flag) {
            this.func_70634_a(d0, d1, d2);
            return false;
        }
        int i = 128;
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        return true;
    }

    public boolean isDirectPathBetweenPoints(Vec3d target) {
        RayTraceResult rayTrace = RatUtils.rayTraceBlocksIgnoreRatholes(this.field_70170_p, this.func_174791_d(), target.func_72441_c(0.5, 0.5, 0.5), false, (Entity)this);
        if (rayTrace instanceof BlockRayTraceResult) {
            BlockRayTraceResult blockRayTraceResult = (BlockRayTraceResult)rayTrace;
            BlockPos pos = blockRayTraceResult.func_216350_a();
            BlockPos sidePos = blockRayTraceResult.func_216350_a().func_177972_a(blockRayTraceResult.func_216354_b());
            if (!this.field_70170_p.func_175623_d(pos) || !this.field_70170_p.func_175623_d(sidePos)) {
                return true;
            }
            return rayTrace.func_216346_c() == RayTraceResult.Type.MISS;
        }
        return true;
    }

    public BlockPos getLightPosition() {
        BlockPos pos = new BlockPos((Entity)this);
        if (!this.field_70170_p.func_180495_p(pos).func_200132_m()) {
            return pos.func_177984_a();
        }
        return pos;
    }

    public boolean inTube() {
        return this.inTube;
    }

    private boolean inTubeLogic() {
        if (this.func_70909_n()) {
            BlockPos pos = new BlockPos((Entity)this);
            BlockState state = this.field_70170_p.func_180495_p(pos);
            boolean above = this.field_70170_p.func_180495_p(pos.func_177984_a()).func_177230_c() instanceof BlockRatTube;
            if (state.func_177230_c() instanceof BlockRatTube) {
                List<VoxelShape> aabbs = ((BlockRatTube)state.func_177230_c()).compileVoxelList((IBlockReader)this.field_70170_p, pos, state);
                AxisAlignedBB bb = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);
                for (VoxelShape box : aabbs) {
                    bb = bb.func_111270_a(box.func_197752_a());
                }
                return (bb = bb.func_72314_b((double)0.05f, 0.0, (double)0.05f).func_186670_a(pos)).func_72318_a(this.func_174791_d().func_72441_c(0.0, (double)(this.func_213302_cg() / 2.0f), 0.0)) || bb.func_72318_a(this.func_174791_d()) && above;
            }
        }
        return false;
    }

    private boolean inTubeFast() {
        return this.inTube;
    }

    public boolean func_175446_cd() {
        return super.func_175446_cd() || this.getRespawnCountdown() > 0;
    }

    public void setTubeTarget(BlockPos targetPosition) {
        this.tubeTarget = targetPosition;
    }

    public ItemStack getUpgradeSlot() {
        return this.func_184586_b(Hand.OFF_HAND);
    }

    public ItemStack getUpgrade(Item item) {
        ItemStack stack = this.getUpgradeSlot();
        if (!stack.func_190926_b()) {
            NonNullList nonnulllist;
            CompoundNBT CompoundNBT1;
            if (stack.func_77973_b() == item) {
                return stack;
            }
            if (stack.func_77973_b() instanceof ItemRatUpgradeCombined && (CompoundNBT1 = stack.func_77978_p()) != null && CompoundNBT1.func_150297_b("Items", 9)) {
                nonnulllist = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)CompoundNBT1, (NonNullList)nonnulllist);
                for (ItemStack stack1 : nonnulllist) {
                    if (stack1.func_77973_b() != item) continue;
                    return stack1;
                }
            }
            if (stack.func_77973_b() instanceof ItemRatUpgradeJuryRigged && (CompoundNBT1 = stack.func_77978_p()) != null && CompoundNBT1.func_150297_b("Items", 9)) {
                nonnulllist = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
                ItemStackHelper.func_191283_b((CompoundNBT)CompoundNBT1, (NonNullList)nonnulllist);
                for (ItemStack stack1 : nonnulllist) {
                    if (stack1.func_77973_b() != item) continue;
                    return stack1;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    public boolean hasUpgrade(Item item) {
        if (!this.getUpgradeSlot().func_190926_b()) {
            return this.getUpgrade(item) != ItemStack.field_190927_a;
        }
        return false;
    }

    public boolean holdsItemInHandUpgrade() {
        return this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHRISTMAS);
    }

    public boolean shouldNotIdleAnimation() {
        return this.holdInMouth && this.getAnimation() != ANIMATION_EAT && this.cookingProgress <= 0 && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLATTER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_LUMBERJACK) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MINER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FISHERMAN) && !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SHEARS);
    }

    private void onUpgradeChanged() {
        this.setupDynamicAI();
        boolean flagHealth = false;
        boolean flagArmor = false;
        boolean flagAttack = false;
        boolean flagSpeed = false;
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARISTOCRAT) && this.coinCooldown == 0) {
            this.coinCooldown = this.field_70146_Z.nextInt(6000) + 6000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_SPEED)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111263_d, 0.5);
            flagSpeed = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GOD)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 500.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 50.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 50.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_WARRIOR)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 40.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 12.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 10.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_HEALTH)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 25.0);
            flagHealth = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARMOR)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 10.0);
            flagArmor = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_STRENGTH)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 5.0);
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_VOODOO)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 100.0);
            flagHealth = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_RATINATOR)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 30.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 80.0);
            flagHealth = true;
            flagArmor = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 50.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 15.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 8.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_NONBELIEVER)) {
            this.tryIncreaseStat(SharedMonsterAttributes.field_111267_a, 1000.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_188791_g, 100.0);
            this.tryIncreaseStat(SharedMonsterAttributes.field_111264_e, 100.0);
            flagHealth = true;
            flagArmor = true;
            flagAttack = true;
        }
        if (!flagHealth) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        if (!flagArmor) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(0.0);
        }
        if (!flagAttack) {
            this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
        }
        if (!flagSpeed) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
        }
        if (this.getHeldRF() > this.getRFTransferRate()) {
            this.setHeldRF(0);
        }
        this.func_70691_i(this.func_110138_aP());
    }

    private void tryIncreaseStat(IAttribute stat, double value) {
        double prev = this.func_110148_a(stat).func_111126_e();
        if (prev < value) {
            this.func_110148_a(stat).func_111128_a(value);
        }
    }

    public boolean func_70687_e(EffectInstance potioneffectIn) {
        if (potioneffectIn.func_188419_a() == Effects.field_76436_u && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_POISON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION))) {
            return false;
        }
        if (potioneffectIn.func_188419_a() == RatsMod.PLAGUE_POTION) {
            return false;
        }
        return super.func_70687_e(potioneffectIn);
    }

    public boolean isInvulnerabledddddTo(DamageSource source) {
        if (this.getRespawnCountdown() > 0) {
            return true;
        }
        if (source.func_76347_k() && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ASBESTOS) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON))) {
            return true;
        }
        if ((source.func_82725_o() || source == DamageSource.field_82727_n) && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_POISON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION))) {
            return true;
        }
        if ((source == DamageSource.field_76368_d || source == DamageSource.field_76369_e) && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_POISON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION))) {
            return true;
        }
        if (source == DamageSource.field_76379_h && (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DAMAGE_PROTECTION) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR))) {
            return true;
        }
        if (source.func_94541_c() && this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_TNT_SURVIVOR)) {
            return true;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CREATIVE)) {
            return source.func_76346_g() == null || source.func_76346_g() instanceof LivingEntity && !this.func_152114_e((LivingEntity)source.func_76346_g());
        }
        return super.func_180431_b(source);
    }

    public boolean func_190530_aW() {
        return super.func_190530_aW() || this.getRespawnCountdown() > 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_191987_a(BlockPos pos, boolean isPartying) {
        int moves = this.field_70146_Z.nextInt(4);
        if (!this.isDancing() && isPartying) {
            this.setDanceMoves(moves);
        }
        this.setDancing(isPartying);
        this.jukeboxPos = pos;
        if (this.field_70170_p.field_72995_K) {
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageDancingRat(this.func_145782_y(), isPartying, pos.func_218275_a(), moves));
        }
    }

    public boolean shouldDepositItem(ItemStack item) {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHEF) && !this.getCookingResultFor(item).func_190926_b()) {
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ARCHEOLOGIST) && !this.getArcheologyResultFor(item).func_190926_b()) {
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GEMCUTTER) && !this.getGemcutterResultFor(item).func_190926_b()) {
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FARMER) && (item.func_77973_b() == Items.field_196106_bc || item.func_77973_b() instanceof BlockNamedItem)) {
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BREEDER) && this.getCommand() == RatCommand.HARVEST) {
            return false;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_PLACER) && this.getCommand() == RatCommand.HARVEST) {
            return false;
        }
        return !this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ORE_DOUBLING) || !ItemRatUpgradeOreDoubling.isProcessable(item);
    }

    public int getRFTransferRate() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_EXTREME_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_EXTREME_ENERGY) * 1000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ELITE_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_ELITE_ENERGY) * 1000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ADVANCED_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_ADVANCED_ENERGY) * 1000;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY)) {
            return ItemRatUpgradeEnergy.getRFTransferRate(RatsItemRegistry.RAT_UPGRADE_BASIC_ENERGY) * 1000;
        }
        return 0;
    }

    public int getMBTransferRate() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BUCKET)) {
            return ItemRatUpgradeBucket.getMbTransferRate(RatsItemRegistry.RAT_UPGRADE_BUCKET);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_MILKER)) {
            return ItemRatUpgradeBucket.getMbTransferRate(RatsItemRegistry.RAT_UPGRADE_MILKER);
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET)) {
            return ItemRatUpgradeBucket.getMbTransferRate(RatsItemRegistry.RAT_UPGRADE_BIG_BUCKET);
        }
        return 0;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (entityIn != null) {
            if (entityIn instanceof TameableEntity) {
                TameableEntity tameable = (TameableEntity)entityIn;
                if (tameable.func_70909_n() && this.func_70909_n() && this.func_184753_b() != null && tameable.func_184753_b() != null && this.func_184753_b().equals(tameable.func_184753_b())) {
                    return true;
                }
                if (tameable instanceof EntityRat) {
                    EntityRat rat = (EntityRat)tameable;
                    if (this.getMonsterOwnerID() != null && rat.getMonsterOwnerID() != null && this.getMonsterOwnerID().equals(rat.getMonsterOwnerID())) {
                        return true;
                    }
                }
            }
            if (entityIn instanceof EntityRatMountBase && ((EntityRatMountBase)entityIn).getRat() != null) {
                return this.func_184191_r((Entity)((EntityRatMountBase)entityIn).getRat());
            }
            return super.func_184191_r(entityIn);
        }
        return false;
    }

    public boolean isDead() {
        return this.field_70729_aU;
    }

    public boolean func_189652_ae() {
        return this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL) || super.func_189652_ae();
    }

    public float func_70013_c() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_ETHEREAL)) {
            return 240.0f;
        }
        return super.func_70013_c();
    }

    public boolean isAttackCommand() {
        return this.getCommandInteger() == 0 || this.getCommandInteger() == 2 || this.getCommandInteger() == 3 || this.getCommandInteger() == 7;
    }

    public boolean hasCustomSearchZone() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_CUSTOM_RADIUS);
    }

    public void setCustomSearchZone(boolean customSearchZone) {
        this.field_70180_af.func_187227_b(HAS_CUSTOM_RADIUS, (Object)customSearchZone);
    }

    public int getSearchRadius() {
        return (Integer)this.field_70180_af.func_187225_a(SEARCH_RADIUS);
    }

    public void setSearchRadius(int radius) {
        this.field_70180_af.func_187227_b(SEARCH_RADIUS, (Object)radius);
    }

    public BlockPos getSearchRadiusCenter() {
        return (BlockPos)this.field_70180_af.func_187225_a(RADIUS_CENTER);
    }

    public void setSearchRadiusCenter(BlockPos radius) {
        if (radius == null) {
            this.setCustomSearchZone(false);
        } else {
            this.setCustomSearchZone(true);
            this.field_70180_af.func_187227_b(RADIUS_CENTER, (Object)radius);
        }
    }

    public BlockPos getSearchCenter() {
        if (this.getSearchRadiusCenter() == null || !this.hasCustomSearchZone()) {
            return this.func_180425_c();
        }
        return this.getSearchRadiusCenter();
    }

    @Nullable
    private EntityType getMountEntityType() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHICKEN_MOUNT)) {
            return RatsEntityRegistry.RAT_MOUNT_CHICKEN;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GOLEM_MOUNT)) {
            return RatsEntityRegistry.RAT_MOUNT_GOLEM;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BEAST_MOUNT)) {
            return RatsEntityRegistry.RAT_MOUNT_BEAST;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AUTOMATON_MOUNT)) {
            return RatsEntityRegistry.RAT_MOUNT_AUTOMATON;
        }
        return null;
    }

    public double func_70092_e(double x, double y, double z) {
        double d0 = this.func_226277_ct_() - x;
        double d1 = this.func_226278_cu_() - y;
        double d2 = this.func_226281_cx_() - z;
        if (this.func_184187_bx() != null && this.getMountEntityType() != null && this.func_184187_bx().func_200600_R() == this.getMountEntityType()) {
            d0 = this.func_184187_bx().func_226277_ct_() - x;
            d1 = this.func_184187_bx().func_226278_cu_() - y;
            d2 = this.func_184187_bx().func_226281_cx_() - z;
        }
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public double func_195048_a(Vec3d p_195048_1_) {
        double d0 = this.func_226277_ct_() - p_195048_1_.field_72450_a;
        double d1 = this.func_226278_cu_() - p_195048_1_.field_72448_b;
        double d2 = this.func_226281_cx_() - p_195048_1_.field_72449_c;
        if (this.func_184187_bx() != null && this.getMountEntityType() != null && this.func_184187_bx().func_200600_R() == this.getMountEntityType()) {
            d0 = this.func_184187_bx().func_226277_ct_() - p_195048_1_.field_72450_a;
            d1 = this.func_184187_bx().func_226278_cu_() - p_195048_1_.field_72448_b;
            d2 = this.func_184187_bx().func_226281_cx_() - p_195048_1_.field_72449_c;
        }
        return d0 * d0 + d1 * d1 + d2 * d2;
    }

    public boolean isRidingSpecialMount() {
        return this.func_184187_bx() != null && this.getMountEntityType() != null && this.func_184187_bx().func_200600_R() == this.getMountEntityType();
    }

    public int getTailBehaviorForMount() {
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_GOLEM_MOUNT) && this.isRidingSpecialMount()) {
            return 1;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_CHICKEN_MOUNT) && this.isRidingSpecialMount()) {
            return 2;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BEAST_MOUNT) && this.isRidingSpecialMount()) {
            return 3;
        }
        if (this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_AUTOMATON_MOUNT) && this.isRidingSpecialMount()) {
            return 4;
        }
        if (this.func_184218_aH() && this.func_184187_bx() instanceof EntityRattlingGun) {
            return 5;
        }
        return 0;
    }

    public boolean func_213336_c(LivingEntity target) {
        return !this.isRidingSpecialMount() || !this.func_184215_y((Entity)target);
    }

    public double getRatDistanceModifier() {
        Entity entity;
        if (this.isRidingSpecialMount() && (entity = this.func_184187_bx()) != null) {
            return 1.5;
        }
        return 1.0;
    }

    protected ResourceLocation func_184647_J() {
        return this.hasPlague() ? PLAGUE_RAT_LOOT_TABLE : this.func_200600_R().func_220348_g();
    }

    public boolean hasFlightUpgrade() {
        return this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_FLIGHT) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_DRAGON) || this.hasUpgrade(RatsItemRegistry.RAT_UPGRADE_BEE);
    }
}

