/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server.blocks;

import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FallingBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockGarbage
extends FallingBlock {
    public SpawnReason spawnReason;
    public double spawnRateModifier;

    public BlockGarbage(String name, double spawnRateModifier) {
        super(Block.Properties.func_200945_a((Material)Material.field_151577_b).func_200947_a(SoundType.field_185849_b).func_200948_a(0.7f, 1.0f).func_200944_c());
        this.setRegistryName("rats", name);
        this.spawnReason = SpawnReason.NATURAL;
        this.spawnRateModifier = spawnRateModifier;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if ((double)random.nextFloat() <= RatConfig.garbageSpawnRate * this.spawnRateModifier) {
            int i;
            EntityRat rat = new EntityRat(RatsEntityRegistry.RAT, (World)worldIn);
            rat.func_70012_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5, 0.0f, 0.0f);
            int n = i = worldIn.func_72911_I() ? worldIn.func_205049_d(pos.func_177984_a(), 10) : worldIn.func_201696_r(pos.func_177984_a());
            if (i <= random.nextInt(8) && !rat.func_70094_T() && rat.func_205019_a((IWorldReader)worldIn)) {
                rat.func_213386_a((IWorld)worldIn, worldIn.func_175649_E(pos), this.spawnReason, null, null);
                this.onSpawnRat(rat);
                if (!worldIn.field_72995_K) {
                    worldIn.func_217376_c((Entity)rat);
                }
            }
        }
    }

    public void onSpawnRat(EntityRat rat) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add(new TranslationTextComponent(this.func_149739_a() + ".desc", new Object[0]).func_211708_a(TextFormatting.GRAY));
    }

    public int func_189876_x(BlockState state) {
        return 7956827;
    }

    @Deprecated
    public boolean canEntitySpawn(BlockState state, Entity entityIn) {
        return entityIn instanceof EntityRat;
    }
}

