/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.server;

import com.github.alexthe666.rats.ConfigHolder;
import com.github.alexthe666.rats.RatConfig;
import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.inventory.RatsContainerRegistry;
import com.github.alexthe666.rats.server.misc.RatsSoundRegistry;
import com.github.alexthe666.rats.server.recipes.RatsRecipeRegistry;
import com.github.alexthe666.rats.server.world.BiomeRatlantis;
import com.github.alexthe666.rats.server.world.RatsWorldRegistry;
import com.github.alexthe666.rats.server.world.structure.RatlantisStructureRegistry;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BannerPatternItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.surfacebuilders.SurfaceBuilder;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.RegisterDimensionsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="rats", bus=Mod.EventBusSubscriber.Bus.MOD)
public class CommonProxy {
    @SubscribeEvent
    public static void registerPotions(RegistryEvent.Register<Effect> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Effect[]{RatsMod.CONFIT_BYALDI_POTION, RatsMod.PLAGUE_POTION});
    }

    @SubscribeEvent
    public static void registerFluids(RegistryEvent.Register<Fluid> event) {
    }

    @SubscribeEvent
    public static void registerSoundEvents(RegistryEvent.Register<SoundEvent> event) {
        try {
            for (Field f : RatsSoundRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof SoundEvent) {
                    event.getRegistry().register((IForgeRegistryEntry)((SoundEvent)obj));
                    continue;
                }
                if (!(obj instanceof SoundEvent[])) continue;
                for (SoundEvent sound : (SoundEvent[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)sound);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void registerVillagers(RegistryEvent.Register<VillagerProfession> event) {
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        try {
            for (Field f : RatsEntityRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof EntityType) {
                    event.getRegistry().register((IForgeRegistryEntry)((EntityType)obj));
                    continue;
                }
                if (!(obj instanceof EntityType[])) continue;
                for (EntityType type : (EntityType[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)type);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        RatsRecipeRegistry.register();
    }

    @SubscribeEvent
    public static void registerSpawnEggs(RegistryEvent.Register<Item> event) {
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.RAT, 0x30333E, 14330785, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_rat"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.PIED_PIPER, 13286466, 3891299, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_piper"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.RATLANTEAN_SPIRIT, 15580416, 16771247, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_ratlantean_spirit"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.RATLANTEAN_AUTOMATON, 15262935, 7530837, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_ratlantean_automaton"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.FERAL_RATLANTEAN, 0x30333E, 0xECECEC, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_feral_ratlantean"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.NEO_RATLANTEAN, 0x30333E, 61423, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_neo_ratlantean"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.PIRAT, 0x30333E, 11482682, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_pirat"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.PLAGUE_DOCTOR, 0x2A292A, 5329753, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_plague_doctor"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.BLACK_DEATH, 0, 0, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_black_death"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.PLAGUE_CLOUD, 0, 5396301, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_plague_cloud"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.PLAGUE_BEAST, 0, 0xECECEC, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_plague_beast"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.GHOST_PIRAT, 0x54AA55, 0x7BD77D, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_ghost_pirat"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.DUTCHRAT, 0xBBF9BB, 13689525, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_dutchrat"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.RATFISH, 0x30333E, 8300733, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_ratfish"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.RATLANTEAN_RATBOT, 0xA3A3A3, 0xFF0000, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_ratlantean_ratbot"));
        event.getRegistry().register(new SpawnEggItem(RatsEntityRegistry.RAT_KING, 0x30333E, 3748911, new Item.Properties().func_200916_a(RatsMod.TAB)).setRegistryName("rats:spawn_egg_rat_king"));
        event.getRegistry().register(new BannerPatternItem(RatsRecipeRegistry.RAT_PATTERN, new Item.Properties().func_200917_a(1).func_200916_a(RatsMod.TAB)).setRegistryName("rats:rat_banner_pattern"));
        event.getRegistry().register(new BannerPatternItem(RatsRecipeRegistry.CHEESE_PATTERN, new Item.Properties().func_200917_a(1).func_200916_a(RatsMod.TAB)).setRegistryName("rats:cheese_banner_pattern"));
        event.getRegistry().register(new BannerPatternItem(RatsRecipeRegistry.RAT_AND_CROSSBONES_BANNER, new Item.Properties().func_200917_a(1).func_200916_a(RatsMod.TAB)).setRegistryName("rats:rat_and_crossbones_banner_pattern"));
        event.getRegistry().register(new BannerPatternItem(RatsRecipeRegistry.RAT_AND_SICKLE_BANNER, new Item.Properties().func_200917_a(1).func_200916_a(RatsMod.TAB)).setRegistryName("rats:rat_and_sickle_banner_pattern"));
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == ConfigHolder.CLIENT_SPEC) {
            RatConfig.bakeClient(config);
        } else if (config.getSpec() == ConfigHolder.SERVER_SPEC) {
            RatConfig.bakeServer(config);
        }
    }

    @SubscribeEvent
    public static void registerWorldGenFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Feature[]{RatsWorldRegistry.RAT_RUINS, RatsWorldRegistry.FLYING_DUTCHRAT, RatsWorldRegistry.RATLANTIS_AQUADUCTS});
    }

    @SubscribeEvent
    public static void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        try {
            for (Field f : RatsContainerRegistry.class.getDeclaredFields()) {
                Object obj = f.get(null);
                if (obj instanceof ContainerType) {
                    event.getRegistry().register((IForgeRegistryEntry)((ContainerType)obj));
                    continue;
                }
                if (!(obj instanceof ContainerType[])) continue;
                for (ContainerType container : (ContainerType[])obj) {
                    event.getRegistry().register((IForgeRegistryEntry)container);
                }
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SubscribeEvent
    public static void registerSurfaces(RegistryEvent.Register<SurfaceBuilder<?>> event) {
    }

    @SubscribeEvent
    public static void registerBiomes(RegistryEvent.Register<Biome> event) {
        RatsWorldRegistry.RATLANTIS_BIOME = new BiomeRatlantis();
        event.getRegistry().register((IForgeRegistryEntry)RatsWorldRegistry.RATLANTIS_BIOME);
    }

    @SubscribeEvent
    public static void registerDimensionTypes(RegisterDimensionsEvent event) {
        RatsWorldRegistry.RATLANTIS_DIMENSION_TYPE = DimensionManager.registerOrGetDimension((ResourceLocation)new ResourceLocation("rats:ratlantis"), (ModDimension)RatsWorldRegistry.RATLANTIS_DIM, null, (boolean)true);
    }

    @SubscribeEvent
    public static void registerModDimensions(RegistryEvent.Register<ModDimension> event) {
        event.getRegistry().register((IForgeRegistryEntry)RatsWorldRegistry.RATLANTIS_DIM);
        RatlantisStructureRegistry.register();
    }

    public void preInit() {
    }

    public void init() {
    }

    public void postInit() {
    }

    public Object getArmorModel(int index) {
        return null;
    }

    public boolean shouldRenderNameplates() {
        return true;
    }

    public void openCheeseStaffGui() {
    }

    public EntityRat getRefrencedRat() {
        return null;
    }

    public void setRefrencedRat(EntityRat rat) {
    }

    public TileEntity getRefrencedTE() {
        return null;
    }

    public void setRefrencedTE(TileEntity te) {
    }

    public void setCheeseStaffContext(BlockPos pos, Direction facing) {
    }

    public void addParticle(String name, double x, double y, double z, double motX, double motY, double motZ) {
    }

    public ItemStack getRefrencedItem() {
        return ItemStack.field_190927_a;
    }

    public void setRefrencedItem(ItemStack stack) {
    }

    public World getWorld() {
        return null;
    }

    public void handlePacketAutoCurdlerFluid(long blockPos, FluidStack fluid) {
    }

    public void handlePacketCheeseStaffRat(int entityId, boolean clear) {
    }

    public void handlePacketUpdateTileSlots(long blockPos, CompoundNBT tag) {
    }

    public void setupTEISR(Item.Properties props) {
    }

    public void openRadiusStaffGui() {
    }

    public void addMobSpawns() {
        List spawnList;
        if (RatConfig.spawnRats) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                if (biome == null || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) continue;
                if (RatConfig.ratsSpawnLikeMonsters) {
                    spawnList = biome.func_76747_a(EntityClassification.MONSTER);
                    spawnList.add(new Biome.SpawnListEntry(RatsEntityRegistry.RAT_SPAWNER, RatConfig.ratSpawnRate, 1, 3));
                    continue;
                }
                spawnList = biome.func_76747_a(EntityClassification.CREATURE);
                spawnList.add(new Biome.SpawnListEntry(RatsEntityRegistry.RAT, RatConfig.ratSpawnRate, 1, 3));
            }
        }
        if (RatConfig.spawnPiper) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                if (biome == null || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.END) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) continue;
                spawnList = biome.func_76747_a(EntityClassification.MONSTER);
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MUSHROOM)) continue;
                if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.MAGICAL) || BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY)) {
                    spawnList.add(new Biome.SpawnListEntry(RatsEntityRegistry.PIED_PIPER, RatConfig.piperSpawnRate * 3, 1, 1));
                    continue;
                }
                spawnList.add(new Biome.SpawnListEntry(RatsEntityRegistry.PIED_PIPER, RatConfig.piperSpawnRate, 1, 1));
            }
        }
    }
}

