/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client.gui;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.gui.ChangeCommandButton;
import com.github.alexthe666.rats.client.gui.CommandPressButton;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatCommand;
import com.github.alexthe666.rats.server.entity.RatUtils;
import com.github.alexthe666.rats.server.inventory.ContainerRat;
import com.github.alexthe666.rats.server.message.MessageRatCommand;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiRat
extends ContainerScreen<ContainerRat> {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("rats:textures/gui/rat_inventory.png");
    private static final ResourceLocation TEXTURE_BACKDROP = new ResourceLocation("rats:textures/gui/rat_inventory_backdrop.png");
    private int currentDisplayCommand = 0;
    private EntityRat rat = RatsMod.PROXY.getRefrencedRat();
    private float mousePosx;
    private float mousePosY;

    public GuiRat(ContainerRat container, PlayerInventory inv, ITextComponent name) {
        super((Container)container, inv, name);
    }

    public static void drawEntityOnScreen(int x, int y, int scale, float yaw, float pitch, LivingEntity entity) {
        float f = (float)Math.atan(yaw / 40.0f);
        float f1 = (float)Math.atan(pitch / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrixstack = new MatrixStack();
        matrixstack.func_227861_a_(0.0, 0.0, 1000.0);
        matrixstack.func_227862_a_((float)scale, (float)scale, (float)scale);
        Quaternion quaternion = Vector3f.field_229183_f_.func_229187_a_(180.0f);
        Quaternion quaternion1 = Vector3f.field_229179_b_.func_229187_a_(f1 * 20.0f);
        quaternion.func_195890_a(quaternion1);
        matrixstack.func_227863_a_(quaternion);
        float f2 = entity.field_70761_aq;
        float f3 = entity.field_70177_z;
        float f4 = entity.field_70125_A;
        float f5 = entity.field_70758_at;
        float f6 = entity.field_70759_as;
        entity.field_70761_aq = 180.0f + f * 20.0f;
        entity.field_70177_z = 180.0f + f * 40.0f;
        entity.field_70125_A = -f1 * 20.0f;
        entity.field_70759_as = entity.field_70177_z;
        entity.field_70758_at = entity.field_70177_z;
        EntityRendererManager entityrenderermanager = Minecraft.func_71410_x().func_175598_ae();
        quaternion1.func_195892_e();
        entityrenderermanager.func_229089_a_(quaternion1);
        entityrenderermanager.func_178633_a(false);
        IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        entityrenderermanager.func_229084_a_((Entity)entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixstack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
        irendertypebuffer$impl.func_228461_a_();
        entityrenderermanager.func_178633_a(true);
        entity.field_70761_aq = f2;
        entity.field_70177_z = f3;
        entity.field_70125_A = f4;
        entity.field_70758_at = f5;
        entity.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    public void init() {
        super.init();
        this.buttons.clear();
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        this.addButton((Widget)new ChangeCommandButton(1, i + 115, j + 54, false, p_214132_1_ -> {
            --this.currentDisplayCommand;
            this.currentDisplayCommand = RatUtils.wrapCommand(this.currentDisplayCommand).ordinal();
        }));
        this.addButton((Widget)new ChangeCommandButton(2, i + 198, j + 54, true, p_214132_1_ -> {
            ++this.currentDisplayCommand;
            this.currentDisplayCommand = RatUtils.wrapCommand(this.currentDisplayCommand).ordinal();
        }));
        this.addButton((Widget)new CommandPressButton(3, i + 122, j + 52, p_214132_1_ -> {
            this.rat.setCommand(RatCommand.values()[this.currentDisplayCommand]);
            RatsMod.NETWORK_WRAPPER.sendToServer((Object)new MessageRatCommand(this.rat.func_145782_y(), this.currentDisplayCommand));
        }));
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String commandText;
        String name = this.getTitle().func_150254_d().length() == 0 ? I18n.func_135052_a((String)"entity.rats.rat", (Object[])new Object[0]) : this.getTitle().func_150254_d();
        this.font.func_211126_b(name, (float)(this.field_146999_f / 2 - this.font.func_78256_a(name) / 2), 6.0f, 0x404040);
        String commandDesc = I18n.func_135052_a((String)"entity.rats.rat.command.current", (Object[])new Object[0]);
        this.font.func_211126_b(commandDesc, (float)(this.field_146999_f / 2 - this.font.func_78256_a(commandDesc) / 2 + 36), 19.0f, 0x404040);
        String command = I18n.func_135052_a((String)this.rat.getCommand().getTranslateName(), (Object[])new Object[0]);
        this.font.func_211126_b(command, (float)(this.field_146999_f / 2 - this.font.func_78256_a(command) / 2 + 36), 31.0f, 0xFFFFFF);
        String statusDesc = I18n.func_135052_a((String)"entity.rats.rat.command.set", (Object[])new Object[0]);
        this.font.func_211126_b(statusDesc, (float)(this.field_146999_f / 2 - this.font.func_78256_a(statusDesc) / 2 + 36), 44.0f, 0x404040);
        RatCommand command1 = RatUtils.wrapCommand(this.currentDisplayCommand);
        String command2 = I18n.func_135052_a((String)command1.getTranslateName(), (Object[])new Object[0]);
        this.font.func_211126_b(command2, (float)(this.field_146999_f / 2 - this.font.func_78256_a(command2) / 2 + 36), 56.0f, 0xFFFFFF);
        int i = (this.width - 248) / 2;
        int j = (this.height - 166) / 2;
        if (mouseX > i + 116 && mouseX < i + 198 && mouseY > j + 22 && mouseY < j + 45) {
            commandText = I18n.func_135052_a((String)this.rat.getCommand().getTranslateDescription(), (Object[])new Object[0]);
            this.renderTooltip(Arrays.asList(commandText), mouseX - i - 40, mouseY - j + 10, this.font);
        }
        if (mouseX > i + 116 && mouseX < i + 198 && mouseY > j + 53 && mouseY < j + 69) {
            commandText = I18n.func_135052_a((String)command1.getTranslateDescription(), (Object[])new Object[0]);
            this.renderTooltip(Arrays.asList(commandText), mouseX - i - 40, mouseY - j + 10, this.font);
        }
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        int k = (this.width - this.field_146999_f) / 2;
        int l = (this.height - this.field_147000_g) / 2;
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE_BACKDROP);
        this.blit(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        GlStateManager.func_227626_N_();
        GuiRat.drawEntityOnScreen(k + 35, l + 60, 70, (float)(k + 51) - this.mousePosx, (float)(l + 75 - 50) - this.mousePosY, (LivingEntity)this.rat);
        GlStateManager.func_227627_O_();
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        GlStateManager.func_227688_c_((float)0.0f, (float)0.0f, (float)65.0f);
        this.blit(k, l, 0, 0, this.field_146999_f, this.field_147000_g);
        this.blit(k + 9, l + 20, this.rat.isMale() ? 176 : 192, 0, 16, this.height);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.mousePosx = mouseX;
        this.mousePosY = mouseY;
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }
}

