/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.rats.client;

import com.github.alexthe666.rats.RatsMod;
import com.github.alexthe666.rats.client.event.ClientEvents;
import com.github.alexthe666.rats.client.gui.GuiCheeseStaff;
import com.github.alexthe666.rats.client.gui.GuiRadiusStaff;
import com.github.alexthe666.rats.client.gui.GuiRat;
import com.github.alexthe666.rats.client.gui.RatsGuiRegistry;
import com.github.alexthe666.rats.client.model.ModelArcheologistHat;
import com.github.alexthe666.rats.client.model.ModelChefToque;
import com.github.alexthe666.rats.client.model.ModelFarmerHat;
import com.github.alexthe666.rats.client.model.ModelGhostPiratHat;
import com.github.alexthe666.rats.client.model.ModelHaloHat;
import com.github.alexthe666.rats.client.model.ModelMilitaryHat;
import com.github.alexthe666.rats.client.model.ModelPartyHat;
import com.github.alexthe666.rats.client.model.ModelPiperHat;
import com.github.alexthe666.rats.client.model.ModelPiratHat;
import com.github.alexthe666.rats.client.model.ModelPlagueDoctorMask;
import com.github.alexthe666.rats.client.model.ModelRatFez;
import com.github.alexthe666.rats.client.model.ModelSantaHat;
import com.github.alexthe666.rats.client.model.ModelTopHat;
import com.github.alexthe666.rats.client.particle.ParticleBlackDeath;
import com.github.alexthe666.rats.client.particle.ParticleFlea;
import com.github.alexthe666.rats.client.particle.ParticleLightning;
import com.github.alexthe666.rats.client.particle.ParticlePiratGhost;
import com.github.alexthe666.rats.client.particle.ParticleRatGhost;
import com.github.alexthe666.rats.client.particle.ParticleSaliva;
import com.github.alexthe666.rats.client.particle.ParticleUpgradeCombiner;
import com.github.alexthe666.rats.client.render.NuggetColorRegister;
import com.github.alexthe666.rats.client.render.RenderNothing;
import com.github.alexthe666.rats.client.render.entity.LayerPlague;
import com.github.alexthe666.rats.client.render.entity.RenderBlackDeath;
import com.github.alexthe666.rats.client.render.entity.RenderDutchrat;
import com.github.alexthe666.rats.client.render.entity.RenderDutchratSword;
import com.github.alexthe666.rats.client.render.entity.RenderFeralRatlantean;
import com.github.alexthe666.rats.client.render.entity.RenderGhostPirat;
import com.github.alexthe666.rats.client.render.entity.RenderGolemBeam;
import com.github.alexthe666.rats.client.render.entity.RenderIllagerPiper;
import com.github.alexthe666.rats.client.render.entity.RenderLaserBeam;
import com.github.alexthe666.rats.client.render.entity.RenderLaserPortal;
import com.github.alexthe666.rats.client.render.entity.RenderMarbledCheeseGolem;
import com.github.alexthe666.rats.client.render.entity.RenderNeoRatlantean;
import com.github.alexthe666.rats.client.render.entity.RenderPirat;
import com.github.alexthe666.rats.client.render.entity.RenderPiratBoat;
import com.github.alexthe666.rats.client.render.entity.RenderPlagueBeast;
import com.github.alexthe666.rats.client.render.entity.RenderPlagueDoctor;
import com.github.alexthe666.rats.client.render.entity.RenderPlagueShot;
import com.github.alexthe666.rats.client.render.entity.RenderRat;
import com.github.alexthe666.rats.client.render.entity.RenderRatArrow;
import com.github.alexthe666.rats.client.render.entity.RenderRatAutomatonMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatBeastMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatChickenMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatGolemMount;
import com.github.alexthe666.rats.client.render.entity.RenderRatKing;
import com.github.alexthe666.rats.client.render.entity.RenderRatShot;
import com.github.alexthe666.rats.client.render.entity.RenderRatfish;
import com.github.alexthe666.rats.client.render.entity.RenderRatlanteanRatbot;
import com.github.alexthe666.rats.client.render.entity.RenderRatlateanSpirit;
import com.github.alexthe666.rats.client.render.entity.RenderRattlingGun;
import com.github.alexthe666.rats.client.render.entity.RenderRattlingGunBullet;
import com.github.alexthe666.rats.client.render.entity.RenderThrownBlock;
import com.github.alexthe666.rats.client.render.tile.RatsTEISR;
import com.github.alexthe666.rats.client.render.tile.RenderAutoCurdler;
import com.github.alexthe666.rats.client.render.tile.RenderDutchratBell;
import com.github.alexthe666.rats.client.render.tile.RenderRatCageDecorated;
import com.github.alexthe666.rats.client.render.tile.RenderRatHole;
import com.github.alexthe666.rats.client.render.tile.RenderRatTrap;
import com.github.alexthe666.rats.client.render.tile.RenderRatlanteanAutomatonHead;
import com.github.alexthe666.rats.client.render.tile.RenderRatlantisPortal;
import com.github.alexthe666.rats.client.render.tile.RenderTrashCan;
import com.github.alexthe666.rats.client.render.tile.RenderUpgradeCombiner;
import com.github.alexthe666.rats.client.render.tile.RenderUpgradeSeparator;
import com.github.alexthe666.rats.server.CommonProxy;
import com.github.alexthe666.rats.server.blocks.RatsBlockRegistry;
import com.github.alexthe666.rats.server.entity.EntityRat;
import com.github.alexthe666.rats.server.entity.RatsEntityRegistry;
import com.github.alexthe666.rats.server.entity.tile.RatsTileEntityRegistry;
import com.github.alexthe666.rats.server.entity.tile.TileEntityAutoCurdler;
import com.github.alexthe666.rats.server.entity.tile.TileEntityRatTube;
import com.github.alexthe666.rats.server.items.RatsItemRegistry;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.Callable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.SpriteRenderer;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GrassColors;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@OnlyIn(value=Dist.CLIENT)
@Mod.EventBusSubscriber(modid="rats", value={Dist.CLIENT})
public class ClientProxy
extends CommonProxy {
    @OnlyIn(value=Dist.CLIENT)
    private static final RatsTEISR TEISR = new RatsTEISR();
    @OnlyIn(value=Dist.CLIENT)
    private static final ModelChefToque MODEL_CHEF_TOQUE = new ModelChefToque(1.0f);
    public static BlockPos refrencedPos;
    public static Direction refrencedFacing;
    public static EntityRat refrencedRat;
    public static TileEntity refrencedTileEntity;
    public static ItemStack refrencedItem;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerModels(ModelRegistryEvent event) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void preInit() {
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.RAT_CAGE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.RAT_CAGE_BREEDING_LANTERN, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.RAT_CAGE_DECORATED, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.RATGLOVE_FLOWER, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.RAT_TUBE_COLOR, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.AUTO_CURDLER, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.RAT_HOLE, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.MANHOLE, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.TRASH_CAN, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.RAT_ATTRACTOR, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.MARBLED_CHEESE_DIRT, (RenderType)RenderType.func_228643_e_());
        RenderTypeLookup.setRenderLayer((Block)RatsBlockRegistry.MARBLED_CHEESE_GRASS, (RenderType)RenderType.func_228643_e_());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void init() {
        RatsGuiRegistry.register();
        MinecraftForge.EVENT_BUS.register((Object)new ClientEvents());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::onBlockColors);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ClientProxy::onItemColors);
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT, manager -> new RenderRat());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_SPAWNER, manager -> new RenderNothing());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PIED_PIPER, manager -> new RenderIllagerPiper());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATLANTEAN_SPIRIT, manager -> new RenderRatlateanSpirit(false));
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATLANTEAN_FLAME, manager -> new SpriteRenderer(manager, Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATLANTEAN_AUTOMATON, manager -> new RenderMarbledCheeseGolem());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATLANTEAN_AUTOMATON_BEAM, manager -> new RenderGolemBeam());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.FERAL_RATLANTEAN, manager -> new RenderFeralRatlantean());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.NEO_RATLANTEAN, manager -> new RenderNeoRatlantean());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.LASER_BEAM, manager -> new RenderLaserBeam());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.LASER_PORTAL, manager -> new RenderLaserPortal());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.THROWN_BLOCK, manager -> new RenderThrownBlock());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.VIAL_OF_SENTIENCE, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PIRAT_BOAT, manager -> new RenderPiratBoat());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.CHEESE_CANNONBALL, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PLAGUE_DOCTOR, manager -> new RenderPlagueDoctor());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PURIFYING_LIQUID, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.BLACK_DEATH, manager -> new RenderBlackDeath());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PLAGUE_CLOUD, manager -> new RenderRatlateanSpirit(true));
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PLAGUE_BEAST, manager -> new RenderPlagueBeast());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PLAGUE_SHOT, manager -> new RenderPlagueShot());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_CAPTURE_NET, manager -> new SpriteRenderer(Minecraft.func_71410_x().func_175598_ae(), Minecraft.func_71410_x().func_175599_af()));
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_DRAGON_FIRE, manager -> new RenderNothing());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_ARROW, manager -> new RenderRatArrow());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.DUTCHRAT, manager -> new RenderDutchrat());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.DUTCHRAT_SWORD, manager -> new RenderDutchratSword());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATFISH, manager -> new RenderRatfish());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATTLING_GUN, manager -> new RenderRattlingGun());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATTLING_GUN_BULLET, manager -> new RenderRattlingGunBullet());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RATLANTEAN_RATBOT, manager -> new RenderRatlanteanRatbot());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_MOUNT_GOLEM, manager -> new RenderRatGolemMount());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_MOUNT_CHICKEN, manager -> new RenderRatChickenMount());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_MOUNT_BEAST, manager -> new RenderRatBeastMount());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.PIRAT, manager -> new RenderPirat());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_MOUNT_AUTOMATON, manager -> new RenderRatAutomatonMount());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.GHOST_PIRAT, manager -> new RenderGhostPirat());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_KING, manager -> new RenderRatKing());
        RenderingRegistry.registerEntityRenderingHandler(RatsEntityRegistry.RAT_SHOT, manager -> new RenderRatShot());
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.RAT_HOLE, manager -> new RenderRatHole((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.RAT_TRAP, manager -> new RenderRatTrap((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.AUTO_CURDLER, manager -> new RenderAutoCurdler((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.RATLANTIS_PORTAL, manager -> new RenderRatlantisPortal((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.RAT_CAGE_DECORATED, manager -> new RenderRatCageDecorated((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.RAT_CAGE_BREEDING_LANTERN, manager -> new RenderRatCageDecorated((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.UPGRADE_COMBINER, manager -> new RenderUpgradeCombiner((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.UPGRADE_SEPERATOR, manager -> new RenderUpgradeSeparator((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.DUTCHRAT_BELL, manager -> new RenderDutchratBell((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.AUTOMATON_HEAD, manager -> new RenderRatlanteanAutomatonHead((TileEntityRendererDispatcher)manager));
        ClientRegistry.bindTileEntityRenderer(RatsTileEntityRegistry.TRASH_CAN, manager -> new RenderTrashCan((TileEntityRendererDispatcher)manager));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onBlockColors(ColorHandlerEvent.Block event) {
        RatsMod.LOGGER.info("loaded in block colorizer");
        event.getBlockColors().func_186722_a((state, worldIn, pos, colorIn) -> {
            int meta = 0;
            if (worldIn.func_175625_s(pos) instanceof TileEntityRatTube) {
                TileEntityRatTube tube = (TileEntityRatTube)worldIn.func_175625_s(pos);
                meta = tube.getColor();
            }
            DyeColor color = DyeColor.func_196056_a((int)meta);
            return color.func_196060_f();
        }, new Block[]{RatsBlockRegistry.RAT_TUBE_COLOR});
        event.getBlockColors().func_186722_a((state, worldIn, pos, colorIn) -> worldIn != null && pos != null ? BiomeColors.func_228361_b_((ILightReader)worldIn, (BlockPos)pos) : GrassColors.func_77480_a((double)0.5, (double)1.0), new Block[]{RatsBlockRegistry.MARBLED_CHEESE_GRASS});
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void onItemColors(ColorHandlerEvent.Item event) {
        RatsMod.LOGGER.info("loaded in item colorizer");
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> GrassColors.func_77480_a((double)0.5, (double)1.0), new IItemProvider[]{Item.func_150898_a((Block)RatsBlockRegistry.MARBLED_CHEESE_GRASS)});
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            int meta = 0;
            for (int i = 0; i < RatsItemRegistry.RAT_TUBES.length; ++i) {
                if (p_getColor_1_.func_77973_b() != RatsItemRegistry.RAT_TUBES[i]) continue;
                meta = i;
                break;
            }
            DyeColor color = DyeColor.func_196056_a((int)meta);
            return color.func_196060_f();
        }, (IItemProvider[])RatsItemRegistry.RAT_TUBES);
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            int meta = 0;
            for (int i = 0; i < RatsItemRegistry.RAT_IGLOOS.length; ++i) {
                if (p_getColor_1_.func_77973_b() != RatsItemRegistry.RAT_IGLOOS[i]) continue;
                meta = i;
            }
            DyeColor color = DyeColor.func_196056_a((int)meta);
            return color.func_196060_f();
        }, (IItemProvider[])RatsItemRegistry.RAT_IGLOOS);
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            if (p_getColor_2_ == 0) {
                int meta = 0;
                for (int i = 0; i < RatsItemRegistry.RAT_HAMMOCKS.length; ++i) {
                    if (p_getColor_1_.func_77973_b() != RatsItemRegistry.RAT_HAMMOCKS[i]) continue;
                    meta = i;
                }
                DyeColor color = DyeColor.func_196056_a((int)meta);
                return color.func_196060_f();
            }
            return -1;
        }, (IItemProvider[])RatsItemRegistry.RAT_HAMMOCKS);
        event.getItemColors().func_199877_a((p_getColor_1_, p_getColor_2_) -> {
            if (p_getColor_2_ == 1) {
                return NuggetColorRegister.getNuggetColor(p_getColor_1_);
            }
            return -1;
        }, new IItemProvider[]{RatsItemRegistry.RAT_NUGGET_ORE});
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void postInit() {
        EntityRenderer render;
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().field_78729_o.entrySet()) {
            render = (EntityRenderer)entry.getValue();
            if (!(render instanceof LivingRenderer)) continue;
            ((LivingRenderer)render).func_177094_a(new LayerPlague((LivingRenderer)render));
        }
        for (Map.Entry entry : Minecraft.func_71410_x().func_175598_ae().getSkinMap().entrySet()) {
            render = (PlayerRenderer)entry.getValue();
            render.func_177094_a(new LayerPlague(render));
        }
        Field renderingRegistryField = ObfuscationReflectionHelper.findField(RenderingRegistry.class, (String)"INSTANCE");
        Field entityRendersField = ObfuscationReflectionHelper.findField(RenderingRegistry.class, (String)"entityRenderers");
        RenderingRegistry registry = null;
        try {
            Field modifier = Field.class.getDeclaredField("modifiers");
            modifier.setAccessible(true);
            registry = (RenderingRegistry)renderingRegistryField.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (registry != null) {
            Map entityRenders = null;
            try {
                Field modifier1 = Field.class.getDeclaredField("modifiers");
                modifier1.setAccessible(true);
                entityRenders = (Map)entityRendersField.get(registry);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (entityRenders != null) {
                for (Map.Entry entry : entityRenders.entrySet()) {
                    if (entry.getValue() == null) continue;
                    try {
                        EntityRenderer render2 = ((IRenderFactory)entry.getValue()).createRenderFor(Minecraft.func_71410_x().func_175598_ae());
                        if (render2 == null || !(render2 instanceof LivingRenderer) || !LivingEntity.class.isAssignableFrom((Class)entry.getKey())) continue;
                        ((LivingRenderer)render2).func_177094_a(new LayerPlague((LivingRenderer)render2));
                    }
                    catch (NullPointerException exp) {
                        RatsMod.LOGGER.warn("Rats: Could not apply plague render layer to " + ((Class)entry.getKey()).getSimpleName() + ", someone isn't registering their renderer properly... <.<");
                    }
                }
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderNameplates() {
        return Minecraft.func_71410_x().field_71462_r == null || !(Minecraft.func_71410_x().field_71462_r instanceof GuiRat) && !(Minecraft.func_71410_x().field_71462_r instanceof GuiCheeseStaff);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Object getArmorModel(int index) {
        if (index == 0) {
            return new ModelChefToque(1.0f);
        }
        if (index == 1) {
            return new ModelPiperHat(1.0f);
        }
        if (index == 2) {
            return new ModelPiratHat(1.0f);
        }
        if (index == 3) {
            return new ModelArcheologistHat(1.0f);
        }
        if (index == 4) {
            return new ModelFarmerHat(1.0f);
        }
        if (index == 5) {
            return new ModelPlagueDoctorMask(1.0f);
        }
        if (index == 6) {
            return new ModelRatFez(1.0f);
        }
        if (index == 7) {
            return new ModelTopHat(1.0f);
        }
        if (index == 8) {
            return new ModelSantaHat(1.0f);
        }
        if (index == 9) {
            return new ModelGhostPiratHat(1.0f);
        }
        if (index == 10) {
            return new ModelHaloHat(0.5f);
        }
        if (index == 11) {
            return new ModelPartyHat(0.5f);
        }
        return new ModelMilitaryHat(1.2f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntityRat getRefrencedRat() {
        return refrencedRat;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setRefrencedRat(EntityRat rat) {
        refrencedRat = rat;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setCheeseStaffContext(BlockPos pos, Direction facing) {
        refrencedPos = pos;
        refrencedFacing = facing;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addParticle(String name, double x, double y, double z, double motX, double motY, double motZ) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world == null) {
            return;
        }
        if (name.equals("rat_ghost")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleRatGhost((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("pirat_ghost")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticlePiratGhost((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("rat_lightning")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleLightning((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("flea")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleFlea((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("upgrade_combiner")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleUpgradeCombiner((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
        if (name.equals("saliva")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSaliva((World)world, x, y, z, (Fluid)Fluids.field_204546_a));
        }
        if (name.equals("black_death")) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleBlackDeath((World)world, x, y, z, (float)motX, (float)motY, (float)motZ));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TileEntity getRefrencedTE() {
        return refrencedTileEntity;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setRefrencedTE(TileEntity te) {
        refrencedTileEntity = te;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemStack getRefrencedItem() {
        return refrencedItem;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setRefrencedItem(ItemStack stack) {
        refrencedItem = stack;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public World getWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketAutoCurdlerFluid(long blockPos, FluidStack fluid) {
        BlockPos pos = BlockPos.func_218283_e((long)blockPos);
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (world != null && world.func_175625_s(pos) instanceof TileEntityAutoCurdler) {
            TileEntityAutoCurdler table = (TileEntityAutoCurdler)world.func_175625_s(pos);
            table.tank.setFluid(fluid);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketCheeseStaffRat(int entityId, boolean clear) {
        Entity e = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(entityId);
        if (e instanceof EntityRat) {
            this.setRefrencedRat((EntityRat)e);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void handlePacketUpdateTileSlots(long blockPos, CompoundNBT tag) {
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = BlockPos.func_218283_e((long)blockPos);
        if (world.func_175625_s(pos) != null) {
            TileEntity te = world.func_175625_s(pos);
            te.func_145839_a(tag);
        }
    }

    @Override
    public void setupTEISR(Item.Properties props) {
        props.setISTER(ClientProxy::getTEISR);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Callable<ItemStackTileEntityRenderer> getTEISR() {
        return RatsTEISR::new;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openCheeseStaffGui() {
        if (refrencedRat != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiCheeseStaff(refrencedRat));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void openRadiusStaffGui() {
        if (refrencedRat != null) {
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiRadiusStaff(refrencedRat));
        }
    }
}

