/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.asm.consumers;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import me.jellysquid.mods.lithium.asm.ASMUtil;
import me.jellysquid.mods.lithium.asm.FieldRef;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;

public class FieldAccessTransformer
implements Consumer<ClassNode> {
    private final List<FieldRef> fields;
    private final int access;

    public FieldAccessTransformer(int access, FieldRef ... fields) {
        this.access = access;
        this.fields = Arrays.asList(fields);
    }

    @Override
    public void accept(ClassNode classNode) {
        for (FieldNode node : ASMUtil.matchFields(classNode, this.fields)) {
            node.access = this.access;
        }
        ASMUtil.LOGGER.debug("Transformed access flags of {} fields in {}", (Object)this.fields.size(), (Object)classNode.name);
    }
}

