/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.config.MRConfig;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.integration.XPCollection;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.compiled.CompiledModule;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CompiledVacuumModule
extends CompiledModule {
    public static final String NBT_XP_FLUID_TYPE = "XPFluidType";
    public static final String NBT_AUTO_EJECT = "AutoEject";
    private final boolean fastPickup = this.getAugmentCount((Item)ModItems.FAST_PICKUP_AUGMENT.get()) > 0;
    private final boolean xpMode = this.getAugmentCount((Item)ModItems.XP_VACUUM_AUGMENT.get()) > 0;
    private final boolean autoEjecting;
    private final FluidStack xpJuiceStack;
    private TileEntity fluidReceiver = null;
    private Direction fluidReceiverFace = null;
    private int xpBuffered = 0;
    private final XPCollection.XPCollectionType xpCollectionType;

    public CompiledVacuumModule(TileEntityItemRouter router, ItemStack stack) {
        super(router, stack);
        CompoundNBT compound = stack.func_179543_a("modularrouters");
        if (compound != null) {
            this.xpCollectionType = XPCollection.XPCollectionType.values()[compound.func_74762_e(NBT_XP_FLUID_TYPE)];
            this.autoEjecting = compound.func_74767_n(NBT_AUTO_EJECT);
            if (this.xpMode) {
                Fluid xpFluid = this.xpCollectionType.getFluid();
                FluidStack fluidStack = this.xpJuiceStack = xpFluid == Fluids.field_204541_a ? FluidStack.EMPTY : new FluidStack(xpFluid, 1000);
                if (router != null) {
                    this.findFluidReceiver(router);
                }
            } else {
                this.xpJuiceStack = FluidStack.EMPTY;
            }
        } else {
            this.xpCollectionType = XPCollection.XPCollectionType.BOTTLE_O_ENCHANTING;
            this.autoEjecting = false;
            this.xpJuiceStack = FluidStack.EMPTY;
        }
    }

    @Override
    public boolean execute(@Nonnull TileEntityItemRouter router) {
        if (this.xpMode) {
            return this.handleXpMode(router);
        }
        return this.handleItemMode(router);
    }

    @Override
    public void onNeighbourChange(TileEntityItemRouter router) {
        this.findFluidReceiver(router);
    }

    private void findFluidReceiver(TileEntityItemRouter router) {
        if (!this.xpMode || this.xpJuiceStack.isEmpty()) {
            return;
        }
        this.fluidReceiver = null;
        for (Direction face : Direction.values()) {
            TileEntity te = router.func_145831_w().func_175625_s(router.func_174877_v().func_177972_a(face));
            if (te != null) {
                te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, face.func_176734_d()).ifPresent(handler -> {
                    if (handler.fill(this.xpJuiceStack, IFluidHandler.FluidAction.SIMULATE) > 0) {
                        this.fluidReceiver = te;
                        this.fluidReceiverFace = face.func_176734_d();
                    }
                });
            }
            if (this.fluidReceiver != null) break;
        }
    }

    private boolean handleItemMode(TileEntityItemRouter router) {
        if (router.isBufferFull()) {
            return false;
        }
        ItemStack bufferStack = router.getBuffer().getStackInSlot(0);
        BlockPos centrePos = this.getTarget().gPos.func_218180_b();
        int range = this.getRange();
        List items = router.func_145831_w().func_217357_a(ItemEntity.class, new AxisAlignedBB(centrePos.func_177982_a(-range, -range, -range), centrePos.func_177982_a(range + 1, range + 1, range + 1)));
        int toPickUp = this.getItemsPerTick(router);
        for (ItemEntity item : items) {
            if (!item.func_70089_S() || !this.fastPickup && item.func_174874_s()) continue;
            ItemStack stackOnGround = item.func_92059_d();
            if (!bufferStack.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)stackOnGround, (ItemStack)bufferStack) || !this.getFilter().test(stackOnGround)) continue;
            int inRouter = bufferStack.func_190916_E();
            int spaceInRouter = this.getRegulationAmount() > 0 ? Math.min(stackOnGround.func_77976_d(), this.getRegulationAmount()) - inRouter : stackOnGround.func_77976_d() - inRouter;
            ItemStack vacuumed = stackOnGround.func_77979_a(Math.min(this.getItemsPerTick(router), spaceInRouter));
            ItemStack excess = router.insertBuffer(vacuumed);
            int remaining = excess == null ? 0 : excess.func_190916_E();
            stackOnGround.func_190917_f(remaining);
            int inserted = vacuumed.func_190916_E() - remaining;
            toPickUp -= inserted;
            if (stackOnGround.func_190926_b()) {
                item.func_70106_y();
            }
            if (inserted > 0 && MRConfig.Common.Module.vacuumParticles && router.getUpgradeCount((Item)ModItems.MUFFLER_UPGRADE.get()) < 2) {
                ((ServerWorld)router.func_145831_w()).func_195598_a((IParticleData)ParticleTypes.field_197613_f, item.func_226277_ct_(), item.func_226278_cu_() + 0.25, item.func_226281_cx_(), 2, 0.0, 0.0, 0.0, 0.0);
            }
            if (toPickUp > 0) continue;
            break;
        }
        return toPickUp < this.getItemsPerTick(router);
    }

    private boolean handleXpMode(TileEntityItemRouter router) {
        ExperienceOrbEntity orb;
        int spaceForXp;
        BlockPos centrePos = this.getTarget().gPos.func_218180_b();
        int range = this.getRange();
        List orbs = router.func_145831_w().func_217357_a(ExperienceOrbEntity.class, new AxisAlignedBB(centrePos).func_186662_g((double)range));
        if (orbs.isEmpty()) {
            return false;
        }
        ItemStack inRouterStack = router.getBufferItemStack();
        LazyOptional lazyFluidHandler = LazyOptional.empty();
        if (this.xpCollectionType.isSolid()) {
            if (!inRouterStack.func_190926_b() && !ItemHandlerHelper.canItemStacksStack((ItemStack)inRouterStack, (ItemStack)this.xpCollectionType.getIcon())) {
                return false;
            }
            spaceForXp = (inRouterStack.func_77976_d() - inRouterStack.func_190916_E()) * this.xpCollectionType.getXpRatio();
        } else {
            if (this.fluidReceiver != null && this.fluidReceiver.func_145837_r()) {
                this.findFluidReceiver(router);
            }
            lazyFluidHandler = this.fluidReceiver != null ? this.fluidReceiver.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.fluidReceiverFace) : router.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY);
            spaceForXp = (Integer)lazyFluidHandler.map(this::findSpaceForXPFluid).orElse((Object)0);
        }
        if (spaceForXp == 0) {
            return false;
        }
        int initialSpaceForXp = spaceForXp;
        Iterator iterator = orbs.iterator();
        while (iterator.hasNext() && (orb = (ExperienceOrbEntity)iterator.next()).func_70526_d() <= spaceForXp) {
            if (this.xpCollectionType.isSolid()) {
                this.xpBuffered += orb.func_70526_d();
                if (this.xpBuffered > this.xpCollectionType.getXpRatio()) {
                    int count = this.xpBuffered / this.xpCollectionType.getXpRatio();
                    ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)this.xpCollectionType.getIcon(), (int)count);
                    ItemStack excess = router.insertBuffer(stack);
                    this.xpBuffered -= stack.func_190916_E() * this.xpCollectionType.getXpRatio();
                    if (!excess.func_190926_b()) {
                        InventoryUtils.dropItems(router.func_145831_w(), router.func_174877_v(), excess);
                    }
                }
            } else {
                boolean filledAll = (Boolean)lazyFluidHandler.map(xpHandler -> this.doFluidXPFill(orb, (IFluidHandler)xpHandler)).orElse((Object)false);
                if (!filledAll) {
                    spaceForXp = 0;
                }
            }
            spaceForXp -= orb.func_70526_d();
            orb.func_70106_y();
        }
        return initialSpaceForXp - spaceForXp > 0;
    }

    private boolean doFluidXPFill(ExperienceOrbEntity orb, IFluidHandler xpHandler) {
        FluidStack xpStack = new FluidStack(this.xpJuiceStack.getFluid(), orb.func_70526_d() * this.xpCollectionType.getXpRatio() + this.xpBuffered);
        int filled = xpHandler.fill(xpStack, IFluidHandler.FluidAction.EXECUTE);
        if (filled < xpStack.getAmount()) {
            this.xpBuffered = xpStack.getAmount() - filled;
            return false;
        }
        this.xpBuffered = 0;
        return true;
    }

    private int findSpaceForXPFluid(IFluidHandler xpHandler) {
        int space = 0;
        for (int idx = 0; idx < xpHandler.getTanks(); ++idx) {
            FluidStack fluidStack;
            if (!xpHandler.isFluidValid(idx, this.xpJuiceStack) || !(fluidStack = xpHandler.getFluidInTank(idx)).isEmpty() && fluidStack.getFluid() != this.xpCollectionType.getFluid()) continue;
            space += (xpHandler.getTankCapacity(idx) - fluidStack.getAmount()) / this.xpCollectionType.getXpRatio();
        }
        return space;
    }

    @Override
    public List<ModuleTarget> setupTargets(TileEntityItemRouter router, ItemStack stack) {
        if (router == null) {
            return null;
        }
        ItemModule.RelativeDirection dir = this.getDirection();
        int offset = dir == ItemModule.RelativeDirection.NONE ? 0 : this.getRange() + 1;
        Direction facing = router.getAbsoluteFacing(dir);
        GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)router.func_145831_w().func_201675_m().func_186058_p(), (BlockPos)router.func_174877_v().func_177967_a(facing, offset));
        return Collections.singletonList(new ModuleTarget(gPos, facing));
    }

    public XPCollection.XPCollectionType getXPCollectionType() {
        return this.xpCollectionType;
    }

    public boolean isAutoEjecting() {
        return this.autoEjecting;
    }

    public boolean isXpMode() {
        return this.xpMode;
    }
}

