/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.logic.compiled;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.tile.TileEntityItemRouter;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.item.augment.ItemAugment;
import me.desht.modularrouters.item.module.IRangedModule;
import me.desht.modularrouters.item.module.ItemModule;
import me.desht.modularrouters.logic.ModuleTarget;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.util.BlockUtil;
import me.desht.modularrouters.util.CountedItemStacks;
import me.desht.modularrouters.util.ModuleHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.GlobalPos;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.Validate;

public abstract class CompiledModule {
    private final Filter filter;
    private final ItemModule module;
    private final ItemModule.RelativeDirection direction;
    private final List<ModuleTarget> targets;
    private final RouterRedstoneBehaviour behaviour;
    private final boolean termination;
    private final Direction facing;
    private final Direction routerFacing;
    private final int regulationAmount;
    private final ItemAugment.AugmentCounter augmentCounter;
    private final int range;
    private final int rangeSquared;
    private int lastMatchPos = 0;

    CompiledModule(@Nullable TileEntityItemRouter router, ItemStack stack) {
        Validate.isTrue((boolean)(stack.func_77973_b() instanceof ItemModule), (String)("expected module item, got " + stack), (Object[])new Object[0]);
        this.module = (ItemModule)stack.func_77973_b();
        this.augmentCounter = new ItemAugment.AugmentCounter(stack);
        this.direction = ModuleHelper.getDirectionFromNBT(stack);
        this.range = this.module instanceof IRangedModule ? ((IRangedModule)((Object)this.module)).getCurrentRange(this.getRangeModifier()) : 0;
        this.rangeSquared = this.range * this.range;
        this.targets = this.setupTargets(router, stack);
        this.filter = new Filter(stack);
        this.termination = ModuleHelper.terminates(stack);
        this.behaviour = ModuleHelper.getRedstoneBehaviour(stack);
        this.regulationAmount = ModuleHelper.getRegulatorAmount(stack);
        this.facing = router == null ? null : router.getAbsoluteFacing(this.direction);
        this.routerFacing = router == null ? null : router.getAbsoluteFacing(ItemModule.RelativeDirection.FRONT);
    }

    public abstract boolean execute(@Nonnull TileEntityItemRouter var1);

    Filter getFilter() {
        return this.filter;
    }

    public ItemModule.RelativeDirection getDirection() {
        return this.direction;
    }

    ModuleTarget getTarget() {
        return this.targets == null || this.targets.isEmpty() ? null : this.targets.get(0);
    }

    List<ModuleTarget> getTargets() {
        return this.targets;
    }

    public boolean hasTarget() {
        return this.targets != null && !this.targets.isEmpty();
    }

    public boolean termination() {
        return this.termination;
    }

    RouterRedstoneBehaviour getRedstoneBehaviour() {
        return this.behaviour;
    }

    public int getRegulationAmount() {
        return this.augmentCounter.getAugmentCount((Item)ModItems.REGULATOR_AUGMENT.get()) > 0 ? this.regulationAmount : 0;
    }

    int getAugmentCount(Item augmentType) {
        return this.augmentCounter.getAugmentCount(augmentType);
    }

    Direction getFacing() {
        return this.facing;
    }

    public void onCompiled(TileEntityItemRouter router) {
        if (this.behaviour == RouterRedstoneBehaviour.PULSE) {
            router.setHasPulsedModules(true);
        }
    }

    public void cleanup(TileEntityItemRouter router) {
    }

    private int getLastMatchPos(int offset, int size) {
        int pos = this.lastMatchPos + offset;
        if (pos >= size) {
            pos -= size;
        }
        return pos;
    }

    private void setLastMatchPos(int lastMatchPos) {
        this.lastMatchPos = lastMatchPos;
    }

    List<ModuleTarget> setupTargets(TileEntityItemRouter router, ItemStack stack) {
        if (router == null || this.module.isDirectional() && this.direction == ItemModule.RelativeDirection.NONE) {
            return null;
        }
        Direction facing = router.getAbsoluteFacing(this.direction);
        BlockPos pos = router.func_174877_v().func_177972_a(facing);
        String blockName = BlockUtil.getBlockName(router.func_145831_w(), pos);
        GlobalPos gPos = GlobalPos.func_218179_a((DimensionType)router.func_145831_w().func_201675_m().func_186058_p(), (BlockPos)pos);
        return Collections.singletonList(new ModuleTarget(gPos, facing.func_176734_d(), blockName));
    }

    int getItemsPerTick(TileEntityItemRouter router) {
        int n = this.augmentCounter.getAugmentCount((Item)ModItems.STACK_AUGMENT.get());
        return n > 0 ? Math.min(1 << n, 64) : router.getItemsPerTick();
    }

    ItemStack transferToRouter(IItemHandler handler, TileEntityItemRouter router) {
        CountedItemStacks count = this.getRegulationAmount() > 0 ? new CountedItemStacks(handler) : null;
        ItemStack wanted = this.findItemToPull(router, handler, this.getItemsPerTick(router), count);
        if (wanted.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack transferred = ItemStack.field_190927_a;
        for (int i = 0; i < handler.getSlots(); ++i) {
            int pos = this.getLastMatchPos(i, handler.getSlots());
            ItemStack toPull = handler.extractItem(pos, wanted.func_190916_E(), true);
            if (toPull.func_190926_b()) {
                this.setLastMatchPos((pos + 1) % handler.getSlots());
                return ItemStack.field_190927_a;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)wanted, (ItemStack)toPull)) continue;
            ItemStack notInserted = router.insertBuffer(toPull);
            int inserted = toPull.func_190916_E() - notInserted.func_190916_E();
            transferred = handler.extractItem(pos, inserted, false);
            wanted.func_190918_g(inserted);
            if (!wanted.func_190926_b() && !router.isBufferFull()) continue;
            this.setLastMatchPos(handler.getStackInSlot(pos).func_190926_b() ? (pos + 1) % handler.getSlots() : pos);
            return transferred;
        }
        return transferred;
    }

    private ItemStack findItemToPull(TileEntityItemRouter router, IItemHandler handler, int nToTake, CountedItemStacks count) {
        ItemStack stackInRouter = router.peekBuffer(1);
        if (!stackInRouter.func_190926_b() && this.getFilter().test(stackInRouter)) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)stackInRouter, (int)nToTake);
        }
        if (stackInRouter.func_190926_b()) {
            for (int i = 0; i < handler.getSlots(); ++i) {
                int pos = this.getLastMatchPos(i, handler.getSlots());
                ItemStack stack = handler.getStackInSlot(pos);
                if (!this.getFilter().test(stack) || count != null && count.getInt(stack) - nToTake < this.getRegulationAmount()) continue;
                this.setLastMatchPos(pos);
                return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)nToTake);
            }
        }
        return ItemStack.field_190927_a;
    }

    public ModuleTarget getEffectiveTarget(TileEntityItemRouter router) {
        return this.getTarget();
    }

    public boolean shouldRun(boolean powered, boolean pulsed) {
        return this.getRedstoneBehaviour().shouldRun(powered, pulsed);
    }

    boolean isRegulationOK(TileEntityItemRouter router, boolean inbound) {
        if (this.regulationAmount == 0) {
            return true;
        }
        int items = router.getBufferItemStack().func_190916_E();
        return inbound && this.regulationAmount > items || !inbound && this.regulationAmount < items;
    }

    int getRange() {
        return this.range;
    }

    int getRangeSquared() {
        return this.rangeSquared;
    }

    private int getRangeModifier() {
        return this.getAugmentCount((Item)ModItems.RANGE_UP_AUGMENT.get()) - this.getAugmentCount((Item)ModItems.RANGE_DOWN_AUGMENT.get());
    }

    Direction getRouterFacing() {
        return this.routerFacing;
    }

    public void onNeighbourChange(TileEntityItemRouter router) {
    }
}

