/*
 * Decompiled with CFR 0.152.
 */
package edivad.dimstorage.compat.top;

import edivad.dimstorage.compat.top.TOPElement;
import edivad.dimstorage.tile.TileEntityDimTank;
import edivad.dimstorage.tools.utils.FluidUtils;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fluids.FluidStack;

public class FluidElement
extends TOPElement {
    public static int ID;
    @Nonnull
    protected final FluidStack fluid;
    protected final int capacity;
    protected final int colorLiquid;

    protected FluidElement(@Nonnull FluidStack fluid, int capacity, int colorLiquid) {
        super(-16777216, 0xFFFFFF);
        this.fluid = fluid;
        this.capacity = capacity;
        this.colorLiquid = colorLiquid;
    }

    public FluidElement(@Nonnull TileEntityDimTank tile, int capacity) {
        this(tile.liquidState.serverLiquid, capacity, FluidUtils.getLiquidColorWithBiome(tile.liquidState.serverLiquid, tile));
    }

    public FluidElement(PacketBuffer buf) {
        this(buf.readFluidStack(), buf.readInt(), buf.readInt());
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeFluidStack(this.fluid);
        buf.writeInt(this.capacity);
        buf.writeInt(this.colorLiquid);
    }

    @Override
    public int getScaledLevel(int level) {
        if (this.capacity == 0 || this.fluid.getAmount() == Integer.MAX_VALUE) {
            return level;
        }
        return this.fluid.getAmount() * level / this.capacity;
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.fluid.isEmpty() ? null : FluidUtils.getFluidTexture(this.fluid);
    }

    @Override
    public ITextComponent getText() {
        String liquidText = this.fluid.getDisplayName().func_150254_d();
        int amount = this.fluid.getAmount();
        return new StringTextComponent(String.format("%s: %dmB", liquidText, amount));
    }

    @Override
    protected boolean applyRenderColor() {
        FluidUtils.color(this.colorLiquid);
        return true;
    }

    public int getID() {
        return ID;
    }
}

