/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.items;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import xreliquary.handler.CommonEventHandler;
import xreliquary.handler.HandlerPriority;
import xreliquary.handler.IPlayerDeathHandler;
import xreliquary.init.ModItems;
import xreliquary.items.ItemBase;
import xreliquary.network.PacketHandler;
import xreliquary.network.SpawnAngelheartVialParticlesPacket;
import xreliquary.reference.Settings;
import xreliquary.util.EntityHelper;
import xreliquary.util.InventoryHelper;

public class AngelheartVialItem
extends ItemBase {
    public AngelheartVialItem() {
        super("angelheart_vial", new Item.Properties());
        CommonEventHandler.registerPlayerDeathHandler(new IPlayerDeathHandler(){

            @Override
            public boolean canApply(PlayerEntity player, LivingDeathEvent event) {
                return InventoryHelper.playerHasItem(player, ModItems.ANGELHEART_VIAL);
            }

            @Override
            public boolean apply(PlayerEntity player, LivingDeathEvent event) {
                AngelheartVialItem.decreaseAngelHeartByOne(player);
                PacketHandler.sendToClient((ServerPlayerEntity)player, new SpawnAngelheartVialParticlesPacket());
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), SoundEvents.field_187561_bM, SoundCategory.NEUTRAL, 1.0f, player.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                float amountHealed = player.func_110138_aP() * (float)((Integer)Settings.COMMON.items.angelHeartVial.healPercentageOfMaxLife.get()).intValue() / 100.0f;
                player.func_70606_j(amountHealed);
                if (Boolean.TRUE.equals(Settings.COMMON.items.angelHeartVial.removeNegativeStatus.get())) {
                    EntityHelper.removeNegativeStatusEffects((LivingEntity)player);
                }
                return true;
            }

            @Override
            public HandlerPriority getPriority() {
                return HandlerPriority.LOW;
            }
        });
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return new ItemStack((IItemProvider)ModItems.EMPTY_POTION_VIAL);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    private static void decreaseAngelHeartByOne(PlayerEntity player) {
        for (int slot = 0; slot < player.field_71071_by.field_70462_a.size(); ++slot) {
            if (((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_190926_b() || ((ItemStack)player.field_71071_by.field_70462_a.get(slot)).func_77973_b() != ModItems.ANGELHEART_VIAL) continue;
            player.field_71071_by.func_70298_a(slot, 1);
            return;
        }
    }
}

