/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adhooks.client;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.GameRendering;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.Rotation;
import com.endertech.minecraft.forge.math.Vect3d;
import com.endertech.minecraft.mods.adhooks.hook.HookShot;
import com.endertech.minecraft.mods.adhooks.hook.HookType;
import com.endertech.minecraft.mods.adhooks.items.Rope;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class HookShotRenderer
extends EntityRenderer<HookShot> {
    public HookShotRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void renderHook(HookShot hookShot, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        HookType hookType = hookShot.getHookType();
        Rotation shotRotation = hookShot.getRotation(partialTicks);
        double pixel = 0.0625;
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f + shotRotation.yaw));
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(shotRotation.pitch));
        if (hookType == HookType.WEB) {
            matrixStack.func_227861_a_(0.0, -0.1, 0.0);
        } else {
            matrixStack.func_227861_a_(-0.03125, 0.0, -0.4);
        }
        ItemStack hook = hookType == HookType.WEB ? Items.field_221672_ax.func_190903_i() : hookType.hook.func_190903_i();
        Minecraft.func_71410_x().func_175599_af().func_229110_a_(hook, ItemCameraTransforms.TransformType.GROUND, 0xF000F0, OverlayTexture.field_229196_a_, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }

    public void renderRope(HookShot hookShot, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        boolean shooterIsMe;
        if (hookShot == null) {
            return;
        }
        LivingEntity shooter = hookShot.getShooter();
        if (shooter == null) {
            return;
        }
        Vect3d launcherOffset = Vect3d.ZERO;
        Rotation shooterRotation = ForgeEntity.getRotation((Entity)shooter, (float)partialTicks);
        boolean bl = shooterIsMe = shooter == Minecraft.func_71410_x().field_71439_g;
        if (shooterIsMe) {
            switch (this.field_76990_c.field_78733_k.field_74320_O) {
                case 1: 
                case 2: {
                    launcherOffset = Vect3d.from((double)-0.1, (double)0.0, (double)0.0);
                    break;
                }
                default: {
                    launcherOffset = Vect3d.from((double)-0.6, (double)-0.6, (double)0.0);
                }
            }
        }
        launcherOffset = launcherOffset.rotateAroundX(-shooterRotation.pitch).rotateAroundY(-shooterRotation.yaw);
        Vect3d launcherPos = hookShot.getLauncherPosition(partialTicks).add(launcherOffset);
        Vect3d hookShotPos = hookShot.getCurPosition(partialTicks);
        Vect3d ropeVec = launcherPos.subtract(hookShotPos);
        HookType hookType = hookShot.getHookType();
        if (hookType.rope != null) {
            Rope rope = hookType.rope;
            float hookStrength = hookType.hook != null ? hookType.hook.strength : 0.0f;
            float tensionForce = hookShot.getTensionForce();
            float tensionFactor = CommonMath.notZero((double)hookStrength) && CommonMath.notZero((double)rope.elasticity) ? tensionForce / hookStrength : 0.0f;
            float ropeWidth = new FloatBounds(Rope.WIDTH_BOUNDS.getMin(), Float.valueOf(shooterIsMe ? rope.width : 4.0f)).approxDown(tensionFactor).floatValue();
            float sagging = hookShot.getSagging();
            Vect3d viewPos = Vect3d.from((Vec3d)this.field_76990_c.field_217783_c.func_216785_c());
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)matrixStack.func_227866_c_().func_227870_a_());
            GameRendering.enableSmoothLines();
            if (rope.color != null) {
                RenderSystem.color3f((float)rope.color.getRed().toFloat(), (float)rope.color.getGreen().toFloat(), (float)rope.color.getBlue().toFloat());
            }
            Vect3d fromPoint = Vect3d.ZERO;
            for (int i = 1; i <= rope.segmentsAmount; ++i) {
                float f = i;
                Objects.requireNonNull(rope);
                float ropeProgress = f / 16.0f;
                float sagHeight = MathHelper.func_76126_a((float)(ropeProgress * (float)Math.PI)) * sagging;
                Vect3d toPoint = Vect3d.from((double)(ropeVec.x * (double)ropeProgress), (double)(ropeVec.y * (double)ropeProgress - (double)sagHeight), (double)(ropeVec.z * (double)ropeProgress));
                float viewDistance = (float)viewPos.distance(hookShotPos.add(toPoint));
                float scale = CommonMath.notZero((double)viewDistance) ? 10.0f / viewDistance : 1.0f;
                float ropeWidthScaled = new FloatBounds(Rope.WIDTH_BOUNDS.getMin(), Float.valueOf(ropeWidth)).approxUp(scale).floatValue();
                GameRendering.line((float)ropeWidthScaled, (Vect3d)fromPoint, (Vect3d)toPoint);
                fromPoint = toPoint;
            }
            GameRendering.disableSmoothLines();
            RenderSystem.clearCurrentColor();
            RenderSystem.popMatrix();
        }
    }

    public void render(HookShot hookShot, float yaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        if (!hookShot.isHookingEntity()) {
            this.renderHook(hookShot, yaw, partialTicks, matrixStack, buffer, packedLight);
        }
        this.renderRope(hookShot, yaw, partialTicks, matrixStack, buffer, packedLight);
        super.func_225623_a_((Entity)hookShot, yaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getEntityTexture(HookShot entity) {
        return AtlasTexture.field_110575_b;
    }
}

