/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.u_team_core.api.dye;

import info.u_team.u_team_core.api.dye.DyeableItemsRegistry;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;

public interface IDyeableItem {
    default public <T extends Item> void addColoredItem(T item) {
        DyeableItemsRegistry.addItem(item);
    }

    default public boolean hasColor(ItemStack stack) {
        CompoundNBT compound = stack.func_179543_a("display");
        return compound != null && compound.func_150297_b("color", 99);
    }

    default public int getColor(ItemStack stack) {
        CompoundNBT compound = stack.func_179543_a("display");
        return compound != null && compound.func_150297_b("color", 99) ? compound.func_74762_e("color") : this.getDefaultColor();
    }

    default public void removeColor(ItemStack stack) {
        CompoundNBT compound = stack.func_179543_a("display");
        if (compound != null && compound.func_74764_b("color")) {
            compound.func_82580_o("color");
        }
    }

    default public void setColor(ItemStack stack, int color) {
        stack.func_190925_c("display").func_74768_a("color", color);
    }

    default public int getDefaultColor() {
        return 10511680;
    }

    public static ItemStack colorStack(ItemStack stack, List<DyeColor> dyeList) {
        if (!(stack.func_77973_b() instanceof IDyeableItem)) {
            return ItemStack.field_190927_a;
        }
        IDyeableItem dyeableItem = (IDyeableItem)stack.func_77973_b();
        ItemStack dyedStack = stack.func_77946_l();
        dyedStack.func_190920_e(1);
        int[] rbgItemSum = new int[3];
        int mostIntenseChannelSum = 0;
        int colorItemSum = 0;
        if (dyeableItem.hasColor(dyedStack)) {
            int color = dyeableItem.getColor(dyedStack);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            mostIntenseChannelSum = (int)((float)mostIntenseChannelSum + Math.max(red, Math.max(green, blue)) * 255.0f);
            rbgItemSum[0] = (int)((float)rbgItemSum[0] + red * 255.0f);
            rbgItemSum[1] = (int)((float)rbgItemSum[1] + green * 255.0f);
            rbgItemSum[2] = (int)((float)rbgItemSum[2] + blue * 255.0f);
            ++colorItemSum;
        }
        for (DyeColor dye : dyeList) {
            float[] colorComponents = dye.func_193349_f();
            int red = (int)(colorComponents[0] * 255.0f);
            int green = (int)(colorComponents[1] * 255.0f);
            int blue = (int)(colorComponents[2] * 255.0f);
            mostIntenseChannelSum += Math.max(red, Math.max(green, blue));
            rbgItemSum[0] = rbgItemSum[0] + red;
            rbgItemSum[1] = rbgItemSum[1] + green;
            rbgItemSum[2] = rbgItemSum[2] + blue;
            ++colorItemSum;
        }
        int red = rbgItemSum[0] / colorItemSum;
        int green = rbgItemSum[1] / colorItemSum;
        int blue = rbgItemSum[2] / colorItemSum;
        float averageChannel = (float)mostIntenseChannelSum / (float)colorItemSum;
        float mostIntenseChannel = Math.max(red, Math.max(green, blue));
        red = (int)((float)red * averageChannel / mostIntenseChannel);
        green = (int)((float)green * averageChannel / mostIntenseChannel);
        blue = (int)((float)blue * averageChannel / mostIntenseChannel);
        int finalColor = (red << 8) + green;
        finalColor = (finalColor << 8) + blue;
        dyeableItem.setColor(dyedStack, finalColor);
        return dyedStack;
    }

    public static ItemStack colorStackDyeItem(ItemStack stack, List<DyeItem> dyeItemList) {
        return IDyeableItem.colorStack(stack, dyeItemList.parallelStream().map(dyeItem -> dyeItem.func_195962_g()).collect(Collectors.toList()));
    }
}

