/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary.icon;

import com.feed_the_beast.mods.ftbguilibrary.FTBGUILibraryClient;
import com.feed_the_beast.mods.ftbguilibrary.icon.Icon;
import com.feed_the_beast.mods.ftbguilibrary.icon.ImageCallback;
import com.feed_the_beast.mods.ftbguilibrary.utils.IPixelBuffer;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.WritableImage;
import javax.annotation.Nullable;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.ModList;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class IconRenderer {
    private static final Collection<IconCallbackPair> QUEUE = new LinkedList<IconCallbackPair>();
    private static javafx.scene.image.Image nullImage = null;
    private static Map<Icon, javafx.scene.image.Image> imageCache = new HashMap<Icon, javafx.scene.image.Image>();

    public static void clearCache() {
        imageCache = new HashMap<Icon, javafx.scene.image.Image>();
    }

    public static javafx.scene.image.Image getNullImage() {
        if (nullImage == null) {
            ResourceLocation rl = ModList.get().isLoaded("missingitem") ? new ResourceLocation("missingitem:textures/items/missingitem.png") : new ResourceLocation("ftbguilibrary:textures/icons/cancel.png");
            try (InputStream stream = Minecraft.func_71410_x().func_195551_G().func_199002_a(rl).func_199027_b();){
                nullImage = new javafx.scene.image.Image(stream);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nullImage;
    }

    public static boolean load(@Nullable Icon icon, ImageCallback callback) {
        if (icon == null) {
            callback.imageLoaded(false, null);
            return true;
        }
        if (icon.isEmpty()) {
            callback.imageLoaded(false, IconRenderer.getNullImage());
            return true;
        }
        javafx.scene.image.Image image = imageCache.get(icon);
        if (image != null) {
            callback.imageLoaded(false, image);
            return true;
        }
        if (icon.hasPixelBuffer()) {
            IPixelBuffer buffer = icon.createPixelBuffer();
            if (buffer == null) {
                image = IconRenderer.getNullImage();
            } else {
                int w = buffer.getWidth();
                int h = buffer.getHeight();
                image = new WritableImage(w, h);
                ((WritableImage)image).getPixelWriter().setPixels(0, 0, w, h, (PixelFormat)PixelFormat.getIntArgbInstance(), buffer.getPixels(), 0, w);
            }
            imageCache.put(icon, image);
            callback.imageLoaded(false, image);
            return true;
        }
        imageCache.put(icon, IconRenderer.getNullImage());
        callback.imageLoaded(false, IconRenderer.getNullImage());
        IconCallbackPair pair = new IconCallbackPair();
        pair.icon = icon;
        pair.callback = callback;
        Minecraft.func_71410_x().func_212871_a_((Runnable)pair);
        return false;
    }

    public static void render() {
        if (QUEUE.isEmpty()) {
            return;
        }
        IconCallbackPair[] queued = QUEUE.toArray(new IconCallbackPair[0]);
        QUEUE.clear();
        Minecraft mc = Minecraft.func_71410_x();
        MainWindow res = mc.func_228018_at_();
        int size = Math.min(Math.min(res.func_198105_m(), res.func_198083_n()), 64);
        RenderHelper.func_227780_a_();
        double scale = (double)size / (16.0 * res.func_198100_s());
        RenderSystem.translated((double)0.0, (double)0.0, (double)(-(scale * 100.0)));
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        float oldZLevel = mc.func_175599_af().field_77023_b;
        mc.func_175599_af().field_77023_b = -50.0f;
        RenderSystem.enableRescaleNormal();
        RenderSystem.enableColorMaterial();
        RenderSystem.enableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)770, (int)1);
        RenderSystem.blendFunc((int)770, (int)771);
        RenderSystem.disableAlphaTest();
        int[] pixels = new int[size * size];
        AffineTransform at = new AffineTransform();
        at.concatenate(AffineTransform.getScaleInstance(1.0, -1.0));
        at.concatenate(AffineTransform.getTranslateInstance(0.0, -size));
        BufferedImage img = new BufferedImage(size, size, 2);
        for (IconCallbackPair pair : queued) {
            RenderSystem.pushMatrix();
            RenderSystem.clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
            RenderSystem.clear((int)16640, (boolean)false);
            pair.icon.drawStatic(0, 0, 16, 16);
            RenderSystem.popMatrix();
            try {
                ByteBuffer buf = BufferUtils.createByteBuffer((int)(size * size * 4));
                GL11.glReadBuffer((int)1029);
                GL11.glGetError();
                GL11.glReadPixels((int)0, (int)(res.func_198083_n() - size), (int)size, (int)size, (int)32993, (int)5121, (ByteBuffer)buf);
                buf.asIntBuffer().get(pixels);
                img.setRGB(0, 0, size, size, pixels, 0, size);
                BufferedImage flipped = new BufferedImage(size, size, 2);
                Graphics2D g = flipped.createGraphics();
                g.transform(at);
                g.drawImage((Image)img, 0, 0, null);
                g.dispose();
                pixels = flipped.getRGB(0, 0, size, size, pixels, 0, size);
                WritableImage image = new WritableImage(size, size);
                image.getPixelWriter().setPixels(0, 0, size, size, (PixelFormat)PixelFormat.getIntArgbInstance(), pixels, 0, size);
                imageCache.put(pair.icon, (javafx.scene.image.Image)image);
                pair.callback.imageLoaded(true, (javafx.scene.image.Image)image);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        RenderSystem.disableLighting();
        RenderSystem.disableColorMaterial();
        RenderSystem.disableDepthTest();
        RenderSystem.disableBlend();
        mc.func_175599_af().field_77023_b = oldZLevel;
    }

    private static class IconCallbackPair
    implements Runnable {
        private Icon icon;
        private ImageCallback callback;

        private IconCallbackPair() {
        }

        @Override
        public void run() {
            QUEUE.add(this);
            FTBGUILibraryClient.shouldRenderIcons = true;
        }
    }
}

