/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.mods.ftbguilibrary;

import com.feed_the_beast.mods.ftbguilibrary.FTBGUILibraryCommon;
import com.feed_the_beast.mods.ftbguilibrary.icon.AtlasSpriteIcon;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconPresets;
import com.feed_the_beast.mods.ftbguilibrary.icon.IconRenderer;
import com.feed_the_beast.mods.ftbguilibrary.sidebar.GuiButtonSidebarGroup;
import com.feed_the_beast.mods.ftbguilibrary.sidebar.SidebarButtonManager;
import com.feed_the_beast.mods.ftbguilibrary.utils.ClientUtils;
import com.feed_the_beast.mods.ftbguilibrary.widget.GuiIcons;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DisplayEffectsScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class FTBGUILibraryClient
extends FTBGUILibraryCommon {
    public static boolean shouldRenderIcons = false;
    public static int showButtons = 1;

    @Override
    public void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::textureStitch);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, this::renderTick);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, true, this::guiInit);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_195551_G()).func_219534_a((IFutureReloadListener)SidebarButtonManager.INSTANCE);
        MinecraftForge.EVENT_BUS.addListener(this::clientTick);
    }

    private void textureStitch(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        try {
            for (Field field : GuiIcons.class.getDeclaredFields()) {
                field.setAccessible(true);
                Object o = field.get(null);
                if (!(o instanceof AtlasSpriteIcon)) continue;
                AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                event.addSprite(a.id);
                IconPresets.MAP.put(a.id.toString(), a);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && shouldRenderIcons) {
            this.renderIcons();
        }
    }

    private void renderIcons() {
        IconRenderer.render();
    }

    private void guiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (FTBGUILibraryClient.areButtonsVisible(event.getGui())) {
            event.addWidget((Widget)new GuiButtonSidebarGroup((ContainerScreen)event.getGui()));
        }
    }

    private void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    public static boolean areButtonsVisible(@Nullable Screen gui) {
        if (showButtons == 0 || showButtons == 2 && !(gui instanceof DisplayEffectsScreen)) {
            return false;
        }
        return gui instanceof ContainerScreen && !SidebarButtonManager.INSTANCE.groups.isEmpty();
    }
}

