/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.network;

import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.network.ICommandHandler;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.Logging;
import mcjty.rftoolsutility.modules.teleporter.data.TransmitterInfo;
import mcjty.rftoolsutility.modules.teleporter.network.PacketTransmittersReady;
import mcjty.rftoolsutility.setup.RFToolsUtilityMessages;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGetTransmitters {
    protected BlockPos pos;
    protected TypedMap params;

    public PacketGetTransmitters() {
    }

    public PacketGetTransmitters(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.params = TypedMapTools.readArguments((PacketBuffer)buf);
    }

    public PacketGetTransmitters(BlockPos pos) {
        this.pos = pos;
        this.params = TypedMap.EMPTY;
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        TypedMapTools.writeArguments((PacketBuffer)buf, (TypedMap)this.params);
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = ctx.getSender().func_130014_f_().func_175625_s(this.pos);
            if (!(te instanceof ICommandHandler)) {
                Logging.log((String)"createStartScanPacket: TileEntity is not a CommandHandler!");
                return;
            }
            ICommandHandler commandHandler = (ICommandHandler)te;
            List list = commandHandler.executeWithResultList("getTransmitters", this.params, Type.create(TransmitterInfo.class));
            PacketTransmittersReady msg = new PacketTransmittersReady(this.pos, "getTransmitters", list);
            RFToolsUtilityMessages.INSTANCE.sendTo((Object)msg, ctx.getSender().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        });
        ctx.setPacketHandled(true);
    }
}

