/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.items;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.client.GuiTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.BlockTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.ModuleTools;
import mcjty.rftoolsbase.api.various.ITabletSupport;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.ScreenSetup;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenContainer;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ScreenLinkItem
extends Item
implements ITabletSupport {
    private final TooltipBuilder tooltipBuilder = new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolsutility.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(), TooltipBuilder.parameter((String)"info", this::getInfoString)});

    protected String getInfoString(ItemStack stack) {
        return ModuleTools.getTargetString((ItemStack)stack);
    }

    public ScreenLinkItem() {
        super(new Item.Properties().func_200915_b(1).func_200916_a(RFToolsUtility.setup.getTab()));
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        super.func_77624_a(itemStack, world, list, flag);
        this.tooltipBuilder.makeTooltip(this.getRegistryName(), itemStack, list, flag);
    }

    public Item getInstalledTablet() {
        return (Item)ScreenSetup.TABLET_SCREEN.get();
    }

    public void openGui(@Nonnull PlayerEntity player, @Nonnull ItemStack tabletItem, @Nonnull ItemStack containingItem) {
        final BlockPos pos = ModuleTools.getPositionFromModule((ItemStack)containingItem);
        DimensionType dimensionType = ModuleTools.getDimensionFromModule((ItemStack)containingItem);
        GuiTools.openRemoteGui((PlayerEntity)player, (DimensionType)dimensionType, (BlockPos)pos, te -> new INamedContainerProvider((TileEntity)te){
            final /* synthetic */ TileEntity val$te;
            {
                this.val$te = tileEntity;
            }

            public ITextComponent func_145748_c_() {
                return new StringTextComponent("Remote Screen");
            }

            @Nullable
            public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                ScreenContainer container = ScreenContainer.createRemote(id, pos, (GenericTileEntity)this.val$te);
                this.val$te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(h -> container.setupInventories((IItemHandler)h, inventory));
                return container;
            }
        });
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            this.openGui(player, stack, stack);
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        Direction facing = context.func_196000_l();
        PlayerEntity player = context.func_195999_j();
        TileEntity te = world.func_175625_s(pos);
        CompoundNBT tagCompound = stack.func_196082_o();
        if (te instanceof ScreenTileEntity) {
            tagCompound.func_74778_a("monitordim", world.func_201675_m().func_186058_p().getRegistryName().toString());
            tagCompound.func_74768_a("monitorx", pos.func_177958_n());
            tagCompound.func_74768_a("monitory", pos.func_177956_o());
            tagCompound.func_74768_a("monitorz", pos.func_177952_p());
            BlockState state = player.func_130014_f_().func_180495_p(pos);
            Block block = state.func_177230_c();
            String name = "<invalid>";
            if (block != null && !block.isAir(state, (IBlockReader)world, pos)) {
                name = BlockTools.getReadableName((World)world, (BlockPos)pos);
            }
            tagCompound.func_74778_a("monitorname", name);
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)("Screen link is set to block '" + name + "'"));
            }
        } else {
            tagCompound.func_82580_o("monitordim");
            tagCompound.func_82580_o("monitorx");
            tagCompound.func_82580_o("monitory");
            tagCompound.func_82580_o("monitorz");
            tagCompound.func_82580_o("monitorname");
            if (world.field_72995_K) {
                Logging.message((PlayerEntity)player, (String)"Screen link is cleared");
            }
        }
        stack.func_77982_d(tagCompound);
        return ActionResultType.SUCCESS;
    }
}

