/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsstorage.commands;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.SimpleDateFormat;
import java.util.Date;
import mcjty.rftoolsstorage.storage.StorageEntry;
import mcjty.rftoolsstorage.storage.StorageHolder;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class CommandList
implements Command<CommandSource> {
    private static final CommandList CMD = new CommandList();

    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"list").requires(cs -> cs.func_197034_c(2))).executes((Command)CMD);
    }

    public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
        for (StorageEntry storage : StorageHolder.get((World)((CommandSource)context.getSource()).func_197023_e()).getStorages()) {
            String createdByColor;
            String createdBy = storage.getCreatedBy();
            String uuid = storage.getUuid().toString();
            if (createdBy == null || createdBy.isEmpty()) {
                createdByColor = String.valueOf(TextFormatting.GRAY);
                createdBy = "(Unknown creator)";
            } else {
                createdByColor = String.valueOf(TextFormatting.YELLOW);
                createdBy = "(" + createdBy + ")";
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date creationTime = new Date(storage.getCreationTime());
            Date updateTime = new Date(storage.getUpdateTime());
            String createTimeF = dateFormat.format(creationTime);
            String updateTimeF = dateFormat.format(updateTime);
            String output = String.format(TextFormatting.GREEN + "%s: %s%s\n" + TextFormatting.WHITE + "Create " + TextFormatting.YELLOW + "%s" + TextFormatting.WHITE + ", Update " + TextFormatting.YELLOW + "%s", uuid, createdByColor, createdBy, createTimeF, updateTimeF);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(output), false);
        }
        return 0;
    }
}

