/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.template.component;

import com.google.gson.annotations.SerializedName;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import vazkii.patchouli.client.book.BookEntry;
import vazkii.patchouli.client.book.BookPage;
import vazkii.patchouli.client.book.template.TemplateComponent;

public class ComponentHeader
extends TemplateComponent {
    public String text;
    @SerializedName(value="color")
    public String colorStr;
    boolean centered = true;
    float scale = 1.0f;
    transient int color;

    @Override
    public void build(BookPage page, BookEntry entry, int pageNum) {
        try {
            this.color = Integer.parseInt(this.colorStr, 16);
        }
        catch (NumberFormatException e) {
            this.color = page.book.headerColor;
        }
        if (this.x == -1) {
            this.x = 58;
        }
        if (this.y == -1) {
            this.y = 0;
        }
    }

    @Override
    public void render(BookPage page, int mouseX, int mouseY, float pticks) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)this.x, (float)this.y, (float)0.0f);
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        if (this.centered) {
            page.parent.drawCenteredStringNoShadow(page.i18n(this.text), 0, 0, this.color);
        } else {
            page.fontRenderer.func_211126_b(page.i18n(this.text), 0.0f, 0.0f, this.color);
        }
        RenderSystem.popMatrix();
    }

    @Override
    public void onVariablesAvailable(Function<String, String> lookup) {
        super.onVariablesAvailable(lookup);
        this.text = lookup.apply(this.text);
        this.colorStr = lookup.apply(this.colorStr);
    }
}

