/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModTileEntities;
import net.blay09.mods.refinedrelocation.RefinedRelocationConfig;
import net.blay09.mods.refinedrelocation.api.Capabilities;
import net.blay09.mods.refinedrelocation.api.filter.IRootFilter;
import net.blay09.mods.refinedrelocation.api.grid.ISortingInventory;
import net.blay09.mods.refinedrelocation.tile.IDroppableItemHandler;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileSortingInterface
extends TileMod
implements ITickableTileEntity,
IDroppableItemHandler {
    private final ISortingInventory sortingInventory = Capabilities.getDefaultInstance(Capabilities.SORTING_INVENTORY);
    private final IRootFilter rootFilter = Capabilities.getDefaultInstance(Capabilities.ROOT_FILTER);
    private TileEntity cachedConnectedTile;
    private ItemStack[] lastInventory;
    private int currentDetectionSlot;

    public TileSortingInterface() {
        super(ModTileEntities.sortingInterface);
    }

    public void func_73660_a() {
        this.baseTick();
        if (this.cachedConnectedTile == null) {
            this.cachedConnectedTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        } else if (this.cachedConnectedTile.func_145837_r()) {
            this.cachedConnectedTile = null;
            this.lastInventory = null;
        }
        this.sortingInventory.onUpdate(this);
        if (!this.field_145850_b.field_72995_K) {
            LazyOptional<IItemHandler> itemHandlerCap = this.sortingInventory.getItemHandler();
            itemHandlerCap.ifPresent(itemHandler -> {
                int inventorySize = itemHandler.getSlots();
                if (this.lastInventory == null || inventorySize != this.lastInventory.length) {
                    this.lastInventory = new ItemStack[itemHandler.getSlots()];
                    for (int i = 0; i < inventorySize; ++i) {
                        ItemStack currentStack = itemHandler.getStackInSlot(i);
                        this.lastInventory[i] = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                    }
                    this.currentDetectionSlot = 0;
                }
                for (int j = 0; j < Math.min((Integer)RefinedRelocationConfig.COMMON.sortingInterfaceSlotsPerTick.get(), inventorySize); ++j) {
                    int i = this.currentDetectionSlot;
                    ItemStack prevStack = this.lastInventory[i];
                    ItemStack currentStack = itemHandler.getStackInSlot(i);
                    if (!ItemStack.func_179545_c((ItemStack)prevStack, (ItemStack)currentStack) || !ItemStack.func_77970_a((ItemStack)prevStack, (ItemStack)currentStack)) {
                        this.sortingInventory.onSlotChanged(i);
                        this.lastInventory[i] = currentStack.func_190926_b() ? ItemStack.field_190927_a : currentStack.func_77946_l();
                    }
                    ++this.currentDetectionSlot;
                    if (this.currentDetectionSlot < inventorySize) continue;
                    this.currentDetectionSlot = 0;
                }
            });
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.sortingInventory.onInvalidate(this);
    }

    public void onChunkUnloaded() {
        this.sortingInventory.onInvalidate(this);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.sortingInventory.deserializeNBT((INBT)compound.func_74775_l("SortingInventory"));
        this.rootFilter.deserializeNBT((INBT)compound.func_74775_l("RootFilter"));
    }

    @Override
    public void readFromNBTSynced(CompoundNBT compound) {
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_218657_a("SortingInventory", this.sortingInventory.serializeNBT());
        compound.func_218657_a("RootFilter", this.rootFilter.serializeNBT());
        return compound;
    }

    @Override
    public CompoundNBT writeToNBTSynced(CompoundNBT compound) {
        return compound;
    }

    @Override
    protected void onFirstTick() {
        this.cachedConnectedTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.getFacing()));
        this.sortingInventory.onFirstTick(this);
    }

    public Direction getFacing() {
        return (Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208155_H);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = super.getCapability(cap, side);
        if (!result.isPresent()) {
            result = Capabilities.ROOT_FILTER.orEmpty(cap, LazyOptional.of(() -> this.rootFilter));
        }
        if (!result.isPresent()) {
            result = Capabilities.SIMPLE_FILTER.orEmpty(cap, LazyOptional.of(() -> this.rootFilter));
        }
        if (!result.isPresent()) {
            result = Capabilities.SIMPLE_FILTER.orEmpty(cap, LazyOptional.of(() -> this.rootFilter));
        }
        if (!result.isPresent()) {
            result = Capabilities.SORTING_INVENTORY.orEmpty(cap, LazyOptional.of(() -> this.sortingInventory));
        }
        if (!result.isPresent()) {
            result = Capabilities.SORTING_GRID_MEMBER.orEmpty(cap, LazyOptional.of(() -> this.sortingInventory));
        }
        if (!result.isPresent() && this.cachedConnectedTile != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.cachedConnectedTile.getCapability(cap, this.getFacing().func_176734_d()).cast();
        }
        return result;
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:sorting_interface";
    }

    @Override
    public Collection<IItemHandler> getDroppedItemHandlers() {
        return Collections.emptyList();
    }
}

