/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.refinedrelocation.tile;

import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.blay09.mods.refinedrelocation.ModTileEntities;
import net.blay09.mods.refinedrelocation.block.FastHopperBlock;
import net.blay09.mods.refinedrelocation.container.ContainerFastHopper;
import net.blay09.mods.refinedrelocation.tile.TileMod;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.INameable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class FastHopperTileEntity
extends TileMod
implements ITickableTileEntity,
INamedContainerProvider,
INameable {
    private static final Predicate<? super Entity> HAS_ITEM_HANDLER = entity -> entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent();
    private final ItemStackHandler itemHandler = this.createItemHandler();
    private ITextComponent customName;
    private int cooldown;

    public FastHopperTileEntity() {
        super(ModTileEntities.fastHopper);
    }

    public FastHopperTileEntity(TileEntityType<?> type) {
        super(type);
    }

    protected ItemStackHandler createItemHandler() {
        return new ItemStackHandler(5){

            protected void onContentsChanged(int slot) {
                FastHopperTileEntity.this.func_70296_d();
            }
        };
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.cooldown;
            if (this.cooldown <= 0) {
                LazyOptional<IItemHandler> itemHandlerCap;
                int i;
                BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
                boolean isEnabled = (Boolean)state.func_177229_b((IProperty)FastHopperBlock.ENABLED);
                if (!isEnabled) {
                    return;
                }
                Direction facing = (Direction)state.func_177229_b((IProperty)FastHopperBlock.FACING);
                Direction opposite = facing.func_176734_d();
                TileEntity facingTile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
                LazyOptional targetItemHandlerCap = facingTile != null ? facingTile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, opposite) : LazyOptional.empty();
                boolean hasSpace = false;
                if (targetItemHandlerCap.isPresent()) {
                    for (i = 0; i < this.itemHandler.getSlots(); ++i) {
                        ItemStack itemStack = this.itemHandler.getStackInSlot(i);
                        if (!itemStack.func_190926_b()) {
                            this.pushItem(i, (IItemHandler)targetItemHandlerCap.orElseThrow(ConcurrentModificationException::new));
                        }
                        if (hasSpace || !itemStack.func_190926_b() && itemStack.func_190916_E() >= itemStack.func_77976_d()) continue;
                        hasSpace = true;
                    }
                } else {
                    for (i = 0; i < this.itemHandler.getSlots(); ++i) {
                        if (!this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
                        hasSpace = true;
                        break;
                    }
                }
                if (hasSpace && (itemHandlerCap = this.getItemHandlerAt(this.field_174879_c.func_177972_a(Direction.UP))).isPresent()) {
                    this.pullItem((IItemHandler)itemHandlerCap.orElseThrow(ConcurrentModificationException::new));
                }
                this.cooldown = 20;
            }
        }
    }

    private LazyOptional<IItemHandler> getItemHandlerAt(BlockPos pos) {
        TileEntity tileEntity = this.field_145850_b.func_175625_s(pos);
        if (tileEntity != null) {
            return tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.DOWN);
        }
        List list = this.field_145850_b.func_175674_a(null, new AxisAlignedBB((double)pos.func_177958_n() - 0.5, (double)pos.func_177956_o() - 0.5, (double)pos.func_177952_p() - 0.5, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5), null);
        if (!list.isEmpty()) {
            Entity entity = (Entity)list.get(this.field_145850_b.field_73012_v.nextInt(list.size()));
            return entity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        }
        return LazyOptional.empty();
    }

    private void pushItem(int sourceSlot, IItemHandler targetItemHandler) {
        ItemStack sourceStack = this.itemHandler.extractItem(sourceSlot, Items.field_190931_a.getItemStackLimit(ItemStack.field_190927_a), true);
        ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)targetItemHandler, (ItemStack)sourceStack, (boolean)false);
        this.itemHandler.extractItem(sourceSlot, restStack.func_190926_b() ? sourceStack.func_190916_E() : sourceStack.func_190916_E() - restStack.func_190916_E(), false);
    }

    private void pullItem(IItemHandler sourceItemHandler) {
        for (int i = 0; i < sourceItemHandler.getSlots(); ++i) {
            ItemStack sourceStack = sourceItemHandler.extractItem(i, Items.field_190931_a.getItemStackLimit(ItemStack.field_190927_a), true);
            if (sourceStack.func_190926_b()) continue;
            ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)sourceStack, (boolean)false);
            sourceItemHandler.extractItem(i, restStack.func_190926_b() ? Items.field_190931_a.getItemStackLimit(ItemStack.field_190927_a) : sourceStack.func_190916_E() - restStack.func_190916_E(), false);
            break;
        }
    }

    private boolean pullItem(ItemEntity entityItem) {
        ItemStack sourceStack = entityItem.func_92059_d();
        ItemStack restStack = ItemHandlerHelper.insertItem((IItemHandler)this.itemHandler, (ItemStack)sourceStack, (boolean)false);
        if (!restStack.func_190926_b()) {
            entityItem.func_92058_a(restStack);
        } else {
            entityItem.func_70106_y();
        }
        return restStack.func_190926_b() || restStack.func_190916_E() < sourceStack.func_190916_E();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_218657_a("ItemHandler", (INBT)this.itemHandler.serializeNBT());
        if (this.customName != null) {
            tagCompound.func_74778_a("CustomName", this.customName.func_150261_e());
        }
        return tagCompound;
    }

    @Override
    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.itemHandler.deserializeNBT(tagCompound.func_74775_l("ItemHandler"));
        this.customName = tagCompound.func_74764_b("CustomName") ? new StringTextComponent(tagCompound.func_74779_i("CustomName")) : null;
    }

    @Override
    public String getUnlocalizedName() {
        return "container.refinedrelocation:fast_hopper";
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        LazyOptional result = super.getCapability(cap, side);
        if (!result.isPresent()) {
            result = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.orEmpty(cap, LazyOptional.of(() -> this.itemHandler));
        }
        return result;
    }

    public ItemStackHandler getItemHandler() {
        return this.itemHandler;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerFastHopper(i, playerInventory, this);
    }

    public ITextComponent func_200200_C_() {
        return this.customName != null ? this.customName : new TranslationTextComponent(this.getUnlocalizedName(), new Object[0]);
    }

    public boolean func_145818_k_() {
        return this.customName != null;
    }

    @Nullable
    public ITextComponent func_200201_e() {
        return this.customName;
    }

    public void onEntityCollision(Entity entity) {
        if (entity instanceof ItemEntity && VoxelShapes.func_197879_c((VoxelShape)VoxelShapes.func_197881_a((AxisAlignedBB)entity.func_174813_aQ().func_72317_d((double)(-this.field_174879_c.func_177958_n()), (double)(-this.field_174879_c.func_177956_o()), (double)(-this.field_174879_c.func_177952_p()))), (VoxelShape)IHopper.field_200103_c, (IBooleanFunction)IBooleanFunction.field_223238_i_)) {
            this.pullItem((ItemEntity)entity);
        }
    }
}

