/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.parser.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.CompileException;
import org.openzen.zencode.shared.CompileExceptionCode;
import org.openzen.zenscript.codemodel.partial.IPartialExpression;
import org.openzen.zenscript.codemodel.scope.ExpressionScope;
import org.openzen.zenscript.codemodel.type.DefinitionTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;
import org.openzen.zenscript.parser.expression.ParsedExpression;

public class ParsedExpressionOuter
extends ParsedExpression {
    private final ParsedExpression value;

    public ParsedExpressionOuter(CodePosition position, ParsedExpression value) {
        super(position);
        this.value = value;
    }

    @Override
    public IPartialExpression compile(ExpressionScope scope) throws CompileException {
        StoredType thisType = scope.getThisType();
        if (thisType == null || !(thisType.type instanceof DefinitionTypeID)) {
            throw new CompileException(this.position, CompileExceptionCode.USING_THIS_OUTSIDE_TYPE, "Not in a type");
        }
        return scope.getOuterInstance(this.position);
    }

    @Override
    public boolean hasStrongType() {
        return this.value.hasStrongType();
    }
}

