/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.lexer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.codemodel.WhitespaceInfo;
import org.openzen.zenscript.lexer.CharReader;
import org.openzen.zenscript.lexer.CompiledDFA;
import org.openzen.zenscript.lexer.LLParserTokenStream;
import org.openzen.zenscript.lexer.ParseException;
import org.openzen.zenscript.lexer.ReaderCharReader;
import org.openzen.zenscript.lexer.TokenParser;
import org.openzen.zenscript.lexer.TokenStream;
import org.openzen.zenscript.lexer.TokenType;
import org.openzen.zenscript.lexer.ZSToken;
import org.openzen.zenscript.lexer.ZSTokenFactory;
import org.openzen.zenscript.lexer.ZSTokenType;
import org.openzen.zenscript.parser.BracketExpressionParser;

public class ZSTokenParser
extends LLParserTokenStream<ZSTokenType, ZSToken> {
    private static final CompiledDFA DFA = CompiledDFA.createLexerDFA((TokenType[])ZSTokenType.values(), ZSTokenType.class);
    public final BracketExpressionParser bracketParser;
    private final List<ParseException> parseErrors = new ArrayList<ParseException>();

    public static TokenParser<ZSToken, ZSTokenType> createRaw(SourceFile file, CharReader reader, int spacesPerTab) {
        return new TokenParser<ZSToken, ZSTokenType>(file, reader, DFA, ZSTokenType.EOF, ZSTokenType.INVALID, new ZSTokenFactory(spacesPerTab));
    }

    public static ZSTokenParser create(SourceFile file, BracketExpressionParser bracketParser, int spacesPerTab) throws IOException, ParseException {
        return new ZSTokenParser(ZSTokenParser.createRaw(file, new ReaderCharReader(file.open()), spacesPerTab), bracketParser);
    }

    public ZSTokenParser(TokenStream<ZSTokenType, ZSToken> parser, BracketExpressionParser bracketParser) throws ParseException {
        super(parser);
        this.bracketParser = bracketParser;
    }

    public SourceFile getFile() {
        return this.getPosition().file;
    }

    public WhitespaceInfo collectWhitespaceInfo(String whitespace, boolean skipLineBefore) {
        return WhitespaceInfo.from(whitespace, this.grabWhitespaceLine(), skipLineBefore);
    }

    public void logError(ParseException error) {
        this.parseErrors.add(error);
    }

    public List<ParseException> getErrors() {
        return this.parseErrors;
    }
}

