/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.javabytecode;

import java.util.LinkedHashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.openzen.zencode.shared.CodePosition;
import org.openzen.zencode.shared.SourceFile;
import org.openzen.zenscript.codemodel.FunctionHeader;
import org.openzen.zenscript.codemodel.FunctionParameter;
import org.openzen.zenscript.codemodel.HighLevelDefinition;
import org.openzen.zenscript.codemodel.ScriptBlock;
import org.openzen.zenscript.codemodel.SemanticModule;
import org.openzen.zenscript.codemodel.definition.ExpansionDefinition;
import org.openzen.zenscript.codemodel.statement.Statement;
import org.openzen.zenscript.codemodel.type.BasicTypeID;
import org.openzen.zenscript.javabytecode.JavaBytecodeContext;
import org.openzen.zenscript.javabytecode.JavaBytecodeModule;
import org.openzen.zenscript.javabytecode.JavaScriptMethod;
import org.openzen.zenscript.javabytecode.compiler.JavaClassWriter;
import org.openzen.zenscript.javabytecode.compiler.JavaScriptFile;
import org.openzen.zenscript.javabytecode.compiler.JavaStatementVisitor;
import org.openzen.zenscript.javabytecode.compiler.JavaWriter;
import org.openzen.zenscript.javabytecode.compiler.definitions.JavaDefinitionVisitor;
import org.openzen.zenscript.javashared.JavaClass;
import org.openzen.zenscript.javashared.JavaCompileSpace;
import org.openzen.zenscript.javashared.JavaMethod;
import org.openzen.zenscript.javashared.JavaParameterInfo;
import org.openzen.zenscript.javashared.prepare.JavaPrepareDefinitionMemberVisitor;
import org.openzen.zenscript.javashared.prepare.JavaPrepareDefinitionVisitor;

public class JavaCompiler {
    private int generatedScriptBlockCounter = 0;
    private int expansionCounter = 0;

    public JavaBytecodeModule compile(String packageName, SemanticModule module, JavaCompileSpace space) {
        String className;
        LinkedHashMap<String, JavaScriptFile> scriptBlocks = new LinkedHashMap<String, JavaScriptFile>();
        JavaBytecodeModule target = new JavaBytecodeModule(module.module, module.parameters);
        JavaBytecodeContext context = new JavaBytecodeContext(target, space, module.modulePackage, packageName);
        context.addModule(module.module, target);
        for (HighLevelDefinition definition : module.definitions.getAll()) {
            className = this.getClassName(this.getFilename(definition));
            String filename = className + "_" + (definition.name == null ? "generated" : definition.name) + "_" + this.expansionCounter++;
            JavaPrepareDefinitionVisitor javaPrepareDefinitionVisitor = new JavaPrepareDefinitionVisitor(context, target, filename, null, className);
            definition.accept(javaPrepareDefinitionVisitor);
        }
        for (HighLevelDefinition definition : module.definitions.getAll()) {
            JavaPrepareDefinitionMemberVisitor memberPreparer = new JavaPrepareDefinitionMemberVisitor(context, target);
            definition.accept(memberPreparer);
        }
        for (HighLevelDefinition definition : module.definitions.getAll()) {
            className = this.getClassName(definition.position.getFilename());
            JavaScriptFile scriptFile = this.getScriptFile(scriptBlocks, definition.pkg.fullName + "/" + className);
            scriptFile.classWriter.visitSource(definition.position.getFilename(), null);
            JavaClass javaClass = definition instanceof ExpansionDefinition ? context.getJavaExpansionClass(definition) : context.getJavaClass(definition);
            target.addClass(javaClass.internalName, definition.accept(new JavaDefinitionVisitor(context, scriptFile.classWriter)));
        }
        FunctionHeader scriptHeader = new FunctionHeader(BasicTypeID.VOID, module.parameters);
        String scriptDescriptor = context.getMethodDescriptor(scriptHeader);
        JavaParameterInfo[] javaScriptParameters = new JavaParameterInfo[module.parameters.length];
        for (int i = 0; i < module.parameters.length; ++i) {
            FunctionParameter functionParameter = module.parameters[i];
            JavaParameterInfo javaParameter = new JavaParameterInfo(i, context.getDescriptor(functionParameter.type));
            target.setParameterInfo(functionParameter, javaParameter);
            javaScriptParameters[i] = javaParameter;
        }
        for (ScriptBlock scriptBlock : module.scripts) {
            SourceFile sourceFile = scriptBlock.file;
            String className2 = this.getClassName(sourceFile == null ? null : sourceFile.getFilename());
            JavaScriptFile scriptFile = this.getScriptFile(scriptBlocks, scriptBlock.pkg.fullName + "/" + className2);
            scriptFile.classWriter.visitSource(scriptBlock.file.getFilename(), null);
            String methodName = scriptFile.scriptMethods.isEmpty() ? "run" : "run" + scriptFile.scriptMethods.size();
            JavaClassWriter visitor = scriptFile.classWriter;
            JavaMethod method = JavaMethod.getStatic(new JavaClass(context.getPackageName(scriptBlock.pkg), className2, JavaClass.Kind.CLASS), methodName, scriptDescriptor, 9);
            scriptFile.scriptMethods.add(new JavaScriptMethod(method, module.parameters, javaScriptParameters));
            JavaStatementVisitor statementVisitor = new JavaStatementVisitor(context, context.getJavaModule(scriptBlock.module), new JavaWriter(CodePosition.UNKNOWN, (ClassVisitor)visitor, method, null, null, null, new String[0]));
            statementVisitor.start();
            for (Statement statement : scriptBlock.statements) {
                statement.accept(statementVisitor);
            }
            statementVisitor.end();
        }
        for (Map.Entry entry : scriptBlocks.entrySet()) {
            for (JavaScriptMethod method : ((JavaScriptFile)entry.getValue()).scriptMethods) {
                target.addScript(method);
            }
            ((JavaScriptFile)entry.getValue()).classWriter.visitEnd();
            if (target.getClasses().containsKey(entry.getKey())) {
                System.err.println("Trying to register " + (String)entry.getKey() + " a 2nd time");
                continue;
            }
            target.addClass((String)entry.getKey(), ((JavaScriptFile)entry.getValue()).classWriter.toByteArray());
        }
        return target;
    }

    private String getFilename(HighLevelDefinition definition) {
        SourceFile source = definition.position.file;
        if (source != null) {
            return source.getFilename();
        }
        return definition.name == null ? "Expansion" : definition.name;
    }

    private String getClassName(String filename) {
        if (filename == null) {
            return "generatedBlock" + this.generatedScriptBlockCounter++;
        }
        return filename.substring(0, filename.lastIndexOf(46)).replace("/", "_");
    }

    private JavaScriptFile getScriptFile(Map<String, JavaScriptFile> scriptBlocks, String className) {
        if (!scriptBlocks.containsKey(className)) {
            JavaClassWriter scriptFileWriter = new JavaClassWriter(2);
            scriptFileWriter.visit(52, 1, className, null, "java/lang/Object", null);
            scriptBlocks.put(className, new JavaScriptFile(scriptFileWriter));
        }
        return scriptBlocks.get(className);
    }
}

