/*
 * Decompiled with CFR 0.152.
 */
package org.openzen.zenscript.codemodel.expression;

import org.openzen.zencode.shared.CodePosition;
import org.openzen.zenscript.codemodel.expression.Expression;
import org.openzen.zenscript.codemodel.expression.ExpressionTransformer;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitor;
import org.openzen.zenscript.codemodel.expression.ExpressionVisitorWithContext;
import org.openzen.zenscript.codemodel.scope.TypeScope;
import org.openzen.zenscript.codemodel.type.RangeTypeID;
import org.openzen.zenscript.codemodel.type.StoredType;

public class RangeExpression
extends Expression {
    public final Expression from;
    public final Expression to;

    public RangeExpression(CodePosition position, StoredType type, Expression from, Expression to) {
        super(position, type, RangeExpression.binaryThrow(position, from.thrownType, to.thrownType));
        this.from = from;
        this.to = to;
    }

    private RangeExpression(CodePosition position, StoredType type, Expression from, Expression to, StoredType thrownType) {
        super(position, type, thrownType);
        this.from = from;
        this.to = to;
    }

    @Override
    public <T> T accept(ExpressionVisitor<T> visitor) {
        return visitor.visitRange(this);
    }

    @Override
    public <C, R> R accept(C context, ExpressionVisitorWithContext<C, R> visitor) {
        return visitor.visitRange(context, this);
    }

    @Override
    public Expression transform(ExpressionTransformer transformer) {
        Expression tFrom = this.from.transform(transformer);
        Expression tTo = this.to.transform(transformer);
        return tFrom == this.from && tTo == this.to ? this : new RangeExpression(this.position, this.type, tFrom, tTo, this.thrownType);
    }

    @Override
    public Expression normalize(TypeScope scope) {
        StoredType baseType = ((RangeTypeID)this.type.type).baseType;
        return new RangeExpression(this.position, this.type.getNormalized(), this.from.normalize(scope).castImplicit(this.position, scope, baseType), this.to.normalize(scope).castImplicit(this.position, scope, baseType));
    }
}

