/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.impl.commands;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerRegistry;
import com.blamejared.crafttweaker.api.ScriptLoadingOptions;
import com.blamejared.crafttweaker.api.text.FormattedTextComponent;
import com.blamejared.crafttweaker.impl.item.MCItemStackMutable;
import com.blamejared.crafttweaker.impl.network.PacketHandler;
import com.blamejared.crafttweaker.impl.network.messages.MessageCopy;
import com.blamejared.crafttweaker.impl.network.messages.MessageOpen;
import com.blamejared.crafttweaker.impl.tag.MCTag;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Potion;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.registries.ForgeRegistries;

public class CTCommands {
    public static LiteralArgumentBuilder<CommandSource> root = Commands.func_197057_a((String)"ct");
    private static final Map<String, CommandImpl> COMMANDS = new TreeMap<String, CommandImpl>(String::compareTo);

    public static void init(CommandDispatcher<CommandSource> dispatcher) {
        root.then(Commands.func_197057_a((String)"copy").then(Commands.func_197056_a((String)"toCopy", StringReader::readString).executes(context -> {
            String toCopy = (String)context.getArgument("toCopy", String.class);
            ServerPlayerEntity entity = ((CommandSource)context.getSource()).func_197035_h();
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> entity), (Object)new MessageCopy(toCopy));
            CTCommands.send((TextComponent)new StringTextComponent("Copied!"), (PlayerEntity)entity);
            return 0;
        })));
        CTCommands.registerCommand(new CommandImpl("hand", "Outputs the name and tags (if any) of the item in your hand", (player, stack) -> {
            Collection tags;
            String string = new MCItemStackMutable(stack).getCommandString();
            TextComponent copy = CTCommands.copy((TextComponent)new FormattedTextComponent("Item: %s", CTCommands.color(string, TextFormatting.GREEN)), string);
            CTCommands.send(copy, player);
            if (player instanceof ServerPlayerEntity) {
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageCopy(string));
            }
            if ((tags = ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b())).isEmpty()) {
                return 0;
            }
            CTCommands.send(CTCommands.copy((TextComponent)new FormattedTextComponent(CTCommands.color("Tag Entries", TextFormatting.DARK_AQUA), new Object[0]), tags.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))), player);
            tags.stream().map(resourceLocation -> new MCTag((ResourceLocation)resourceLocation).getCommandString()).forEach(commandString -> CTCommands.send(CTCommands.copy((TextComponent)new FormattedTextComponent("\t%s %s", CTCommands.color("-", TextFormatting.YELLOW), CTCommands.color(commandString, TextFormatting.AQUA)), commandString), player));
            return 0;
        }));
        CTCommands.registerCommand("hand", new CommandImpl("registryName", "Outputs the registry name of the item in your hand", (player, stack) -> {
            String string = stack.func_77973_b().getRegistryName().toString();
            TextComponent copy = CTCommands.copy((TextComponent)new FormattedTextComponent("Item: %s", CTCommands.color(string, TextFormatting.GREEN)), string);
            CTCommands.send(copy, player);
            if (player instanceof ServerPlayerEntity) {
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageCopy(string));
            }
            return 0;
        }));
        CTCommands.registerCommand("hand", new CommandImpl("tags", "Outputs the tags of the item in your hand", (player, stack) -> {
            Collection tags = ItemTags.func_199903_a().func_199913_a((Object)stack.func_77973_b());
            if (tags.isEmpty()) {
                CTCommands.send((TextComponent)new StringTextComponent("Item has no tags"), player);
                return 0;
            }
            CTCommands.send(CTCommands.copy((TextComponent)new FormattedTextComponent(CTCommands.color("Tag Entries", TextFormatting.DARK_AQUA), new Object[0]), tags.stream().map(ResourceLocation::toString).collect(Collectors.joining(", "))), player);
            tags.stream().map(resourceLocation -> new MCTag((ResourceLocation)resourceLocation).getCommandString()).forEach(commandString -> CTCommands.send(CTCommands.copy((TextComponent)new FormattedTextComponent("\t%s %s", CTCommands.color("-", TextFormatting.YELLOW), CTCommands.color(commandString, TextFormatting.AQUA)), commandString), player));
            if (player instanceof ServerPlayerEntity) {
                PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageCopy(tags.stream().map(MCTag::new).findFirst().get().getCommandString()));
            }
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("inventory", "Outputs the names of the item in your inventory", (player, stack) -> {
            StringBuilder builder = new StringBuilder("Inventory items").append("\n");
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (slot.func_190926_b()) continue;
                builder.append(new MCItemStackMutable(slot).getCommandString()).append("\n");
            }
            CraftTweakerAPI.logDump(builder.toString(), new Object[0]);
            CTCommands.send((TextComponent)new StringTextComponent(CTCommands.color("Inventory list generated! Check the crafttweaker.log file!", TextFormatting.GREEN)), player);
            return 0;
        }));
        CTCommands.registerCommand("inventory", new CommandImpl("tags", "Outputs the tags of the item in your inventory", (player, stack) -> {
            StringBuilder builder = new StringBuilder("Inventory item tags").append("\n");
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack slot = player.field_71071_by.func_70301_a(i);
                if (slot.func_190926_b()) continue;
                builder.append(new MCItemStackMutable(slot).getCommandString()).append("\n");
                Collection tags = ItemTags.func_199903_a().func_199913_a((Object)slot.func_77973_b());
                if (tags.isEmpty()) {
                    builder.append("- No tags").append("\n");
                    continue;
                }
                tags.stream().map(resourceLocation -> new MCTag((ResourceLocation)resourceLocation).getCommandString()).forEach(s -> builder.append("-").append((String)s).append("\n"));
            }
            CraftTweakerAPI.logDump(builder.toString(), new Object[0]);
            CTCommands.send((TextComponent)new StringTextComponent(CTCommands.color("Inventory tag list generated! Check the crafttweaker.log file!", TextFormatting.GREEN)), player);
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("log", "Opens the log file", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen(new File("logs/crafttweaker.log").toURI().toString()));
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("scripts", "Opens the scripts folder", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen(new File("scripts/").toURI().toString()));
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("syntax", "Checks the syntax of the scripts", (player, stack) -> {
            CraftTweakerAPI.loadScripts(new ScriptLoadingOptions().setWildcardLoaderName());
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("format", "Checks the syntax of the scripts and formats them into another folder.", (player, stack) -> {
            CraftTweakerAPI.loadScripts(new ScriptLoadingOptions().setWildcardLoaderName().format());
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("dumpBrackets", "Dumps available Bracket Expressions into the /ct_dumps folder", source -> {
            File folder = new File("ct_dumps");
            if (!folder.exists() && !folder.mkdir()) {
                CraftTweakerAPI.logError("Could not create output folder %s", folder);
            }
            CraftTweakerRegistry.getBracketDumpers().forEach((name, dumpSupplier) -> {
                try (PrintWriter writer = new PrintWriter(new FileWriter(new File(folder, name + ".txt"), false));){
                    ((Collection)dumpSupplier.get()).stream().sorted().forEach(writer::println);
                }
                catch (IOException e) {
                    CraftTweakerAPI.logThrowing("Error writing to file '%s.txt'", e, name);
                }
            });
            CTCommands.send((TextComponent)new StringTextComponent("Files Created"), (CommandSource)source.getSource());
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("discord", "Opens a link to discord", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen("https://discord.blamejared.com"));
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("issues", "Opens a link to the issue tracker", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen("https://github.com/CraftTweaker/CraftTweaker/issues"));
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("patreon", "Opens a link to patreon", (player, stack) -> {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new MessageOpen("https://patreon.com/jaredlll08"));
            return 0;
        }));
        CTCommands.registerCommand(new CommandImpl("dump", "Dumps available sub commands for the dump command", (player, stack) -> {
            CTCommands.send((TextComponent)new StringTextComponent("Dump types: "), player);
            COMMANDS.get("dump").getSubCommands().forEach((s, command) -> CTCommands.send(CTCommands.run((TextComponent)new StringTextComponent("- " + CTCommands.color(s, TextFormatting.GREEN)), "/ct dump " + s), player));
            return 0;
        }));
        CTCommands.registerDump("recipes", "Outputs the names of all registered recipes", (player, stack) -> {
            for (IRecipeType type : Registry.field_218367_H) {
                CraftTweakerAPI.logDump(type.toString(), new Object[0]);
                for (ResourceLocation location : ((Map)player.field_70170_p.func_199532_z().field_199522_d.getOrDefault(type, new HashMap())).keySet()) {
                    CraftTweakerAPI.logDump("- " + location.toString(), new Object[0]);
                }
            }
            CTCommands.send((TextComponent)new StringTextComponent(CTCommands.color("Recipe list generated! Check the crafttweaker.log file!", TextFormatting.GREEN)), player);
            return 0;
        });
        CTCommands.registerDump("recipeTypes", "Outputs the names of all Recipe Types", (player, stack) -> {
            Registry.field_218367_H.func_148742_b().stream().filter(rl -> !rl.toString().equals("crafttweaker:scripts")).forEach(rl -> CraftTweakerAPI.logDump(rl.toString(), new Object[0]));
            CTCommands.send((TextComponent)new StringTextComponent(CTCommands.color("Recipe Type list generated! Check the crafttweaker.log file!", TextFormatting.GREEN)), player);
            return 0;
        });
        CTCommands.registerDump("potions", "Outputs the names of all Potions", (player, stack) -> {
            for (Potion type : ForgeRegistries.POTION_TYPES) {
                CraftTweakerAPI.logDump("- " + type.getRegistryName().toString(), new Object[0]);
            }
            CTCommands.send((TextComponent)new StringTextComponent(CTCommands.color("Potion list generated! Check the crafttweaker.log file!", TextFormatting.GREEN)), player);
            return 0;
        });
        CTCommands.registerDump("effects", "Outputs the names of all Effects", (player, stack) -> {
            for (Effect type : ForgeRegistries.POTIONS) {
                CraftTweakerAPI.logDump("- " + type.getRegistryName().toString(), new Object[0]);
            }
            CTCommands.send((TextComponent)new StringTextComponent(CTCommands.color("Effect list generated! Check the crafttweaker.log file!", TextFormatting.GREEN)), player);
            return 0;
        });
        CTCommands.registerDump("tags", "Outputs the names of all registered tags (vanilla tag types)", (player, stack) -> {
            CraftTweakerAPI.logDump("Item Tags:\n", new Object[0]);
            ItemTags.func_199903_a().func_200039_c().keySet().forEach(resourceLocation -> CraftTweakerAPI.logDump("-" + resourceLocation.toString(), new Object[0]));
            CraftTweakerAPI.logDump("Block Tags:\n", new Object[0]);
            BlockTags.func_199896_a().func_200039_c().keySet().forEach(resourceLocation -> CraftTweakerAPI.logDump("-" + resourceLocation.toString(), new Object[0]));
            CraftTweakerAPI.logDump("Fluid Tags:\n", new Object[0]);
            FluidTags.func_226157_a_().func_200039_c().keySet().forEach(resourceLocation -> CraftTweakerAPI.logDump("-" + resourceLocation.toString(), new Object[0]));
            CraftTweakerAPI.logDump("Entity Type Tags:\n", new Object[0]);
            EntityTypeTags.func_219762_a().func_200039_c().keySet().forEach(resourceLocation -> CraftTweakerAPI.logDump("-" + resourceLocation.toString(), new Object[0]));
            CTCommands.send((TextComponent)new StringTextComponent(CTCommands.color("Tag list generated! Check the crafttweaker.log file!", TextFormatting.GREEN)), player);
            return 0;
        });
        root.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"help").executes(context -> CTCommands.executeHelp((CommandContext<CommandSource>)context, 0))).then(Commands.func_197056_a((String)"page", StringReader::readInt).executes(context -> CTCommands.executeHelp((CommandContext<CommandSource>)context, (Integer)context.getArgument("page", Integer.TYPE)))));
        COMMANDS.forEach((s, command) -> CTCommands.registerCommandInternal(root, command));
        LiteralCommandNode rootNode = dispatcher.register(root);
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"crafttweaker").redirect((CommandNode)rootNode));
    }

    public static void registerDump(String name, String desc, CommandCaller caller) {
        CTCommands.registerCommand("dump", new CommandImpl(name, desc, caller));
    }

    public static void registerCommand(CommandImpl command) {
        COMMANDS.put(command.getName(), command);
    }

    public static void registerCommand(String command, CommandImpl subCommand) {
        COMMANDS.get(command).getSubCommands().put(subCommand.getName(), subCommand);
    }

    public static void registerCommand(CommandImpl command, CommandImpl subCommand) {
        command.getSubCommands().put(subCommand.getName(), subCommand);
    }

    private static void registerCommandInternal(LiteralArgumentBuilder<CommandSource> root, CommandImpl command) {
        LiteralArgumentBuilder litCommand = Commands.func_197057_a((String)command.getName());
        if (!command.getSubCommands().isEmpty()) {
            command.getSubCommands().forEach((s, command1) -> CTCommands.registerCommandInternal((LiteralArgumentBuilder<CommandSource>)litCommand, command1));
        }
        root.then(litCommand.executes(command.getCaller()::executeCommand));
    }

    private static int executeHelp(CommandContext<CommandSource> context, int helpPage) {
        double commandsPerPage = 4.0;
        ArrayList<String> keys = new ArrayList<String>(COMMANDS.keySet());
        int page = (int)MathHelper.func_151237_a((double)helpPage, (double)0.0, (double)(Math.ceil((double)keys.size() / commandsPerPage) - 1.0));
        int i = (int)((double)page * commandsPerPage);
        while ((double)i < Math.min((double)page * commandsPerPage + commandsPerPage, (double)keys.size())) {
            FormattedTextComponent message = new FormattedTextComponent("/ct %s", COMMANDS.get(keys.get(i)).getName());
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)CTCommands.run((TextComponent)message, message.func_150261_e()), true);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new FormattedTextComponent("- %s", CTCommands.color(COMMANDS.get(keys.get(i)).getDescription(), TextFormatting.DARK_AQUA)), true);
            ++i;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new FormattedTextComponent("Page %s of %s", page, (int)Math.ceil((double)keys.size() / commandsPerPage) - 1), true);
        return 0;
    }

    private static void send(TextComponent component, CommandSource source) {
        source.func_197030_a((ITextComponent)component, true);
        CraftTweakerAPI.logDump(component.func_150254_d(), new Object[0]);
    }

    private static void send(TextComponent component, PlayerEntity player) {
        player.func_145747_a((ITextComponent)component);
        CraftTweakerAPI.logDump(component.func_150261_e(), new Object[0]);
    }

    private static String color(String str, TextFormatting formatting) {
        return formatting + str + TextFormatting.RESET;
    }

    private static String stripNewLine(String string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    private static String stripNewLine(StringBuilder string) {
        return string.substring(0, string.lastIndexOf("\n"));
    }

    public static TextComponent copy(TextComponent base, String toCopy) {
        base.func_211710_a(style -> {
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new FormattedTextComponent("Click to copy [%s]", CTCommands.color(toCopy, TextFormatting.GOLD))));
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/ct copy " + CTCommands.quoteAndEscape(toCopy) + ""));
        });
        return base;
    }

    public static TextComponent open(TextComponent base, String path) {
        base.func_211710_a(style -> {
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new FormattedTextComponent("Click to open [%s]", CTCommands.color(path, TextFormatting.GOLD))));
            style.func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_FILE, path));
        });
        return base;
    }

    public static TextComponent run(TextComponent base, String command) {
        base.func_211710_a(style -> {
            style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)new FormattedTextComponent("Click to run [%s]", CTCommands.color(command, TextFormatting.GOLD))));
            style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        });
        return base;
    }

    private static String quoteAndEscape(String p_193588_0_) {
        StringBuilder stringbuilder = new StringBuilder("\"");
        for (int i = 0; i < p_193588_0_.length(); ++i) {
            char c0 = p_193588_0_.charAt(i);
            if (c0 == '\\' || c0 == '\"') {
                stringbuilder.append('\\');
            }
            stringbuilder.append(c0);
        }
        return stringbuilder.append('\"').toString();
    }

    public static interface CommandCallerPlayer
    extends CommandCaller {
        @Override
        default public int executeCommand(CommandContext<CommandSource> context) throws CommandSyntaxException {
            return this.executeCommand((PlayerEntity)((CommandSource)context.getSource()).func_197035_h(), ((CommandSource)context.getSource()).func_197035_h().func_184614_ca());
        }

        public int executeCommand(PlayerEntity var1, ItemStack var2);
    }

    public static interface CommandCaller {
        public int executeCommand(CommandContext<CommandSource> var1) throws CommandSyntaxException;
    }

    public static class CommandImpl
    implements Comparable<CommandImpl> {
        private final String name;
        private final String description;
        private final CommandCaller caller;
        private final Map<String, CommandImpl> subCommands;

        public CommandImpl(String name, String description, CommandCaller caller) {
            this.name = name;
            this.description = description;
            this.caller = caller;
            this.subCommands = new TreeMap<String, CommandImpl>();
        }

        public String getName() {
            return this.name;
        }

        public CommandCaller getCaller() {
            return this.caller;
        }

        public String getDescription() {
            return this.description;
        }

        public void registerSubCommand(CommandImpl subCommand) {
            this.subCommands.put(subCommand.getName(), subCommand);
        }

        public Map<String, CommandImpl> getSubCommands() {
            return this.subCommands;
        }

        @Override
        public int compareTo(CommandImpl o) {
            return this.getName().compareTo(o.getName());
        }
    }
}

