/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedpipes.container;

import com.raoulvdberge.refinedpipes.RefinedPipes;
import com.raoulvdberge.refinedpipes.RefinedPipesContainers;
import com.raoulvdberge.refinedpipes.container.BaseContainer;
import com.raoulvdberge.refinedpipes.container.slot.FilterSlot;
import com.raoulvdberge.refinedpipes.container.slot.FluidFilterSlot;
import com.raoulvdberge.refinedpipes.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedpipes.message.ChangeBlacklistWhitelistMessage;
import com.raoulvdberge.refinedpipes.message.ChangeExactModeMessage;
import com.raoulvdberge.refinedpipes.message.ChangeRedstoneModeMessage;
import com.raoulvdberge.refinedpipes.message.ChangeRoutingModeMessage;
import com.raoulvdberge.refinedpipes.message.ChangeStackSizeMessage;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.extractor.BlacklistWhitelist;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.extractor.ExtractorAttachmentType;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.extractor.RedstoneMode;
import com.raoulvdberge.refinedpipes.network.pipe.attachment.extractor.RoutingMode;
import com.raoulvdberge.refinedpipes.util.FluidUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;

public class ExtractorAttachmentContainer
extends BaseContainer {
    private final BlockPos pos;
    private final Direction dir;
    private final ExtractorAttachmentType extractorAttachmentType;
    private final boolean fluidMode;
    private RedstoneMode redstoneMode;
    private BlacklistWhitelist blacklistWhitelist;
    private RoutingMode routingMode;
    private int stackSize;
    private boolean exactMode;

    public ExtractorAttachmentContainer(int windowId, PlayerEntity player, BlockPos pos, Direction dir, RedstoneMode redstoneMode, BlacklistWhitelist blacklistWhitelist, RoutingMode routingMode, int stackSize, boolean exactMode, ExtractorAttachmentType type, ItemStackHandler itemFilter, FluidInventory fluidFilter, boolean fluidMode) {
        super(RefinedPipesContainers.EXTRACTOR_ATTACHMENT, windowId, player);
        this.addPlayerInventory(8, 111);
        int x = 44;
        int y = 19;
        for (int i = 1; i <= type.getFilterSlots(); ++i) {
            if (fluidMode) {
                this.func_75146_a((Slot)new FluidFilterSlot(fluidFilter, i - 1, x, y));
            } else {
                this.func_75146_a((Slot)new FilterSlot((IItemHandler)itemFilter, i - 1, x, y));
            }
            if (i % 5 == 0) {
                x = 44;
                y += 18;
                continue;
            }
            x += 18;
        }
        this.pos = pos;
        this.dir = dir;
        this.extractorAttachmentType = type;
        this.fluidMode = fluidMode;
        this.redstoneMode = redstoneMode;
        this.blacklistWhitelist = blacklistWhitelist;
        this.routingMode = routingMode;
        this.stackSize = stackSize;
        this.exactMode = exactMode;
    }

    public boolean isFluidMode() {
        return this.fluidMode;
    }

    public ExtractorAttachmentType getExtractorAttachmentType() {
        return this.extractorAttachmentType;
    }

    public RedstoneMode getRedstoneMode() {
        return this.redstoneMode;
    }

    public BlacklistWhitelist getBlacklistWhitelist() {
        return this.blacklistWhitelist;
    }

    public RoutingMode getRoutingMode() {
        return this.routingMode;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public boolean isExactMode() {
        return this.exactMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.redstoneMode = redstoneMode;
        RefinedPipes.NETWORK.sendToServer(new ChangeRedstoneModeMessage(this.pos, this.dir, redstoneMode));
    }

    public void setBlacklistWhitelist(BlacklistWhitelist blacklistWhitelist) {
        this.blacklistWhitelist = blacklistWhitelist;
        RefinedPipes.NETWORK.sendToServer(new ChangeBlacklistWhitelistMessage(this.pos, this.dir, blacklistWhitelist));
    }

    public void setRoutingMode(RoutingMode routingMode) {
        this.routingMode = routingMode;
        RefinedPipes.NETWORK.sendToServer(new ChangeRoutingModeMessage(this.pos, this.dir, routingMode));
    }

    public void setStackSize(int stackSize) {
        this.stackSize = stackSize;
        RefinedPipes.NETWORK.sendToServer(new ChangeStackSizeMessage(this.pos, this.dir, stackSize));
    }

    public void setExactMode(boolean exactMode) {
        this.exactMode = exactMode;
        RefinedPipes.NETWORK.sendToServer(new ChangeExactModeMessage(this.pos, this.dir, exactMode));
    }

    public ItemStack func_82846_b(PlayerEntity player, int index) {
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d() && index < 36) {
            for (int i = 36; i < this.field_75151_b.size(); ++i) {
                SlotItemHandler itemSlot;
                Slot filterSlot = (Slot)this.field_75151_b.get(i);
                if (filterSlot instanceof FluidFilterSlot) {
                    FluidFilterSlot fluidSlot = (FluidFilterSlot)filterSlot;
                    if (!fluidSlot.getFluidInventory().getFluid(fluidSlot.getSlotIndex()).isEmpty()) continue;
                    FluidStack toInsert = (FluidStack)FluidUtil.getFromStack(slot.func_75211_c(), true).getValue();
                    boolean foundExistingFluid = false;
                    for (int j = 0; j < fluidSlot.getFluidInventory().getSlots(); ++j) {
                        if (!fluidSlot.getFluidInventory().getFluid(j).isFluidEqual(toInsert)) continue;
                        foundExistingFluid = true;
                        break;
                    }
                    if (foundExistingFluid) break;
                    fluidSlot.onContainerClicked(slot.func_75211_c());
                    break;
                }
                if (!(filterSlot instanceof SlotItemHandler) || (itemSlot = (SlotItemHandler)filterSlot).func_75216_d()) continue;
                ItemStack toInsert = ItemHandlerHelper.copyStackWithSize((ItemStack)slot.func_75211_c(), (int)1);
                boolean foundExistingItem = false;
                for (int j = 0; j < itemSlot.getItemHandler().getSlots(); ++j) {
                    if (!ItemStack.func_77989_b((ItemStack)itemSlot.getItemHandler().getStackInSlot(j), (ItemStack)toInsert)) continue;
                    foundExistingItem = true;
                    break;
                }
                if (foundExistingItem) break;
                itemSlot.func_75215_d(toInsert);
                break;
            }
        }
        return ItemStack.field_190927_a;
    }
}

