/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.event;

import cofh.lib.capability.CapabilityAOE;
import cofh.lib.capability.IAOEItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AOEHelper;
import cofh.lib.util.references.EnsorcellationReferences;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.HoeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class AOEEvents {
    private static boolean registered = false;
    private static final HashSet<PlayerEntity> HARVESTING_PLAYERS = new HashSet();
    private static final HashSet<PlayerEntity> TILLING_PLAYERS = new HashSet();

    public static void register() {
        if (registered) {
            return;
        }
        MinecraftForge.EVENT_BUS.register(AOEEvents.class);
        registered = true;
    }

    private AOEEvents() {
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleBlockBreakEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player = event.getPlayer();
        if (!(player instanceof ServerPlayerEntity) || Utils.isClientWorld(player.field_70170_p)) {
            return;
        }
        if (HARVESTING_PLAYERS.contains(player)) {
            return;
        }
        HARVESTING_PLAYERS.add(player);
        ItemStack stack = player.func_184614_ca();
        if (!AOEHelper.validAOEMiningItem(stack)) {
            return;
        }
        ImmutableList<BlockPos> areaBlocks = ((IAOEItem)stack.getCapability(CapabilityAOE.AOE_ITEM_CAPABILITY).orElse((Object)CapabilityAOE.DEFAULT_AOE_CAPABILITY)).getAOEBlocks(stack, event.getPos(), player);
        ServerPlayerEntity playerMP = (ServerPlayerEntity)player;
        for (BlockPos pos : areaBlocks) {
            if (stack.func_190926_b()) break;
            playerMP.field_71134_c.func_180237_b(pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void handleBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (!AOEHelper.validAOEMiningItem(stack)) {
            return;
        }
        ImmutableList<BlockPos> areaBlocks = ((IAOEItem)stack.getCapability(CapabilityAOE.AOE_ITEM_CAPABILITY).orElse((Object)CapabilityAOE.DEFAULT_AOE_CAPABILITY)).getAOEBlocks(stack, event.getPos(), player);
        float oldSpeed = event.getOriginalSpeed();
        float newSpeed = event.getNewSpeed();
        float curHardness = event.getState().func_185887_b((IBlockReader)player.field_70170_p, event.getPos());
        if (curHardness <= 0.0f) {
            return;
        }
        float maxHardness = AOEEvents.getMaxHardness((IBlockReader)player.field_70170_p, areaBlocks, curHardness);
        if (maxHardness > curHardness) {
            event.setNewSpeed(event.getOriginalSpeed() * curHardness / maxHardness);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void handleUseHoeEvent(UseHoeEvent event) {
        boolean weeding;
        if (event.isCanceled() || event.getResult() == Event.Result.ALLOW) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = event.getContext().func_195996_i();
        BlockPos target = event.getContext().func_195995_a();
        World world = player.field_70170_p;
        BlockState targetTilled = (BlockState)HoeItem.field_195973_b.get(world.func_180495_p(target).func_177230_c());
        BlockPos up = target.func_177984_a();
        boolean bl = weeding = EnchantmentHelper.func_77506_a((Enchantment)EnsorcellationReferences.WEEDING, (ItemStack)stack) > 0;
        if (targetTilled == null || !world.func_175623_d(up) && !weeding) {
            return;
        }
        if (Utils.isClientWorld(world)) {
            player.func_184609_a(event.getContext().func_221531_n());
            return;
        }
        if (TILLING_PLAYERS.contains(player)) {
            return;
        }
        TILLING_PLAYERS.add(player);
        ImmutableList<BlockPos> areaBlocks = ((IAOEItem)stack.getCapability(CapabilityAOE.AOE_ITEM_CAPABILITY).orElse((Object)CapabilityAOE.DEFAULT_AOE_CAPABILITY)).getAOEBlocks(stack, target, player);
        for (BlockPos pos : areaBlocks) {
            if (stack.func_190926_b()) break;
            BlockState tilled = (BlockState)HoeItem.field_195973_b.get(world.func_180495_p(pos).func_177230_c());
            if (tilled == null) continue;
            world.func_175656_a(pos, tilled);
            if (weeding && !world.func_175623_d(up = pos.func_177984_a())) {
                world.func_175655_b(up, !player.field_71075_bZ.field_75098_d);
            }
            stack.func_222118_a(1, (LivingEntity)player, consumer -> consumer.func_213334_d(event.getContext().func_221531_n()));
        }
        world.func_175656_a(target, targetTilled);
        if (weeding && !world.func_175623_d(up = target.func_177984_a())) {
            world.func_175655_b(up, !player.field_71075_bZ.field_75098_d);
        }
        world.func_184133_a(player, target, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, 1.0f);
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleTickEndEvent(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            HARVESTING_PLAYERS.clear();
            TILLING_PLAYERS.clear();
        }
    }

    private static float getMaxHardness(IBlockReader world, List<BlockPos> areaBlocks, float curHardness) {
        float maxHardness = curHardness;
        for (BlockPos pos : areaBlocks) {
            float testHardness = world.func_180495_p(pos).func_185887_b(world, pos);
            if (!(testHardness > maxHardness)) continue;
            maxHardness = testHardness;
        }
        return maxHardness;
    }
}

