/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.data;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import net.minecraftforge.client.model.generators.ModelFile;

public abstract class BlockStateProviderCoFH
extends BlockStateProvider {
    public static final String CROPS = "crops";
    public static final String ORES = "ores";
    public static final String RAILS = "rails";
    public static final String STORAGE = "storage";

    public BlockStateProviderCoFH(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        super(gen, modid, exFileHelper);
    }

    protected void oreBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), this.cubeAll(block, ORES));
    }

    protected void storageBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get(), this.cubeAll(block, STORAGE));
    }

    protected String name(Supplier<? extends Block> block) {
        return block.get().getRegistryName().func_110623_a();
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block) {
        ResourceLocation base = block.get().getRegistryName();
        return new ResourceLocation(base.func_110624_b(), "block/" + base.func_110623_a());
    }

    protected ResourceLocation blockTexture(Supplier<? extends Block> block, String subfolder) {
        ResourceLocation base = block.get().getRegistryName();
        return new ResourceLocation(base.func_110624_b(), "block/" + subfolder + "/" + base.func_110623_a());
    }

    protected ResourceLocation modBlockLoc(String texture) {
        return this.modLoc("block/" + texture);
    }

    protected ModelFile cubeAll(Supplier<? extends Block> block) {
        return this.cubeAll(block.get());
    }

    protected ModelFile cubeAll(Supplier<? extends Block> block, String subfolder) {
        return this.models().cubeAll(this.name(block), this.blockTexture(block, subfolder));
    }

    protected void simpleBlock(Supplier<? extends Block> block) {
        this.simpleBlock(block.get());
    }

    protected void simpleBlock(Supplier<? extends Block> block, ModelFile model) {
        this.simpleBlock(block.get(), model);
    }

    protected void simpleBlock(Supplier<? extends Block> block, Function<ModelFile, ConfiguredModel[]> expander) {
        this.simpleBlock(block.get(), expander);
    }

    protected void axisBlock(Supplier<? extends RotatedPillarBlock> block, String texture) {
        this.axisBlock(block.get(), this.modBlockLoc(texture));
    }

    protected void stairsBlock(Supplier<? extends StairsBlock> block, String name) {
        this.stairsBlock(block, name, name);
    }

    protected void stairsBlock(Supplier<? extends StairsBlock> block, String side, String topBottom) {
        this.stairsBlock(block.get(), this.modBlockLoc(side), this.modBlockLoc(topBottom), this.modBlockLoc(topBottom));
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab) {
        this.slabBlock(block, doubleslab, this.name(doubleslab));
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab, String texture) {
        this.slabBlock(block, doubleslab, texture, texture);
    }

    protected void slabBlock(Supplier<? extends SlabBlock> block, Supplier<? extends Block> doubleslab, String side, String end) {
        this.slabBlock(block.get(), doubleslab.get().getRegistryName(), this.modBlockLoc(side), this.modBlockLoc(end), this.modBlockLoc(end));
    }

    protected void doorBlock(Supplier<? extends DoorBlock> block) {
        this.doorBlock(block.get(), this.modBlockLoc(this.name(block) + "_bottom"), this.modBlockLoc(this.name(block) + "_top"));
    }

    protected void trapdoorBlock(Supplier<? extends TrapDoorBlock> block) {
        this.trapdoorBlock(block.get(), this.blockTexture(block), true);
    }
}

