/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.item;

import cofh.lib.fluid.FluidEnchantableItemWrapper;
import cofh.lib.fluid.IFluidContainerItem;
import cofh.lib.item.IColorableItem;
import cofh.lib.item.ItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.FluidHelper;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.references.CoreReferences;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidContainerItem
extends ItemCoFH
implements IFluidContainerItem,
IColorableItem {
    protected Predicate<FluidStack> validator;
    protected int fluidCapacity;

    public FluidContainerItem(Item.Properties builder, int fluidCapacity, Predicate<FluidStack> validator) {
        super(builder);
        this.fluidCapacity = fluidCapacity;
        this.validator = validator;
    }

    public FluidContainerItem(Item.Properties builder, int fluidCapacity) {
        this(builder, fluidCapacity, e -> true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        FluidStack fluid = this.getFluid(stack);
        if (fluid.isEmpty()) {
            tooltip.add(StringHelper.getTextComponent(StringHelper.localize("info.cofh.fluid") + ": " + StringHelper.localize("info.cofh.empty")));
        }
        if (this.isCreative()) {
            tooltip.add(StringHelper.getTextComponent("info.cofh.infinite_source"));
        } else {
            tooltip.add(StringHelper.getTextComponent(StringHelper.localize("info.cofh.level") + ": " + StringHelper.format(fluid.getAmount()) + " / " + StringHelper.format(this.getCapacity(stack)) + " mB"));
        }
        if (FluidHelper.hasPotionTag(fluid)) {
            tooltip.add(StringHelper.getEmptyLine());
            tooltip.add(StringHelper.getTextComponent(StringHelper.localize("info.cofh.effects.") + ":"));
            FluidHelper.addPotionTooltip(fluid, tooltip);
        }
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || !ItemHelper.areItemStacksEqualIgnoreTags(oldStack, newStack, "Fluid"));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return !this.isCreative() && this.getFluidAmount(stack) > 0;
    }

    public int getItemEnchantability(ItemStack stack) {
        return this.enchantability;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return MathHelper.clamp(1.0 - (double)this.getFluidAmount(stack) / (double)this.getCapacity(stack), 0.0, 1.0);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        ArrayList<Enchantment> enchants = new ArrayList<Enchantment>();
        if (CoreReferences.HOLDING != null) {
            enchants.add(CoreReferences.HOLDING);
        }
        return new FluidEnchantableItemWrapper(stack, this, enchants);
    }

    @Override
    public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return this.validator.test(resource);
    }

    @Override
    public int getCapacity(ItemStack container) {
        return Utils.getEnchantedCapacity(this.fluidCapacity, EnchantmentHelper.func_77506_a((Enchantment)CoreReferences.HOLDING, (ItemStack)container));
    }

    @Override
    public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        if (container.func_77978_p() == null) {
            container.func_77982_d(new CompoundNBT());
        }
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (this.isCreative()) {
            if (action.execute()) {
                CompoundNBT fluidTag = resource.writeToNBT(new CompoundNBT());
                fluidTag.func_74768_a("Amount", capacity - 1000);
                container.func_77978_p().func_218657_a("Fluid", (INBT)fluidTag);
            }
            return resource.getAmount();
        }
        if (action.simulate()) {
            if (!container.func_77978_p().func_74764_b("Fluid")) {
                return Math.min(capacity, resource.getAmount());
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)container.func_77978_p().func_74775_l("Fluid"));
            if (stack.isEmpty()) {
                return Math.min(capacity, resource.getAmount());
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.getAmount(), resource.getAmount());
        }
        if (!container.func_77978_p().func_74764_b("Fluid")) {
            CompoundNBT fluidTag = resource.writeToNBT(new CompoundNBT());
            if (capacity < resource.getAmount()) {
                fluidTag.func_74768_a("Amount", capacity);
                container.func_77978_p().func_218657_a("Fluid", (INBT)fluidTag);
                return capacity;
            }
            fluidTag.func_74768_a("Amount", resource.getAmount());
            container.func_77978_p().func_218657_a("Fluid", (INBT)fluidTag);
            return resource.getAmount();
        }
        CompoundNBT fluidTag = container.func_77978_p().func_74775_l("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidTag);
        if (stack.isEmpty() || !stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.getAmount();
        if (resource.getAmount() < filled) {
            stack.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            stack.setAmount(capacity);
        }
        container.func_77978_p().func_218657_a("Fluid", (INBT)stack.writeToNBT(fluidTag));
        return filled;
    }

    @Override
    public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        int drained;
        if (container.func_77978_p() == null) {
            container.func_77982_d(new CompoundNBT());
        }
        if (!container.func_77978_p().func_74764_b("Fluid") || maxDrain == 0) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundNBT)container.func_77978_p().func_74775_l("Fluid"));
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        int n = drained = this.isCreative() ? maxDrain : Math.min(stack.getAmount(), maxDrain);
        if (action.execute() && !this.isCreative()) {
            if (maxDrain >= stack.getAmount()) {
                container.func_77978_p().func_82580_o("Fluid");
                return stack;
            }
            CompoundNBT fluidTag = container.func_77978_p().func_74775_l("Fluid");
            fluidTag.func_74768_a("Amount", fluidTag.func_74762_e("Amount") - drained);
            container.func_77978_p().func_218657_a("Fluid", (INBT)fluidTag);
        }
        stack.setAmount(drained);
        return stack;
    }
}

