/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.crafting.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.darkhax.bookshelf.crafting.block.BlockListResolver;
import net.darkhax.bookshelf.crafting.block.BlockResolver;
import net.darkhax.bookshelf.crafting.block.BlockTagResolver;
import net.darkhax.bookshelf.crafting.block.IBlockResolver;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;

public class BlockIngredient
implements Predicate<Block> {
    public static final ResourceLocation TYPE_BLOCK = new ResourceLocation("bookshelf", "block");
    public static final ResourceLocation TYPE_BLOCK_LIST = new ResourceLocation("bookshelf", "block_list");
    public static final ResourceLocation TYPE_BLOCK_TAG = new ResourceLocation("bookshelf", "block_tag");
    private static Map<ResourceLocation, Function<PacketBuffer, IBlockResolver>> packetDeserializers = new HashMap<ResourceLocation, Function<PacketBuffer, IBlockResolver>>();
    private static Map<ResourceLocation, Function<JsonObject, IBlockResolver>> jsonDeserializers = new HashMap<ResourceLocation, Function<JsonObject, IBlockResolver>>();
    private final IBlockResolver[] resolvers;
    private List<Block> validBlocks;

    public BlockIngredient(IBlockResolver ... resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public boolean test(Block toTest) {
        this.determineMatchingBlocks();
        if (toTest != null && this.validBlocks != null && !this.validBlocks.isEmpty()) {
            return this.validBlocks.contains(toTest);
        }
        return false;
    }

    private void determineMatchingBlocks() {
        if (this.validBlocks == null) {
            this.validBlocks = Collections.unmodifiableList(Arrays.stream(this.resolvers).flatMap(resolver -> resolver.resolveBlocks().stream()).distinct().collect(Collectors.toList()));
        }
    }

    public void invalidate() {
        this.validBlocks = null;
    }

    public JsonElement serialize() {
        if (this.resolvers.length == 1) {
            return this.resolvers[0].serialize();
        }
        JsonArray resolverArray = new JsonArray();
        for (IBlockResolver resolver : this.resolvers) {
            resolverArray.add((JsonElement)resolver.serialize());
        }
        return resolverArray;
    }

    public void serialize(PacketBuffer buffer) {
        buffer.writeInt(this.resolvers.length);
        for (IBlockResolver resolver : this.resolvers) {
            resolver.serialize(buffer);
        }
    }

    public List<Block> getValidBlocks() {
        this.determineMatchingBlocks();
        return this.validBlocks;
    }

    public static BlockIngredient deserialize(PacketBuffer buffer) {
        int count = buffer.readInt();
        IBlockResolver[] blockResolvers = new IBlockResolver[count];
        for (int i = 0; i < count; ++i) {
            ResourceLocation typeId = ResourceLocation.func_208304_a((String)buffer.func_218666_n());
            if (typeId == null) continue;
            blockResolvers[i] = packetDeserializers.get(typeId).apply(buffer);
        }
        return new BlockIngredient(blockResolvers);
    }

    public static BlockIngredient deserialize(JsonElement json) {
        IBlockResolver[] blockResolvers = null;
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            blockResolvers = new IBlockResolver[array.size()];
            for (int i = 0; i < blockResolvers.length; ++i) {
                JsonElement element = array.get(i);
                if (!element.isJsonObject()) continue;
                JsonObject object = element.getAsJsonObject();
                ResourceLocation typeId = ResourceLocation.func_208304_a((String)object.get("type").getAsString());
                blockResolvers[i] = jsonDeserializers.get(typeId).apply(object);
            }
        } else if (json.isJsonObject()) {
            JsonObject jsonObject = json.getAsJsonObject();
            blockResolvers = new IBlockResolver[1];
            ResourceLocation typeId = ResourceLocation.func_208304_a((String)jsonObject.get("type").getAsString());
            blockResolvers[0] = jsonDeserializers.get(typeId).apply(jsonObject);
        } else {
            throw new IllegalArgumentException("Tried to deserialize from an unsupported json type! " + json.toString());
        }
        return new BlockIngredient(blockResolvers);
    }

    static {
        packetDeserializers.put(TYPE_BLOCK, BlockResolver::deserialize);
        packetDeserializers.put(TYPE_BLOCK_LIST, BlockListResolver::deserialize);
        packetDeserializers.put(TYPE_BLOCK_TAG, BlockTagResolver::deserialize);
        jsonDeserializers.put(TYPE_BLOCK, BlockResolver::deserialize);
        jsonDeserializers.put(TYPE_BLOCK_LIST, BlockListResolver::deserialize);
        jsonDeserializers.put(TYPE_BLOCK_TAG, BlockTagResolver::deserialize);
    }
}

