/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.item;

import com.stal111.forbidden_arcanus.init.ModItems;
import com.stal111.forbidden_arcanus.item.EdelwoodBucketItem;
import com.stal111.forbidden_arcanus.item.ICapacityBucket;
import com.stal111.forbidden_arcanus.util.ItemStackUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.passive.fish.AbstractFishEntity;
import net.minecraft.entity.passive.fish.TropicalFishEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EdelwoodFishBucketItem
extends EdelwoodBucketItem {
    private final EntityType<?> fishType;

    public EdelwoodFishBucketItem(EntityType<?> fishType, Fluid containedFluidIn, int capacity, Item.Properties builder) {
        super(containedFluidIn, capacity, builder);
        this.fishType = fishType;
    }

    @Override
    public void onLiquidPlaced(World world, ItemStack stack, BlockPos pos) {
        if (!world.func_201670_d()) {
            this.placeFish(world, stack, pos);
        }
        super.onLiquidPlaced(world, stack, pos);
    }

    @Override
    protected ItemStack emptyBucket(ItemStack stack, PlayerEntity player) {
        if (!player.field_71075_bZ.field_75098_d) {
            int fullness = ICapacityBucket.getFullness(stack);
            if (fullness - 1 > 0) {
                return ICapacityBucket.setFullness(ItemStackUtils.transferEnchantments(stack, new ItemStack((IItemProvider)ModItems.EDELWOOD_WATER_BUCKET.get())), fullness - 1);
            }
            return ItemStackUtils.transferEnchantments(stack, new ItemStack((IItemProvider)ModItems.EDELWOOD_BUCKET.get()));
        }
        return stack;
    }

    @Override
    protected void playEmptySound(@Nullable PlayerEntity player, IWorld world, BlockPos pos) {
        world.func_184133_a(player, pos, SoundEvents.field_203819_X, SoundCategory.NEUTRAL, 1.0f, 1.0f);
    }

    private void placeFish(World world, ItemStack stack, BlockPos pos) {
        Entity entity = this.fishType.func_220331_a(world, stack, null, pos, SpawnReason.BUCKET, true, false);
        if (entity instanceof AbstractFishEntity) {
            ((AbstractFishEntity)entity).func_203706_r(true);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        CompoundNBT compoundNBT;
        super.func_77624_a(stack, world, tooltip, flag);
        if (this.fishType == EntityType.field_204262_at && (compoundNBT = stack.func_77978_p()) != null && compoundNBT.func_150297_b("BucketVariantTag", 3)) {
            int variant = compoundNBT.func_74762_e("BucketVariantTag");
            TextFormatting[] lvt_7_1_ = new TextFormatting[]{TextFormatting.ITALIC, TextFormatting.GRAY};
            String lvt_8_1_ = "color.minecraft." + TropicalFishEntity.func_212326_d((int)variant);
            String lvt_9_1_ = "color.minecraft." + TropicalFishEntity.func_212323_p((int)variant);
            for (int lvt_10_1_ = 0; lvt_10_1_ < TropicalFishEntity.field_204227_bz.length; ++lvt_10_1_) {
                if (variant != TropicalFishEntity.field_204227_bz[lvt_10_1_]) continue;
                tooltip.add(new TranslationTextComponent(TropicalFishEntity.func_212324_b((int)lvt_10_1_), new Object[0]).func_211709_a(lvt_7_1_));
                return;
            }
            tooltip.add(new TranslationTextComponent(TropicalFishEntity.func_212327_q((int)variant), new Object[0]).func_211709_a(lvt_7_1_));
            TranslationTextComponent textComponent = new TranslationTextComponent(lvt_8_1_, new Object[0]);
            if (!lvt_8_1_.equals(lvt_9_1_)) {
                textComponent.func_150258_a(", ").func_150257_a((ITextComponent)new TranslationTextComponent(lvt_9_1_, new Object[0]));
            }
            textComponent.func_211709_a(lvt_7_1_);
            tooltip.add((ITextComponent)textComponent);
        }
    }
}

