/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.item.blockitem;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.grid.factory.PortableGridGridFactory;
import com.raoulvdberge.refinedstorage.item.WirelessGridItem;
import com.raoulvdberge.refinedstorage.item.blockitem.EnergyBlockItem;
import com.raoulvdberge.refinedstorage.render.Styles;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class PortableGridBlockItem
extends EnergyBlockItem {
    private final Type type;

    public PortableGridBlockItem(Type type) {
        super(type == Type.CREATIVE ? RSBlocks.CREATIVE_PORTABLE_GRID : RSBlocks.PORTABLE_GRID, new Item.Properties().func_200916_a(RS.MAIN_GROUP).func_200917_a(1), type == Type.CREATIVE, () -> RS.SERVER_CONFIG.getPortableGrid().getCapacity());
        this.type = type;
        this.setRegistryName("refinedstorage", (type == Type.CREATIVE ? "creative_" : "") + "portable_grid");
    }

    public Type getType() {
        return this.type;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            API.instance().getGridManager().openGrid(PortableGridGridFactory.ID, (ServerPlayerEntity)player, stack, player.field_71071_by.field_70461_c);
        }
        return ActionResult.func_226248_a_((Object)stack);
    }

    @Override
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        tooltip.add(new TranslationTextComponent("block.refinedstorage.portable_grid.tooltip", new Object[0]).func_150255_a(Styles.GRAY));
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        if (!context.func_195999_j().func_213453_ef()) {
            return ActionResultType.FAIL;
        }
        return super.func_195939_a(context);
    }

    public int getEntityLifespan(ItemStack stack, World world) {
        return Integer.MAX_VALUE;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (oldStack.func_77973_b() == newStack.func_77973_b() && WirelessGridItem.getSortingDirection(oldStack) == WirelessGridItem.getSortingDirection(newStack) && WirelessGridItem.getSortingType(oldStack) == WirelessGridItem.getSortingType(newStack) && WirelessGridItem.getSearchBoxMode(oldStack) == WirelessGridItem.getSearchBoxMode(newStack) && WirelessGridItem.getTabSelected(oldStack) == WirelessGridItem.getTabSelected(newStack) && WirelessGridItem.getTabPage(oldStack) == WirelessGridItem.getTabPage(newStack) && WirelessGridItem.getSize(oldStack) == WirelessGridItem.getSize(newStack)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public static enum Type {
        NORMAL,
        CREATIVE;

    }
}

