/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.toolbelt.slot;

import com.google.common.collect.ImmutableList;
import gigaherz.toolbelt.ConfigData;
import gigaherz.toolbelt.ToolBelt;
import gigaherz.toolbelt.customslots.ExtensionSlotItemHandler;
import gigaherz.toolbelt.customslots.IExtensionContainer;
import gigaherz.toolbelt.customslots.IExtensionSlot;
import gigaherz.toolbelt.network.SyncBeltSlotContents;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.GameRules;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class BeltExtensionSlot
implements IExtensionContainer,
INBTSerializable<CompoundNBT> {
    private static final ResourceLocation CAPABILITY_ID = new ResourceLocation("toolbelt", "belt_slot");
    @CapabilityInject(value=BeltExtensionSlot.class)
    public static Capability<BeltExtensionSlot> CAPABILITY = null;
    public static final ResourceLocation BELT = new ResourceLocation("examplemod", "belt");
    private final LivingEntity owner;
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            BeltExtensionSlot.this.belt.onContentsChanged();
        }
    };
    private final ExtensionSlotItemHandler belt = new ExtensionSlotItemHandler(this, BELT, (IItemHandlerModifiable)this.inventory, 0);
    private final ImmutableList<IExtensionSlot> slots = ImmutableList.of((Object)this.belt);

    public static void register() {
        CapabilityManager.INSTANCE.register(BeltExtensionSlot.class, (Capability.IStorage)new Capability.IStorage<BeltExtensionSlot>(){

            @Nullable
            public INBT writeNBT(Capability<BeltExtensionSlot> capability, BeltExtensionSlot instance, Direction side) {
                return instance.serializeNBT();
            }

            public void readNBT(Capability<BeltExtensionSlot> capability, BeltExtensionSlot instance, Direction side, INBT nbt) {
                instance.deserializeNBT((CompoundNBT)nbt);
            }
        }, () -> {
            throw new RuntimeException("Can not instantiate this way. The capability needs a player as context.");
        });
        MinecraftForge.EVENT_BUS.register((Object)new AttachHandlers());
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlers());
    }

    public static LazyOptional<BeltExtensionSlot> get(LivingEntity player) {
        return player.getCapability(CAPABILITY);
    }

    private void dropContents() {
        for (IExtensionSlot slot : this.slots) {
            ItemStack stack = slot.getContents();
            if (stack.func_190916_E() <= 0) continue;
            if (this.owner instanceof PlayerEntity) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)((PlayerEntity)this.owner), (ItemStack)stack);
            } else {
                this.owner.func_70099_a(stack, 0.1f);
            }
            slot.setContents(ItemStack.field_190927_a);
        }
    }

    private void syncToSelf() {
        this.syncTo((PlayerEntity)this.owner);
    }

    protected void syncTo(PlayerEntity target) {
        SyncBeltSlotContents message = new SyncBeltSlotContents((PlayerEntity)this.owner, this);
        ToolBelt.channel.sendTo((Object)message, ((ServerPlayerEntity)target).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
    }

    protected void syncTo(PacketDistributor.PacketTarget target) {
        SyncBeltSlotContents message = new SyncBeltSlotContents((PlayerEntity)this.owner, this);
        ToolBelt.channel.send(target, (Object)message);
    }

    private BeltExtensionSlot(LivingEntity owner) {
        this.owner = owner;
    }

    @Override
    @Nonnull
    public LivingEntity getOwner() {
        return this.owner;
    }

    @Override
    @Nonnull
    public ImmutableList<IExtensionSlot> getSlots() {
        return this.slots;
    }

    @Override
    public void onContentsChanged(IExtensionSlot slot) {
    }

    @Nonnull
    public IExtensionSlot getBelt() {
        return this.belt;
    }

    private void tickAllSlots() {
        for (IExtensionSlot slot : this.slots) {
            ((ExtensionSlotItemHandler)slot).onWornTick();
        }
    }

    public void setAll(NonNullList<ItemStack> stacks) {
        ImmutableList<IExtensionSlot> slots = this.getSlots();
        for (int i = 0; i < slots.size(); ++i) {
            ((IExtensionSlot)slots.get(i)).setContents((ItemStack)stacks.get(i));
        }
    }

    public CompoundNBT serializeNBT() {
        return this.inventory.serializeNBT();
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.inventory.deserializeNBT(nbt);
    }

    private static class EventHandlers {
        private EventHandlers() {
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerLoggedInEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            PlayerEntity target = event.getPlayer();
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            BeltExtensionSlot.get((LivingEntity)target).ifPresent(rec$ -> ((BeltExtensionSlot)rec$).syncToSelf());
        }

        @SubscribeEvent
        public void joinWorld(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            PlayerEntity target = event.getPlayer();
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            BeltExtensionSlot.get((LivingEntity)target).ifPresent(rec$ -> ((BeltExtensionSlot)rec$).syncToSelf());
        }

        @SubscribeEvent
        public void track(PlayerEvent.StartTracking event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            Entity target = event.getTarget();
            if (target.field_70170_p.field_72995_K) {
                return;
            }
            if (target instanceof PlayerEntity) {
                BeltExtensionSlot.get((LivingEntity)target).ifPresent(rec$ -> ((BeltExtensionSlot)rec$).syncToSelf());
            }
        }

        @SubscribeEvent
        public void entityTick(TickEvent.PlayerTickEvent event) {
            if (event.phase != TickEvent.Phase.END) {
                return;
            }
            if (ConfigData.customBeltSlotEnabled) {
                BeltExtensionSlot.get((LivingEntity)event.player).ifPresent(rec$ -> ((BeltExtensionSlot)rec$).tickAllSlots());
            } else {
                BeltExtensionSlot.get((LivingEntity)event.player).ifPresent(rec$ -> ((BeltExtensionSlot)rec$).dropContents());
            }
        }

        @SubscribeEvent
        public void playerDeath(LivingDropsEvent event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            if (event.getEntityLiving() instanceof PlayerEntity) {
                PlayerEntity player = (PlayerEntity)event.getEntityLiving();
                BeltExtensionSlot.get((LivingEntity)player).ifPresent(instance -> {
                    IExtensionSlot belt = instance.getBelt();
                    ItemStack stack = belt.getContents();
                    if (EnchantmentHelper.func_190939_c((ItemStack)stack)) {
                        stack = ItemStack.field_190927_a;
                        belt.setContents(stack);
                    }
                    if (!player.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c) && !player.func_175149_v() && stack.func_190916_E() > 0) {
                        Collection old = player.captureDrops(event.getDrops());
                        player.func_146097_a(stack, true, false);
                        player.captureDrops(old);
                        belt.setContents(ItemStack.field_190927_a);
                    }
                });
            }
        }

        @SubscribeEvent
        public void playerClone(PlayerEvent.Clone event) {
            if (!ConfigData.customBeltSlotEnabled) {
                return;
            }
            PlayerEntity oldPlayer = event.getOriginal();
            oldPlayer.revive();
            PlayerEntity newPlayer = event.getPlayer();
            BeltExtensionSlot.get((LivingEntity)oldPlayer).ifPresent(oldBelt -> {
                BeltExtensionSlot newBelt = (BeltExtensionSlot)BeltExtensionSlot.get((LivingEntity)newPlayer).orElse(null);
                ItemStack stack = oldBelt.getBelt().getContents();
                if (newBelt == null) {
                    if (stack.func_190916_E() > 0) {
                        oldPlayer.func_146097_a(stack, true, false);
                    }
                } else {
                    newBelt.getBelt().setContents(stack);
                }
            });
        }
    }

    static class AttachHandlers {
        AttachHandlers() {
        }

        @SubscribeEvent
        public void attachCapabilities(final AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(CAPABILITY_ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                    final BeltExtensionSlot extensionContainer;
                    final LazyOptional<BeltExtensionSlot> extensionContainerSupplier;
                    {
                        this.extensionContainer = new BeltExtensionSlot((LivingEntity)((PlayerEntity)event.getObject())){

                            @Override
                            public void onContentsChanged(IExtensionSlot slot) {
                                if (!ConfigData.customBeltSlotEnabled) {
                                    return;
                                }
                                if (!this.getOwner().field_70170_p.field_72995_K) {
                                    this.syncTo(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(this::getOwner));
                                }
                            }
                        };
                        this.extensionContainerSupplier = LazyOptional.of(() -> this.extensionContainer);
                    }

                    public CompoundNBT serializeNBT() {
                        return this.extensionContainer.serializeNBT();
                    }

                    public void deserializeNBT(CompoundNBT nbt) {
                        this.extensionContainer.deserializeNBT(nbt);
                    }

                    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
                        if (CAPABILITY == capability) {
                            return this.extensionContainerSupplier.cast();
                        }
                        return LazyOptional.empty();
                    }
                });
            }
        }
    }
}

