/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.google.common.collect.Lists;
import com.mojang.util.QueueLogAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.PlayerListComponent;
import net.minecraft.server.gui.StatsComponent;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftServerGui
extends JComponent {
    private static final Font field_164249_a = new Font("Monospaced", 0, 12);
    private static final Logger field_164248_b = LogManager.getLogger();
    private final DedicatedServer field_120021_b;
    private Thread field_206932_d;
    private final Collection<Runnable> field_219051_e = Lists.newArrayList();
    private final AtomicBoolean field_219052_f = new AtomicBoolean();
    private CountDownLatch latch = new CountDownLatch(1);

    public static MinecraftServerGui func_219048_a(final DedicatedServer p_219048_0_) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame jframe = new JFrame("Minecraft server");
        final MinecraftServerGui minecraftservergui = new MinecraftServerGui(p_219048_0_);
        jframe.setDefaultCloseOperation(2);
        jframe.add(minecraftservergui);
        jframe.pack();
        jframe.setLocationRelativeTo(null);
        jframe.setVisible(true);
        jframe.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent p_windowClosing_1_) {
                if (!minecraftservergui.field_219052_f.getAndSet(true)) {
                    jframe.setTitle("Minecraft server - shutting down!");
                    p_219048_0_.func_71263_m(true);
                    minecraftservergui.func_219046_f();
                }
            }
        });
        minecraftservergui.func_219045_a(jframe::dispose);
        minecraftservergui.func_206931_a();
        return minecraftservergui;
    }

    private MinecraftServerGui(DedicatedServer serverIn) {
        this.field_120021_b = serverIn;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.func_120018_d(), "Center");
            this.add((Component)this.func_120019_b(), "West");
        }
        catch (Exception exception) {
            field_164248_b.error("Couldn't build server GUI", (Throwable)exception);
        }
    }

    public void func_219045_a(Runnable p_219045_1_) {
        this.field_219051_e.add(p_219045_1_);
    }

    private JComponent func_120019_b() {
        JPanel jpanel = new JPanel(new BorderLayout());
        StatsComponent statscomponent = new StatsComponent((MinecraftServer)this.field_120021_b);
        this.field_219051_e.add(() -> ((StatsComponent)statscomponent).func_219053_a());
        jpanel.add((Component)statscomponent, "North");
        jpanel.add((Component)this.func_120020_c(), "Center");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jpanel;
    }

    private JComponent func_120020_c() {
        PlayerListComponent jlist = new PlayerListComponent((MinecraftServer)this.field_120021_b);
        JScrollPane jscrollpane = new JScrollPane((Component)jlist, 22, 30);
        jscrollpane.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return jscrollpane;
    }

    private JComponent func_120018_d() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JTextArea jtextarea = new JTextArea();
        JScrollPane jscrollpane = new JScrollPane(jtextarea, 22, 30);
        jtextarea.setEditable(false);
        jtextarea.setFont(field_164249_a);
        JTextField jtextfield = new JTextField();
        jtextfield.addActionListener(p_210465_2_ -> {
            String s = jtextfield.getText().trim();
            if (!s.isEmpty()) {
                this.field_120021_b.func_195581_a(s, this.field_120021_b.func_195573_aM());
            }
            jtextfield.setText("");
        });
        jtextarea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent p_focusGained_1_) {
            }
        });
        jpanel.add((Component)jscrollpane, "Center");
        jpanel.add((Component)jtextfield, "South");
        jpanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        this.field_206932_d = new Thread(() -> {
            String s;
            while ((s = QueueLogAppender.getNextLogEvent((String)"ServerGuiConsole")) != null) {
                this.func_164247_a(jtextarea, jscrollpane, s);
            }
        });
        this.field_206932_d.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_164248_b));
        this.field_206932_d.setDaemon(true);
        return jpanel;
    }

    public void func_206931_a() {
        this.field_206932_d.start();
        this.latch.countDown();
    }

    public void func_219050_b() {
        if (!this.field_219052_f.getAndSet(true)) {
            this.func_219046_f();
        }
    }

    private void func_219046_f() {
        this.field_219051_e.forEach(Runnable::run);
    }

    public void func_164247_a(JTextArea textArea, JScrollPane scrollPane, String line) {
        try {
            this.latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.func_164247_a(textArea, scrollPane, line));
        } else {
            Document document = textArea.getDocument();
            JScrollBar jscrollbar = scrollPane.getVerticalScrollBar();
            boolean flag = false;
            if (scrollPane.getViewport().getView() == textArea) {
                flag = (double)jscrollbar.getValue() + jscrollbar.getSize().getHeight() + (double)(field_164249_a.getSize() * 4) > (double)jscrollbar.getMaximum();
            }
            try {
                document.insertString(document.getLength(), line, null);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (flag) {
                jscrollbar.setValue(Integer.MAX_VALUE);
            }
        }
    }
}

